/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.tileentity;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.trees.Species;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;

public class PottedSaplingTileEntity
extends TileEntity {
    private static final String POT_MIMIC_TAG = "pot_mimic";
    private static final String SPECIES_TAG = "species";
    public static final ModelProperty<BlockState> POT_MIMIC = new ModelProperty();
    public static final ModelProperty<Species> SPECIES = new ModelProperty();
    private BlockState potState = Blocks.field_150457_bL.func_176223_P();
    private Species species = Species.NULL_SPECIES;

    public PottedSaplingTileEntity() {
        super(DTRegistries.bonsaiTE);
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        this.species = species;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public BlockState getPot() {
        return this.potState;
    }

    public void setPot(BlockState newPotState) {
        this.potState = newPotState.func_177230_c() instanceof FlowerPotBlock ? newPotState.func_177230_c().func_176223_P() : Blocks.field_150457_bL.func_176223_P();
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        this.func_189515_b(tag);
        return tag;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        BlockState oldPotState = this.potState;
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
        if (!oldPotState.equals(this.potState)) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        if (tag.func_74764_b(POT_MIMIC_TAG)) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.func_74779_i(POT_MIMIC_TAG)));
            BlockState blockState = this.potState = block != Blocks.field_150350_a ? block.func_176223_P() : Blocks.field_150457_bL.func_176223_P();
        }
        if (tag.func_74764_b(SPECIES_TAG)) {
            this.species = TreeRegistry.findSpecies(tag.func_74779_i(SPECIES_TAG));
        }
        super.func_230337_a_(state, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74778_a(POT_MIMIC_TAG, this.potState.func_177230_c().getRegistryName().toString());
        tag.func_74778_a(SPECIES_TAG, this.species.getRegistryName().toString());
        return super.func_189515_b(tag);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(POT_MIMIC, (Object)this.potState).withInitial(SPECIES, (Object)this.species).build();
    }
}

