/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.data.BranchItemModelGenerator;
import com.ferreusveritas.dynamictrees.api.data.BranchStateGenerator;
import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.data.StrippedBranchStateGenerator;
import com.ferreusveritas.dynamictrees.api.data.SurfaceRootStateGenerator;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.branches.BasicBranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.SurfaceRootBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.ThickBranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.cells.MetadataCell;
import com.ferreusveritas.dynamictrees.compat.waila.WailaOther;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.data.DTItemTags;
import com.ferreusveritas.dynamictrees.data.provider.BranchLoaderBuilder;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTItemModelProvider;
import com.ferreusveritas.dynamictrees.entities.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.entities.animation.AnimationHandler;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.trees.Resettable;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.MutableLazyValue;
import com.ferreusveritas.dynamictrees.util.Optionals;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class Family
extends RegistryEntry<Family>
implements Resettable<Family> {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(Family::new);
    public static final Family NULL_FAMILY = new Family(){

        @Override
        public void setupCommonSpecies(Species species) {
        }

        @Override
        public Species getCommonSpecies() {
            return Species.NULL_SPECIES;
        }

        @Override
        public boolean onTreeActivated(TreeActivationContext context) {
            return false;
        }

        @Override
        public ItemStack getStick(int qty) {
            return ItemStack.field_190927_a;
        }

        @Override
        public BranchBlock getValidBranchBlock(int index) {
            return null;
        }

        @Override
        public Species getSpeciesForLocation(IWorld world, BlockPos trunkPos) {
            return Species.NULL_SPECIES;
        }
    };
    public static final TypedRegistry<Family> REGISTRY = new TypedRegistry<Family>(Family.class, NULL_FAMILY, TYPE);
    protected Species commonSpecies;
    protected LeavesProperties commonLeaves = LeavesProperties.NULL;
    private BranchBlock branch;
    private BranchBlock strippedBranch;
    private Item branchItem;
    private SurfaceRootBlock surfaceRoot;
    private Block primitiveLog = Blocks.field_150350_a;
    private Block primitiveStrippedLog = Blocks.field_150350_a;
    private final List<BranchBlock> validBranches = new LinkedList<BranchBlock>();
    private int maxBranchRadius = 8;
    protected boolean hasConiferVariants = false;
    protected boolean hasSurfaceRoot = false;
    protected boolean hasStrippedBranch = true;
    private Item stick = Items.field_151055_y;
    @OnlyIn(value=Dist.CLIENT)
    public int woodRingColor;
    @OnlyIn(value=Dist.CLIENT)
    public int woodBarkColor;
    private final Set<Species> species = new HashSet<Species>();
    private boolean isFireProof = false;
    private AbstractBlock.Properties properties;
    private int primaryThickness = 1;
    private int secondaryThickness = 2;
    private boolean branchIsLadder = true;
    private int maxSignalDepth = 32;
    protected final MutableLazyValue<Generator<DTBlockStateProvider, Family>> branchStateGenerator = MutableLazyValue.supplied(BranchStateGenerator::new);
    protected final MutableLazyValue<Generator<DTBlockStateProvider, Family>> strippedBranchStateGenerator = MutableLazyValue.supplied(StrippedBranchStateGenerator::new);
    protected final MutableLazyValue<Generator<DTBlockStateProvider, Family>> surfaceRootStateGenerator = MutableLazyValue.supplied(SurfaceRootStateGenerator::new);
    protected final MutableLazyValue<Generator<DTItemModelProvider, Family>> branchItemModelGenerator = MutableLazyValue.supplied(BranchItemModelGenerator::new);

    private Family() {
        this.setRegistryName(DTTrees.NULL);
    }

    public Family(ResourceLocation name) {
        this.setRegistryName(name);
        this.commonSpecies = Species.NULL_SPECIES;
    }

    public void setupBlocks() {
        this.setBranch(this.createBranch(this.getBranchName()));
        this.setBranchItem((Item)this.createBranchItem(this.getBranchName(), this.branch));
        if (this.hasStrippedBranch()) {
            this.setStrippedBranch(this.createBranch(this.getBranchName("stripped_")));
        }
        if (this.hasSurfaceRoot()) {
            this.setSurfaceRoot(this.createSurfaceRoot());
        }
    }

    public void setCommonSpecies(Species species) {
        this.commonSpecies = species;
    }

    public void setupCommonSpecies(Species species) {
        this.commonSpecies = species.setShouldGenerateSeedIfNull(true).setShouldGenerateSaplingIfNull(true).generateSeed().generateSapling();
    }

    public Species getCommonSpecies() {
        return this.commonSpecies;
    }

    public Family addSpecies(Species species) {
        this.species.add(species);
        return this;
    }

    public Set<Species> getSpecies() {
        return this.species;
    }

    public Species getSpeciesForLocation(IWorld world, BlockPos trunkPos) {
        return this.getSpeciesForLocation((IBlockReader)world, trunkPos, this.commonSpecies);
    }

    public Species getSpeciesForLocation(IBlockReader world, BlockPos trunkPos, Species defaultSpecies) {
        for (Species species : this.species) {
            if (!species.shouldOverrideCommon(world, trunkPos)) continue;
            return species;
        }
        return defaultSpecies;
    }

    public boolean onTreeActivated(TreeActivationContext context) {
        if (this.canStripBranch(context.hitState, context.world, context.hitPos, context.player, context.heldItem)) {
            return this.stripBranch(context.hitState, context.world, context.hitPos, context.player, context.heldItem);
        }
        if (context.rootPos != BlockPos.field_177992_a) {
            return TreeHelper.getExactSpecies(context.world, context.hitPos).onTreeActivated(context);
        }
        return false;
    }

    public boolean canStripBranch(BlockState state, World world, BlockPos pos, PlayerEntity player, ItemStack heldItem) {
        BranchBlock branchBlock = TreeHelper.getBranch(state);
        if (branchBlock == null) {
            return false;
        }
        return branchBlock.canBeStripped(state, world, pos, player, heldItem);
    }

    public boolean stripBranch(BlockState state, World world, BlockPos pos, PlayerEntity player, ItemStack heldItem) {
        if (this.hasStrippedBranch()) {
            this.getBranch().ifPresent(branch -> {
                branch.stripBranch(state, world, pos, player, heldItem);
                if (world.field_72995_K) {
                    world.func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    WailaOther.invalidateWailaPosition();
                }
            });
            return this.getBranch().isPresent();
        }
        return false;
    }

    public boolean isWood() {
        return true;
    }

    protected ResourceLocation getBranchName() {
        return this.getBranchName("");
    }

    protected ResourceLocation getBranchName(String prefix) {
        return ResourceLocationUtils.prefix(this.getRegistryName(), prefix);
    }

    protected BranchBlock createBranchBlock(ResourceLocation name) {
        BasicBranchBlock branch;
        BasicBranchBlock basicBranchBlock = branch = this.isThick() ? new ThickBranchBlock(name, this.getProperties()) : new BasicBranchBlock(name, this.getProperties());
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }

    protected BranchBlock createBranch(ResourceLocation name) {
        return RegistryHandler.addBlock(ResourceLocationUtils.suffix(name, this.getBranchNameSuffix()), this.createBranchBlock(name));
    }

    protected String getBranchNameSuffix() {
        return "_branch";
    }

    public BlockItem createBranchItem(ResourceLocation name, BranchBlock branch) {
        return RegistryHandler.addItem(ResourceLocationUtils.suffix(name, this.getBranchNameSuffix()), new BlockItem((Block)branch, new Item.Properties()));
    }

    protected Family setBranch(BranchBlock branch) {
        this.branch = this.setupBranch(branch, this.hasStrippedBranch);
        return this;
    }

    protected Family setStrippedBranch(BranchBlock branch) {
        this.strippedBranch = this.setupBranch(branch, false);
        return this;
    }

    protected BranchBlock setupBranch(BranchBlock branchBlock, boolean canBeStripped) {
        branchBlock.setFamily(this);
        branchBlock.setCanBeStripped(canBeStripped);
        this.addValidBranches(branchBlock);
        return branchBlock;
    }

    protected Family setBranchItem(Item branchItem) {
        this.branchItem = branchItem;
        return this;
    }

    public Optional<BranchBlock> getBranch() {
        return Optionals.ofBlock(this.branch);
    }

    public Optional<BranchBlock> getBranchForPlacement(IWorld world, Species species, BlockPos pos) {
        return this.getBranch();
    }

    public Optional<BranchBlock> getStrippedBranch() {
        return Optionals.ofBlock(this.strippedBranch);
    }

    public Optional<Item> getBranchItem() {
        return Optionals.ofItem(this.branchItem);
    }

    public boolean isThick() {
        return this.maxBranchRadius > 8;
    }

    public int getMaxBranchRadius() {
        return this.maxBranchRadius;
    }

    public void setMaxBranchRadius(int maxBranchRadius) {
        this.maxBranchRadius = maxBranchRadius;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRootColor(BlockState state, boolean getBark) {
        return getBark ? this.woodBarkColor : this.woodRingColor;
    }

    public void setHasConiferVariants(boolean hasConiferVariants) {
        this.hasConiferVariants = hasConiferVariants;
    }

    public Family setStick(Item item) {
        this.stick = item;
        return this;
    }

    public ItemStack getStick(int qty) {
        return this.stick == Items.field_190931_a ? ItemStack.field_190927_a : new ItemStack((IItemProvider)this.stick, MathHelper.func_76125_a((int)qty, (int)0, (int)64));
    }

    public Family setPrimitiveLog(Block primitiveLog) {
        this.primitiveLog = primitiveLog;
        if (this.branch != null) {
            this.branch.setPrimitiveLogDrops(new ItemStack((IItemProvider)primitiveLog));
        }
        return this;
    }

    public Family setPrimitiveStrippedLog(Block primitiveStrippedLog) {
        this.primitiveStrippedLog = primitiveStrippedLog;
        if (this.strippedBranch != null) {
            this.strippedBranch.setPrimitiveLogDrops(new ItemStack((IItemProvider)primitiveStrippedLog));
        }
        return this;
    }

    public Optional<Block> getPrimitiveLog() {
        return Optionals.ofBlock(this.primitiveLog);
    }

    public Optional<Block> getPrimitiveStrippedLog() {
        return Optionals.ofBlock(this.primitiveStrippedLog);
    }

    private List<ItemStack> getLogDropsForBranch(float volume, int branch) {
        BranchBlock branchBlock = this.getValidBranchBlock(branch);
        LinkedList<ItemStack> logs = new LinkedList<ItemStack>();
        if (branchBlock != null) {
            branchBlock.getPrimitiveLogs(volume, logs);
        }
        return logs;
    }

    public boolean isFireProof() {
        return this.isFireProof;
    }

    public void setIsFireProof(boolean isFireProof) {
        this.isFireProof = isFireProof;
    }

    public Material getDefaultBranchMaterial() {
        return Material.field_151575_d;
    }

    public SoundType getDefaultBranchSoundType() {
        return SoundType.field_185848_a;
    }

    public ToolType getDefaultBranchTool() {
        return ToolType.AXE;
    }

    public AbstractBlock.Properties getDefaultBranchProperties(Material material, MaterialColor materialColor) {
        return AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)materialColor).func_200947_a(this.getDefaultBranchSoundType()).func_222380_e().harvestLevel(0).harvestTool(this.getDefaultBranchTool());
    }

    public AbstractBlock.Properties getProperties() {
        return this.properties == null ? this.getDefaultBranchProperties(this.getDefaultBranchMaterial(), this.getDefaultBranchMaterial().func_151565_r()) : this.properties;
    }

    public Family setProperties(AbstractBlock.Properties properties) {
        this.properties = properties;
        return this;
    }

    public int getRadiusForCellKit(IBlockReader blockAccess, BlockPos pos, BlockState blockState, Direction dir, BranchBlock branch) {
        int radius = branch.getRadius(blockState);
        int meta = 0;
        if (this.hasConiferVariants && radius == this.getPrimaryThickness() && blockAccess.func_180495_p(pos.func_177977_b()).func_177230_c() == branch) {
            meta = 1;
        }
        return MetadataCell.radiusAndMeta(radius, meta);
    }

    public void setPrimaryThickness(int primaryThickness) {
        this.primaryThickness = primaryThickness;
    }

    public void setSecondaryThickness(int secondaryThickness) {
        this.secondaryThickness = secondaryThickness;
    }

    public int getPrimaryThickness() {
        return this.primaryThickness;
    }

    public int getSecondaryThickness() {
        return this.secondaryThickness;
    }

    public boolean hasStrippedBranch() {
        return this.hasStrippedBranch;
    }

    public void setHasStrippedBranch(boolean hasStrippedBranch) {
        this.hasStrippedBranch = hasStrippedBranch;
    }

    public List<BranchBlock> getValidBranchBlocks() {
        return Collections.unmodifiableList(this.validBranches);
    }

    public int getNumberOfValidBranchBlocks() {
        return this.validBranches.size();
    }

    public void addValidBranches(BranchBlock ... branches) {
        this.validBranches.addAll(Arrays.asList(branches));
    }

    public int getBranchBlockIndex(BranchBlock block) {
        int index = this.validBranches.indexOf(block);
        if (index < 0) {
            LogManager.getLogger().warn("Block {} not valid branch for {}.", (Object)block, (Object)this);
            return 0;
        }
        return index;
    }

    @Nullable
    public BranchBlock getValidBranchBlock(int index) {
        if (index < this.validBranches.size()) {
            return this.validBranches.get(index);
        }
        LogManager.getLogger().warn("Attempted to get branch block of index {} but {} only has {} valid branches.", (Object)index, (Object)this, (Object)this.validBranches.size());
        return this.validBranches.get(0);
    }

    public boolean isValidBranchBlock(BranchBlock block) {
        return this.validBranches.contains(block);
    }

    public void setBranchIsLadder(boolean branchIsLadder) {
        this.branchIsLadder = branchIsLadder;
    }

    public boolean branchIsLadder() {
        return this.branchIsLadder;
    }

    public int getMaxSignalDepth() {
        return this.maxSignalDepth;
    }

    public void setMaxSignalDepth(int maxSignalDepth) {
        this.maxSignalDepth = maxSignalDepth;
    }

    public boolean hasSurfaceRoot() {
        return this.hasSurfaceRoot;
    }

    public void setHasSurfaceRoot(boolean hasSurfaceRoot) {
        this.hasSurfaceRoot = hasSurfaceRoot;
    }

    public SurfaceRootBlock createSurfaceRoot() {
        return RegistryHandler.addBlock(ResourceLocationUtils.suffix(this.getRegistryName(), "_root"), new SurfaceRootBlock(this));
    }

    public Optional<SurfaceRootBlock> getSurfaceRoot() {
        return Optionals.ofBlock(this.surfaceRoot);
    }

    protected Family setSurfaceRoot(SurfaceRootBlock surfaceRoot) {
        this.surfaceRoot = surfaceRoot;
        return this;
    }

    public AnimationHandler selectAnimationHandler(FallingTreeEntity fallingEntity) {
        return fallingEntity.defaultAnimationHandler();
    }

    public BlockBounds expandLeavesBlockBounds(BlockBounds bounds) {
        return bounds.expand(3);
    }

    public boolean isCompatibleDynamicLeaves(Species species, BlockState blockState, IBlockReader blockAccess, BlockPos pos) {
        DynamicLeavesBlock leaves = TreeHelper.getLeaves(blockState);
        return leaves != null && (this == leaves.getFamily(blockState, blockAccess, pos) || species.isValidLeafBlock(leaves));
    }

    public boolean isCompatibleGenericLeaves(Species species, BlockState blockState, IWorld blockAccess, BlockPos pos) {
        return this.isCompatibleDynamicLeaves(species, blockState, (IBlockReader)blockAccess, pos);
    }

    public LeavesProperties getCommonLeaves() {
        return this.commonLeaves;
    }

    public void setCommonLeaves(LeavesProperties properties) {
        this.commonLeaves = properties;
        properties.setFamily(this);
    }

    public List<ITag.INamedTag<Block>> defaultBranchTags() {
        return this.isFireProof ? Collections.singletonList(DTBlockTags.BRANCHES) : Collections.singletonList(DTBlockTags.BRANCHES_THAT_BURN);
    }

    public List<ITag.INamedTag<Item>> defaultBranchItemTags() {
        return this.isFireProof ? Collections.singletonList(DTItemTags.BRANCHES) : Collections.singletonList(DTItemTags.BRANCHES_THAT_BURN);
    }

    public List<ITag.INamedTag<Block>> defaultStrippedBranchTags() {
        return this.isFireProof ? Collections.singletonList(DTBlockTags.STRIPPED_BRANCHES) : Collections.singletonList(DTBlockTags.STRIPPED_BRANCHES_THAT_BURN);
    }

    public BiFunction<BlockModelBuilder, ExistingFileHelper, BranchLoaderBuilder> getBranchLoaderConstructor() {
        return BranchLoaderBuilder::branch;
    }

    @Override
    public void generateStateData(DTBlockStateProvider provider) {
        this.branchStateGenerator.get().generate(provider, this);
        this.strippedBranchStateGenerator.get().generate(provider, this);
        this.surfaceRootStateGenerator.get().generate(provider, this);
    }

    public ResourceLocation getBranchItemParentLocation() {
        return DynamicTrees.resLoc("item/branch");
    }

    public void addBranchTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation primitiveLogLocation) {
        textureConsumer.accept("bark", primitiveLogLocation);
        textureConsumer.accept("rings", ResourceLocationUtils.suffix(primitiveLogLocation, "_top"));
    }

    @Override
    public void generateItemModelData(DTItemModelProvider provider) {
        this.branchItemModelGenerator.get().generate(provider, this);
    }

    @Override
    public String toLoadDataString() {
        return this.getString(Pair.of((Object)"commonLeaves", (Object)this.commonLeaves), Pair.of((Object)"maxBranchRadius", (Object)this.maxBranchRadius), Pair.of((Object)"hasSurfaceRoot", (Object)this.hasSurfaceRoot), Pair.of((Object)"hasStrippedBranch", (Object)this.hasStrippedBranch));
    }

    @Override
    public String toReloadDataString() {
        return this.getString(Pair.of((Object)"commonLeaves", (Object)this.commonLeaves), Pair.of((Object)"maxBranchRadius", (Object)this.maxBranchRadius), Pair.of((Object)"commonSpecies", (Object)this.commonSpecies), Pair.of((Object)"primitiveLog", (Object)this.primitiveLog), Pair.of((Object)"primitiveStrippedLog", (Object)this.primitiveStrippedLog), Pair.of((Object)"stick", (Object)this.stick), Pair.of((Object)"hasConiferVariants", (Object)this.hasConiferVariants));
    }

    public static class TreeActivationContext {
        public final World world;
        public final BlockPos rootPos;
        public final BlockPos hitPos;
        public final BlockState hitState;
        public final PlayerEntity player;
        public final Hand hand;
        @Nullable
        public final ItemStack heldItem;
        public final BlockRayTraceResult hitResult;

        public TreeActivationContext(World world, BlockPos rootPos, BlockPos hitPos, BlockState hitState, PlayerEntity player, Hand hand, @Nullable ItemStack heldItem, BlockRayTraceResult hitResult) {
            this.world = world;
            this.rootPos = rootPos;
            this.hitPos = hitPos;
            this.hitState = hitState;
            this.player = player;
            this.hand = hand;
            this.heldItem = heldItem;
            this.hitResult = hitResult;
        }
    }
}

