/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.data.SaplingStateGenerator;
import com.ferreusveritas.dynamictrees.api.data.SeedItemModelGenerator;
import com.ferreusveritas.dynamictrees.api.event.TransitionSaplingToTreeEvent;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.api.substances.Emptiable;
import com.ferreusveritas.dynamictrees.api.substances.SubstanceEffect;
import com.ferreusveritas.dynamictrees.api.substances.SubstanceEffectProvider;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.blocks.DynamicSaplingBlock;
import com.ferreusveritas.dynamictrees.blocks.PottedSaplingBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilHelper;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilProperties;
import com.ferreusveritas.dynamictrees.compat.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.data.DTItemTags;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTItemModelProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTLootTableProvider;
import com.ferreusveritas.dynamictrees.entities.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.entities.LingeringEffectorEntity;
import com.ferreusveritas.dynamictrees.entities.animation.AnimationHandler;
import com.ferreusveritas.dynamictrees.event.BiomeSuitabilityEvent;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.loot.DTLootParameterSets;
import com.ferreusveritas.dynamictrees.loot.DTLootParameters;
import com.ferreusveritas.dynamictrees.models.FallingTreeEntityModel;
import com.ferreusveritas.dynamictrees.resources.Resources;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.SeedSaplingRecipe;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.FullGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostRotContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PreGenerationContext;
import com.ferreusveritas.dynamictrees.systems.nodemappers.DiseaseNode;
import com.ferreusveritas.dynamictrees.systems.nodemappers.FindEndsNode;
import com.ferreusveritas.dynamictrees.systems.nodemappers.InflatorNode;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NetVolumeNode;
import com.ferreusveritas.dynamictrees.systems.nodemappers.ShrinkerNode;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.systems.substances.FertilizeSubstance;
import com.ferreusveritas.dynamictrees.systems.substances.GrowthSubstance;
import com.ferreusveritas.dynamictrees.tileentity.SpeciesTileEntity;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Resettable;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.CommonVoxelShapes;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.LazyValue;
import com.ferreusveritas.dynamictrees.util.MutableLazyValue;
import com.ferreusveritas.dynamictrees.util.Optionals;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.ferreusveritas.dynamictrees.worldgen.JoCodeRegistry;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function3;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class Species
extends RegistryEntry<Species>
implements Resettable<Species> {
    public static final Species NULL_SPECIES = new Species(){

        @Override
        public Optional<Seed> getSeed() {
            return Optional.empty();
        }

        @Override
        public Family getFamily() {
            return Family.NULL_FAMILY;
        }

        @Override
        public boolean isTransformable() {
            return false;
        }

        @Override
        public boolean plantSapling(IWorld world, BlockPos pos, boolean locationOverride) {
            return false;
        }

        @Override
        public boolean generate(WorldContext worldContext, BlockPos pos, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
            return false;
        }

        @Override
        public float biomeSuitability(World world, BlockPos pos) {
            return 0.0f;
        }

        @Override
        public Species setSeed(Seed seed) {
            return this;
        }

        @Override
        public ItemStack getSeedStack(int qty) {
            return ItemStack.field_190927_a;
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.formatComponent((ITextComponent)new TranslationTextComponent("gui.none"), TextFormatting.DARK_RED);
        }

        @Override
        public boolean update(World world, RootyBlock rootyDirt, BlockPos rootPos, int fertility, TreePart treeBase, BlockPos treePos, Random random, boolean rapid) {
            return false;
        }
    };
    public static final TypedRegistry.EntryType<Species> TYPE = Species.createDefaultType((Function3<ResourceLocation, Family, LeavesProperties, Species>)((Function3)Species::new));
    public static final Codec<Species> CODEC = ResourceLocation.field_240908_a_.comapFlatMap(Species::read, RegistryEntry::getRegistryName);
    public static final TypedRegistry<Species> REGISTRY = new TypedRegistry<Species>(Species.class, NULL_SPECIES, TYPE);
    protected Family family = Family.NULL_FAMILY;
    protected GrowthLogicKitConfiguration logicKit = GrowthLogicKitConfiguration.getDefault();
    protected float tapering = 0.3f;
    protected int upProbability = 2;
    protected int lowestBranchHeight = 3;
    protected float signalEnergy = 16.0f;
    protected float growthRate = 1.0f;
    protected int soilLongevity = 8;
    protected int soilTypeFlags = 0;
    protected int maxBranchRadius = 8;
    private boolean transformable = true;
    protected final List<Block> acceptableBlocksForGrowth = Lists.newArrayList();
    protected LeavesProperties leavesProperties = LeavesProperties.NULL;
    private final List<LeavesProperties> validLeaves = new LinkedList<LeavesProperties>();
    protected Seed seed;
    protected Boolean dropSeeds = null;
    protected DynamicSaplingBlock saplingBlock;
    protected Map<BiomeDictionary.Type, Float> envFactors = new HashMap<BiomeDictionary.Type, Float>();
    protected List<Biome> perfectBiomes = new ArrayList<Biome>();
    protected final List<GenFeatureConfiguration> genFeatures = new ArrayList<GenFeatureConfiguration>();
    protected CommonOverride commonOverride;
    private String unlocalizedName = "";
    private Set<Fruit> fruits = new HashSet<Fruit>();
    private Set<Pod> pods = new HashSet<Pod>();
    private Boolean shouldGenerateSeed;
    private String seedName = null;
    protected final Set<SeedSaplingRecipe> primitiveSaplingRecipe = new HashSet<SeedSaplingRecipe>();
    private Boolean shouldGenerateSapling;
    private boolean canSaplingGrowNaturally = true;
    private VoxelShape saplingShape = CommonVoxelShapes.SAPLING;
    private String saplingName = null;
    private SoundType saplingSound = SoundType.field_185850_c;
    private static final Direction[] upFirst = new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private boolean doesRot = true;
    private boolean canBoneMealTree = true;
    protected float flowerSeasonHoldMin = 0.0f;
    protected float flowerSeasonHoldMax = 0.5f;
    @Nullable
    protected Float seasonalGrowthOffset = Float.valueOf(0.0f);
    @Nullable
    protected Float seasonalSeedDropOffset = Float.valueOf(0.0f);
    @Nullable
    protected Float seasonalFruitingOffset = Float.valueOf(0.0f);
    protected Boolean alwaysShowOnWaila = null;
    private Species megaSpecies = NULL_SPECIES;
    private boolean isMegaSpecies = false;
    private int worldGenLeafMapHeight = 32;
    protected final MutableLazyValue<Generator<DTBlockStateProvider, Species>> saplingStateGenerator = MutableLazyValue.supplied(SaplingStateGenerator::new);
    protected final MutableLazyValue<Generator<DTItemModelProvider, Species>> seedModelGenerator = MutableLazyValue.supplied(SeedItemModelGenerator::new);
    private final LazyValue<ResourceLocation> voluntaryDropsPath = LazyValue.supplied(() -> ResourceLocationUtils.prefix(this.getRegistryName(), "trees/voluntary/"));

    public static TypedRegistry.EntryType<Species> createDefaultType(Function3<ResourceLocation, Family, LeavesProperties, Species> constructor) {
        return TypedRegistry.newType(Species.createDefaultCodec(constructor));
    }

    public static Codec<Species> createDefaultCodec(Function3<ResourceLocation, Family, LeavesProperties, Species> constructor) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.fieldOf(Resources.RESOURCE_LOCATION.toString()).forGetter(RegistryEntry::getRegistryName), (App)Family.REGISTRY.getGetterCodec().fieldOf("family").forGetter(Species::getFamily), (App)LeavesProperties.REGISTRY.getGetterCodec().optionalFieldOf("leaves_properties", (Object)LeavesProperties.NULL).forGetter(Species::getLeavesProperties)).apply((Applicative)instance, constructor));
    }

    private static DataResult<Species> read(ResourceLocation name) {
        Species species = (Species)REGISTRY.get(name);
        return species == null ? DataResult.error((String)("Species not found: " + name)) : DataResult.success((Object)species);
    }

    public Species() {
        this.setRegistryName(DTTrees.NULL);
    }

    public Species(ResourceLocation name, Family family) {
        this(name, family, family.getCommonLeaves());
    }

    public Species(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        this.setRegistryName(name);
        this.setUnlocalizedName(name.toString());
        this.family = family;
        this.family.addSpecies(this);
        this.setLeavesProperties(leavesProperties.isValid() ? leavesProperties : family.getCommonLeaves());
    }

    @Override
    public Species reset() {
        this.fruits.clear();
        this.pods.clear();
        this.envFactors.clear();
        this.genFeatures.clear();
        this.acceptableBlocksForGrowth.clear();
        this.primitiveSaplingRecipe.clear();
        this.perfectBiomes.clear();
        this.clearAcceptableSoils();
        return this;
    }

    @Override
    public Species setPreReloadDefaults() {
        return this.setDefaultGrowingParameters().setSaplingShape(CommonVoxelShapes.SAPLING).setSaplingSound(SoundType.field_185850_c);
    }

    @Override
    public Species setPostReloadDefaults() {
        if (!this.hasSeed()) {
            this.seed = this.getCommonSpecies().seed;
        }
        if (!this.hasAcceptableSoil()) {
            this.setStandardSoils();
        }
        return this;
    }

    public Species setDefaultGrowingParameters() {
        return this;
    }

    public float defaultSeedComposterChance() {
        return 0.3f;
    }

    public Family getFamily() {
        return this.family;
    }

    public void setFamily(Family family) {
        family.addSpecies(this);
        this.family = family;
    }

    public Species getCommonSpecies() {
        return this.family.getCommonSpecies();
    }

    public boolean isCommonSpecies() {
        return this.getCommonSpecies() == this;
    }

    public boolean isSeedCommon() {
        return this.getCommonSpecies().getSeed().orElse(null) == this.seed;
    }

    public Species setUnlocalizedName(String name) {
        this.unlocalizedName = "species." + name.replace(":", ".");
        return this;
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Override
    public ITextComponent getTextComponent() {
        return this.formatComponent((ITextComponent)new TranslationTextComponent(this.getUnlocalizedName()), TextFormatting.AQUA);
    }

    public Species setBasicGrowingParameters(float tapering, float energy, int upProbability, int lowestBranchHeight, float growthRate) {
        this.tapering = tapering;
        this.signalEnergy = energy;
        this.upProbability = upProbability;
        this.lowestBranchHeight = lowestBranchHeight;
        this.growthRate = growthRate;
        return this;
    }

    public void setTapering(float tapering) {
        this.tapering = tapering;
    }

    public void setUpProbability(int upProbability) {
        this.upProbability = upProbability;
    }

    public void setLowestBranchHeight(int lowestBranchHeight) {
        this.lowestBranchHeight = lowestBranchHeight;
    }

    public void setSignalEnergy(float signalEnergy) {
        this.signalEnergy = signalEnergy;
    }

    public void setGrowthRate(float growthRate) {
        this.growthRate = growthRate;
    }

    public float getSignalEnergy() {
        return this.signalEnergy;
    }

    public float getEnergy(World world, BlockPos rootPos) {
        return this.logicKit.getEnergy(new PositionalSpeciesContext(world, rootPos, this));
    }

    public float getGrowthRate(World world, BlockPos rootPos) {
        return this.growthRate * this.seasonalGrowthFactor(WorldContext.create((IWorld)world), rootPos);
    }

    public int getUpProbability() {
        return this.upProbability;
    }

    public int getProbabilityForCurrentDir() {
        return 1;
    }

    public int getLowestBranchHeight() {
        return this.lowestBranchHeight;
    }

    public float getTapering() {
        return this.tapering;
    }

    public boolean doesRequireTileEntity(IWorld world, BlockPos pos) {
        return !this.isCommonSpecies() && !this.shouldOverrideCommon((IBlockReader)world, pos);
    }

    public boolean isTransformable() {
        return this.transformable;
    }

    public Species setTransformable(boolean transformable) {
        this.transformable = transformable;
        return this;
    }

    public boolean hasCommonOverride() {
        return this.commonOverride != null;
    }

    public void setCommonOverride(CommonOverride commonOverride) {
        this.commonOverride = commonOverride;
    }

    public boolean shouldOverrideCommon(IBlockReader world, BlockPos trunkPos) {
        return this.hasCommonOverride() && this.commonOverride.test(world, trunkPos);
    }

    public Species setLeavesProperties(LeavesProperties leavesProperties) {
        this.leavesProperties = leavesProperties;
        leavesProperties.setFamily(this.getFamily());
        this.addValidLeafBlocks(leavesProperties);
        return this;
    }

    public LeavesProperties getLeavesProperties() {
        return this.leavesProperties;
    }

    public Optional<DynamicLeavesBlock> getLeavesBlock() {
        return this.leavesProperties.getDynamicLeavesBlock();
    }

    public Optional<Block> getPrimitiveLeaves() {
        return Optionals.ofBlock(this.leavesProperties.getPrimitiveLeaves().func_177230_c());
    }

    public void addValidLeafBlocks(LeavesProperties ... leaves) {
        for (LeavesProperties leaf : leaves) {
            if (this.validLeaves.contains(leaf)) continue;
            this.validLeaves.add(leaf);
        }
    }

    public int getLeafBlockIndex(DynamicLeavesBlock block) {
        int index = this.validLeaves.indexOf(block.field_235684_aB_);
        if (index < 0) {
            LogManager.getLogger().warn("Block {} not valid leaves for {}.", (Object)block, (Object)this);
            return 0;
        }
        return index;
    }

    public LeavesProperties getValidLeavesProperties(int index) {
        if (index < this.validLeaves.size()) {
            return this.validLeaves.get(index);
        }
        LogManager.getLogger().warn("Attempted to get leaves properties of index {} but {} only has {} valid leaves.", (Object)index, (Object)this, (Object)this.validLeaves.size());
        return this.validLeaves.get(0);
    }

    public DynamicLeavesBlock getValidLeafBlock(int index) {
        LeavesProperties properties = this.getValidLeavesProperties(index);
        if (!properties.getDynamicLeavesBlock().isPresent()) {
            return null;
        }
        return (DynamicLeavesBlock)properties.getDynamicLeavesState().func_177230_c();
    }

    public boolean isValidLeafBlock(DynamicLeavesBlock leavesBlock) {
        return this.validLeaves.stream().anyMatch(properties -> properties.getDynamicLeavesBlock().orElse(null) == leavesBlock);
    }

    public int colorTreeQuads(int defaultColor, FallingTreeEntityModel.TreeQuadData treeQuad) {
        return defaultColor;
    }

    public int leafColorMultiplier(World world, BlockPos pos) {
        return this.getLeavesProperties().treeFallColorMultiplier(this.getLeavesProperties().getDynamicLeavesState(), (IBlockDisplayReader)world, pos);
    }

    public ItemStack getSeedStack(int qty) {
        return !this.hasSeed() ? ItemStack.field_190927_a : new ItemStack((IItemProvider)this.seed, qty);
    }

    public boolean hasSeed() {
        return this.seed != null;
    }

    public Optional<Seed> getSeed() {
        return Optional.ofNullable(this.seed);
    }

    public boolean shouldGenerateSeed() {
        return this.shouldGenerateSeed != null && this.shouldGenerateSeed != false;
    }

    public void setShouldGenerateSeed(boolean shouldGenerateSeed) {
        this.shouldGenerateSeed = shouldGenerateSeed;
    }

    public Species setShouldGenerateSeedIfNull(boolean shouldGenerateSeed) {
        if (this.shouldGenerateSeed == null) {
            this.shouldGenerateSeed = shouldGenerateSeed;
        }
        return this;
    }

    public ResourceLocation getSeedName() {
        if (this.seedName == null) {
            return ResourceLocationUtils.suffix(this.getRegistryName(), "_seed");
        }
        return new ResourceLocation(this.getRegistryName().func_110624_b(), this.seedName);
    }

    public void setSeedName(String name) {
        this.seedName = name;
    }

    public Species generateSeed() {
        return !this.shouldGenerateSeed() || this.seed != null ? this : this.setSeed(RegistryHandler.addItem(this.getSeedName(), new Seed(this)));
    }

    public Species setSeed(Seed seed) {
        this.seed = seed;
        return this;
    }

    public List<ItemStack> getVoluntaryDrops(World world, BlockPos rootPos, int fertility) {
        if (world.field_72995_K) {
            return Collections.emptyList();
        }
        return this.getLootTable(world.func_73046_m().func_200249_aQ(), species -> species.voluntaryDropsPath.get()).func_216113_a(this.createVoluntaryLootContext(world, rootPos, fertility));
    }

    private LootContext createVoluntaryLootContext(World world, BlockPos rootPos, int fertility) {
        return new LootContext.Builder(WorldContext.getServerWorldOrThrow((IWorld)world)).func_216015_a(LootParameters.field_216287_g, (Object)world.func_180495_p(rootPos)).func_216015_a(DTLootParameters.SEASONAL_SEED_DROP_FACTOR, (Object)Float.valueOf(this.seasonalSeedDropFactor(WorldContext.create((IWorld)world), rootPos))).func_216015_a(DTLootParameters.FERTILITY, (Object)fertility).func_216022_a(DTLootParameterSets.VOLUNTARY);
    }

    public LootTable getLootTable(LootTableManager lootTables, Function<Species, ResourceLocation> nameFunction) {
        LootTable table = lootTables.func_186521_a(nameFunction.apply(this));
        return table == LootTable.field_186464_a ? (this.isCommonSpecies() ? lootTables.func_186521_a(nameFunction.apply(this.getCommonSpecies())) : LootTable.field_186464_a) : table;
    }

    public List<ItemStack> getBranchesDrops(World world, NetVolumeNode.Volume volume) {
        return this.getBranchesDrops(world, volume, ItemStack.field_190927_a);
    }

    public List<ItemStack> getBranchesDrops(World world, NetVolumeNode.Volume volume, ItemStack tool) {
        return this.getBranchesDrops(world, volume, tool, null);
    }

    public List<ItemStack> getBranchesDrops(World world, NetVolumeNode.Volume volume, ItemStack tool, @Nullable Float explosionRadius) {
        this.processVolume(volume);
        if (world.field_72995_K) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = 0; i < this.family.getNumberOfValidBranchBlocks(); ++i) {
            int branchVolume = volume.getRawVolume(i);
            if (branchVolume <= 0) continue;
            BranchBlock branchBlock = this.family.getValidBranchBlock(i);
            drops.addAll(this.getDropsForBranchType(world, tool, explosionRadius, branchVolume, branchBlock));
        }
        this.cleanDropsList(drops);
        return drops;
    }

    protected void processVolume(NetVolumeNode.Volume volume) {
        volume.multiplyVolume((Double)DTConfigs.TREE_HARVEST_MULTIPLIER.get());
    }

    private List<ItemStack> getDropsForBranchType(World world, ItemStack tool, @Nullable Float explosionRadius, int branchVolume, BranchBlock branchBlock) {
        return branchBlock.getLootTable(world.func_73046_m().func_200249_aQ(), this).func_216113_a(this.createBranchesLootContext(world, branchVolume, tool, explosionRadius));
    }

    private LootContext createBranchesLootContext(World world, int volume, ItemStack tool, @Nullable Float explosionRadius) {
        return new LootContext.Builder(WorldContext.getServerWorldOrThrow((IWorld)world)).func_216015_a(LootParameters.field_216289_i, (Object)tool).func_216015_a(DTLootParameters.SPECIES, (Object)this).func_216015_a(DTLootParameters.VOLUME, (Object)volume).func_216021_b(LootParameters.field_216290_j, (Object)explosionRadius).func_216022_a(DTLootParameterSets.BRANCHES);
    }

    private void cleanDropsList(List<ItemStack> drops) {
        for (int i = 0; i < drops.size(); ++i) {
            ItemStack drop = drops.get(i);
            if (drop.func_77973_b() == Items.field_190931_a) {
                drops.remove(i--);
            }
            if (drop.func_190916_E() <= drop.func_77976_d()) continue;
            ItemStack copiedStack = drop.func_77946_l();
            copiedStack.func_190920_e(drop.func_190916_E() - drop.func_77976_d());
            drops.add(copiedStack);
            drop.func_190920_e(drop.func_77976_d());
        }
    }

    public LogsAndSticks getLogsAndSticks(NetVolumeNode.Volume volume) {
        LinkedList<ItemStack> logsList = new LinkedList<ItemStack>();
        int[] volArray = volume.getRawVolumesArray();
        float stickVol = 0.0f;
        for (int i = 0; i < volArray.length; ++i) {
            float vol = (float)volArray[i] / 4096.0f;
            if (!(vol > 0.0f)) continue;
            stickVol += this.getFamily().getValidBranchBlock(i).getPrimitiveLogs(vol, logsList);
        }
        int sticks = (int)(stickVol * 8.0f);
        return new LogsAndSticks(logsList, sticks);
    }

    public boolean handleVoluntaryDrops(World world, List<BlockPos> endPoints, BlockPos rootPos, BlockPos treePos, int fertility) {
        int tickSpeed = world.func_82736_K().func_223592_c(GameRules.field_223610_m);
        if (tickSpeed > 0) {
            List<ItemStack> drops;
            double slowFactor = 3.0 / (double)tickSpeed;
            if (world.field_73012_v.nextDouble() < slowFactor && !(drops = this.getVoluntaryDrops(world, rootPos, fertility)).isEmpty() && !endPoints.isEmpty()) {
                for (ItemStack drop : drops) {
                    BlockPos branchPos = endPoints.get(world.field_73012_v.nextInt(endPoints.size()));
                    BlockPos itemPos = CoordUtils.getRayTraceFruitPos((IWorld)world, this, treePos, branchPos = branchPos.func_177984_a(), SafeChunkBounds.ANY);
                    if (itemPos == BlockPos.field_177992_a) continue;
                    ItemEntity itemEntity = new ItemEntity(world, (double)itemPos.func_177958_n() + 0.5, (double)itemPos.func_177956_o() + 0.5, (double)itemPos.func_177952_p() + 0.5, drop);
                    Vector3d motion = new Vector3d((double)itemPos.func_177958_n(), (double)itemPos.func_177956_o(), (double)itemPos.func_177952_p()).func_178788_d(new Vector3d((double)treePos.func_177958_n(), (double)treePos.func_177956_o(), (double)treePos.func_177952_p()));
                    float distAngle = 15.0f;
                    float launchSpeed = 4.0f;
                    motion = new Vector3d(motion.field_72450_a, 0.0, motion.field_72448_b).func_72432_b().func_178785_b(world.field_73012_v.nextFloat() * distAngle * 2.0f - distAngle).func_186678_a((double)(launchSpeed / 20.0f));
                    itemEntity.func_213293_j(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
                    return world.func_217376_c((Entity)itemEntity);
                }
            }
        }
        return true;
    }

    public void addPrimitiveSaplingRecipe(SeedSaplingRecipe recipe) {
        recipe.getSaplingBlock().ifPresent(block -> TreeRegistry.registerSaplingReplacer(block.func_176223_P(), this));
        this.primitiveSaplingRecipe.add(recipe);
    }

    public Set<SeedSaplingRecipe> getPrimitiveSaplingRecipes() {
        return new HashSet<SeedSaplingRecipe>(this.primitiveSaplingRecipe);
    }

    public Species addPrimitiveSaplingItem(Item primitiveSaplingItem) {
        this.primitiveSaplingRecipe.add(new SeedSaplingRecipe(primitiveSaplingItem));
        return this;
    }

    public Species setSapling(DynamicSaplingBlock sapling) {
        this.saplingBlock = sapling;
        return this;
    }

    public boolean shouldGenerateSapling() {
        return this.shouldGenerateSapling != null && this.shouldGenerateSapling != false;
    }

    public void setShouldGenerateSapling(boolean shouldGenerateSapling) {
        this.shouldGenerateSapling = shouldGenerateSapling;
    }

    public Species setShouldGenerateSaplingIfNull(boolean shouldGenerateSapling) {
        if (this.shouldGenerateSapling == null) {
            this.shouldGenerateSapling = shouldGenerateSapling;
        }
        return this;
    }

    public Species generateSapling() {
        return !this.shouldGenerateSapling() || this.saplingBlock != null ? this : this.setSapling(RegistryHandler.addBlock(this.getSaplingRegName(), new DynamicSaplingBlock(this)));
    }

    public Optional<DynamicSaplingBlock> getSapling() {
        return Optional.ofNullable(this.saplingBlock);
    }

    public Species selfOrLocationOverride(IBlockReader world, BlockPos pos) {
        return this.shouldUseLocationOverride() ? this.getFamily().getSpeciesForLocation(world, pos, this) : this;
    }

    public boolean shouldUseLocationOverride() {
        return !this.getSapling().isPresent() || this.isCommonSpecies();
    }

    public boolean plantSapling(IWorld world, BlockPos pos, boolean locationOverride) {
        DynamicSaplingBlock sapling = this.getSapling().orElse(this.getCommonSpecies().saplingBlock);
        if (sapling == null || !world.func_180495_p(pos).func_185904_a().func_76222_j() || !DynamicSaplingBlock.canSaplingStay((IWorldReader)world, this, pos)) {
            return false;
        }
        world.func_180501_a(pos, sapling.func_176223_P(), 3);
        return true;
    }

    public void addAcceptableBlockForGrowth(Block block) {
        this.acceptableBlocksForGrowth.add(block);
    }

    public boolean canSaplingGrow(World world, BlockPos pos) {
        return this.acceptableBlocksForGrowth.isEmpty() || this.acceptableBlocksForGrowth.stream().anyMatch(block -> block == world.func_180495_p(pos.func_177977_b()).func_177230_c());
    }

    public Species setCanSaplingGrowNaturally(boolean canSaplingGrowNaturally) {
        this.canSaplingGrowNaturally = canSaplingGrowNaturally;
        return this;
    }

    public boolean canSaplingGrowNaturally(World world, BlockPos pos) {
        return this.canSaplingGrowNaturally && this.canSaplingGrow(world, pos);
    }

    public boolean canSaplingConsumeBoneMeal(World world, BlockPos pos) {
        return this.canBoneMealTree() && this.canSaplingGrow(world, pos);
    }

    public boolean canSaplingGrowAfterBoneMeal(World world, Random rand, BlockPos pos) {
        return this.canBoneMealTree() && this.canSaplingGrow(world, pos);
    }

    public int saplingFireSpread() {
        return 0;
    }

    public int saplingFlammability() {
        return 0;
    }

    public final boolean transitionToTree(World world, BlockPos pos) {
        TransitionSaplingToTreeEvent event = new TransitionSaplingToTreeEvent(this, world, pos);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled() && this.shouldTransitionToTree(world, pos)) {
            return this.transitionToTree(world, pos, this.getFamily());
        }
        return false;
    }

    protected boolean shouldTransitionToTree(World world, BlockPos pos) {
        return world.func_175623_d(pos.func_177984_a()) && this.isAcceptableSoil((IWorldReader)world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()));
    }

    protected boolean transitionToTree(World world, BlockPos pos, Family family) {
        family.getBranch().ifPresent(branch -> branch.setRadius((IWorld)world, pos, family.getPrimaryThickness(), null));
        world.func_175656_a(pos.func_177984_a(), this.getLeavesProperties().getDynamicLeavesState());
        this.placeRootyDirtBlock((IWorld)world, pos.func_177977_b(), 15);
        if (this.doesRequireTileEntity((IWorld)world, pos)) {
            SpeciesTileEntity speciesTE = (SpeciesTileEntity)DTRegistries.speciesTE.func_200968_a();
            world.func_175690_a(pos.func_177977_b(), (TileEntity)speciesTE);
            if (speciesTE != null) {
                speciesTE.setSpecies(this);
            }
        }
        return true;
    }

    public VoxelShape getSaplingShape() {
        return this.saplingShape;
    }

    public Species setSaplingShape(VoxelShape saplingShape) {
        this.saplingShape = saplingShape;
        return this;
    }

    public ResourceLocation getSaplingRegName() {
        if (this.saplingName == null) {
            return ResourceLocationUtils.suffix(this.getRegistryName(), "_sapling");
        }
        return new ResourceLocation(this.getRegistryName().func_110624_b(), this.saplingName);
    }

    public void setSaplingName(String name) {
        this.saplingName = name;
    }

    public int saplingColorMultiplier(BlockState state, IBlockDisplayReader access, BlockPos pos, int tintIndex) {
        return this.getLeavesProperties().foliageColorMultiplier(state, access, pos);
    }

    public SoundType getSaplingSound() {
        return this.saplingSound;
    }

    public Species setSaplingSound(SoundType saplingSound) {
        this.saplingSound = saplingSound;
        return this;
    }

    public boolean placeRootyDirtBlock(IWorld world, BlockPos rootPos, int fertility) {
        BlockState dirtState = world.func_180495_p(rootPos);
        Block dirt = dirtState.func_177230_c();
        if (!SoilHelper.isSoilRegistered(dirt) && !(dirt instanceof RootyBlock)) {
            LogManager.getLogger().warn("Rooty Dirt block NOT FOUND for soil " + dirt.getRegistryName());
            this.placeRootyDirtBlock(world, rootPos, Blocks.field_150346_d.func_176223_P(), fertility);
            return false;
        }
        if (dirt instanceof RootyBlock) {
            this.updateRootyDirtBlock(world, rootPos, dirtState, fertility);
        } else if (SoilHelper.isSoilRegistered(dirt)) {
            this.placeRootyDirtBlock(world, rootPos, dirtState, fertility);
        }
        TileEntity tileEntity = world.func_175625_s(rootPos);
        if (tileEntity instanceof SpeciesTileEntity) {
            SpeciesTileEntity speciesTE = (SpeciesTileEntity)tileEntity;
            speciesTE.setSpecies(this);
        }
        return true;
    }

    private void placeRootyDirtBlock(IWorld world, BlockPos rootPos, BlockState primitiveDirtState, int fertility) {
        SoilProperties soilProperties = SoilHelper.getProperties(primitiveDirtState.func_177230_c());
        soilProperties.getBlock().ifPresent(block -> world.func_180501_a(rootPos, soilProperties.getSoilState(primitiveDirtState, fertility, this.doesRequireTileEntity(world, rootPos)), 3));
    }

    private void updateRootyDirtBlock(IWorld world, BlockPos rootPos, BlockState soilState, int fertility) {
        if (soilState.func_177230_c() instanceof RootyBlock) {
            world.func_180501_a(rootPos, (BlockState)((BlockState)soilState.func_206870_a((Property)RootyBlock.FERTILITY, (Comparable)Integer.valueOf(fertility))).func_206870_a((Property)RootyBlock.IS_VARIANT, (Comparable)Boolean.valueOf(this.doesRequireTileEntity(world, rootPos))), 3);
        }
    }

    public Species setSoilLongevity(int longevity) {
        this.soilLongevity = longevity;
        return this;
    }

    public int getSoilLongevity(World world, BlockPos rootPos) {
        return (int)(this.biomeSuitability(world, rootPos) * (float)this.soilLongevity);
    }

    public boolean isThick() {
        return this.maxBranchRadius > 8;
    }

    public int getMaxBranchRadius() {
        return this.maxBranchRadius;
    }

    public void setMaxBranchRadius(int maxBranchRadius) {
        this.maxBranchRadius = MathHelper.func_76125_a((int)maxBranchRadius, (int)1, (int)this.getFamily().getMaxBranchRadius());
    }

    public Species addAcceptableSoils(String ... soilTypes) {
        this.soilTypeFlags |= SoilHelper.getSoilFlags(soilTypes);
        return this;
    }

    public Species clearAcceptableSoils() {
        this.soilTypeFlags = 0;
        return this;
    }

    protected void setStandardSoils() {
        this.addAcceptableSoils("dirt_like");
    }

    public boolean hasAcceptableSoil() {
        return this.soilTypeFlags != 0;
    }

    public boolean isAcceptableSoil(BlockState soilBlockState) {
        return SoilHelper.isSoilAcceptable(soilBlockState, this.soilTypeFlags);
    }

    public boolean isAcceptableSoil(IWorldReader world, BlockPos pos, BlockState soilBlockState) {
        return this.isAcceptableSoil(soilBlockState);
    }

    public boolean isAcceptableSoilForWorldgen(IWorld world, BlockPos pos, BlockState soilBlockState) {
        boolean isAcceptableSoil = this.isAcceptableSoil((IWorldReader)world, pos, soilBlockState);
        if (isAcceptableSoil && this.isWater(soilBlockState)) {
            BlockPos down = pos.func_177977_b();
            BlockState downState = world.func_180495_p(pos.func_177977_b());
            return !this.isWater(downState) && this.isAcceptableSoil((IWorldReader)world, down, downState);
        }
        return isAcceptableSoil;
    }

    protected boolean isWater(BlockState soilBlockState) {
        return SoilHelper.isSoilAcceptable(soilBlockState, SoilHelper.getSoilFlags("water_like"));
    }

    public boolean update(World world, RootyBlock rootyDirt, BlockPos rootPos, int fertility, TreePart treeBase, BlockPos treePos, Random random, boolean natural) {
        List<BlockPos> ends = this.getEnds(world, treePos, treeBase);
        if (this.handleRot((IWorld)world, ends, rootPos, treePos, fertility, SafeChunkBounds.ANY)) {
            return false;
        }
        if (natural) {
            this.handleVoluntaryDrops(world, ends, rootPos, treePos, fertility);
            if (this.handleDisease(world, treeBase, treePos, random, fertility)) {
                return true;
            }
        }
        return this.grow(world, rootyDirt, rootPos, fertility, treeBase, treePos, random, natural);
    }

    protected final List<BlockPos> getEnds(World world, BlockPos treePos, TreePart treeBase) {
        FindEndsNode endFinder = new FindEndsNode();
        treeBase.analyse(world.func_180495_p(treePos), (IWorld)world, treePos, null, new MapSignal(endFinder));
        return endFinder.getEnds();
    }

    public boolean handleRot(IWorld world, List<BlockPos> ends, BlockPos rootPos, BlockPos treePos, int fertility, SafeChunkBounds safeBounds) {
        Iterator<BlockPos> iter = ends.iterator();
        SimpleVoxmap leafMap = this.getLeavesProperties().getCellKit().getLeafCluster();
        while (iter.hasNext()) {
            BlockPos endPos = iter.next();
            BlockState branchState = world.func_180495_p(endPos);
            BranchBlock branch = TreeHelper.getBranch(branchState);
            if (branch == null) continue;
            int radius = branch.getRadius(branchState);
            float rotChance = this.rotChance(world, endPos, world.func_201674_k(), radius);
            if (!branch.checkForRot(world, endPos, this, fertility, radius, world.func_201674_k(), rotChance, safeBounds != SafeChunkBounds.ANY) && radius == this.family.getPrimaryThickness()) continue;
            if (safeBounds != SafeChunkBounds.ANY) {
                TreeHelper.ageVolume(world, endPos.func_177979_c((leafMap.getLenZ() - 1) / 2), (leafMap.getLenX() - 1) / 2, leafMap.getLenY(), 2, safeBounds);
            }
            iter.remove();
        }
        return ends.isEmpty() && !TreeHelper.isBranch(world.func_180495_p(treePos));
    }

    public void setDoesRot(boolean doesRot) {
        this.doesRot = doesRot;
    }

    public boolean rot(IWorld world, BlockPos pos, int neighborCount, int radius, int fertility, Random random, boolean rapid, boolean growLeaves) {
        if (!this.doesRot) {
            return false;
        }
        if (radius <= this.family.getPrimaryThickness()) {
            if (!this.getLeavesProperties().getDynamicLeavesBlock().isPresent()) {
                return false;
            }
            if (growLeaves) {
                DynamicLeavesBlock leaves = (DynamicLeavesBlock)this.getLeavesProperties().getDynamicLeavesState().func_177230_c();
                for (Direction dir : upFirst) {
                    if (!leaves.growLeavesIfLocationIsSuitable(world, this.getLeavesProperties(), pos.func_177972_a(dir), 0)) continue;
                    return false;
                }
            }
        }
        if (rapid || (Integer)DTConfigs.MAX_BRANCH_ROT_RADIUS.get() != 0 && radius <= (Integer)DTConfigs.MAX_BRANCH_ROT_RADIUS.get()) {
            BranchBlock branch = TreeHelper.getBranch(world.func_180495_p(pos));
            if (branch != null) {
                branch.rot(world, pos);
            }
            this.postRot(new PostRotContext(world, pos, this, radius, neighborCount, fertility, rapid));
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean rot(IWorld world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
        return false;
    }

    public void postRot(PostRotContext context) {
        this.genFeatures.forEach(configuration -> configuration.generate(GenFeature.Type.POST_ROT, context));
    }

    public float rotChance(IWorld world, BlockPos pos, Random rand, int radius) {
        if (radius == 0) {
            return 0.0f;
        }
        return 0.3f + 1.0f / (float)radius;
    }

    public boolean grow(World world, RootyBlock rootyDirt, BlockPos rootPos, int fertility, TreePart treeBase, BlockPos treePos, Random random, boolean natural) {
        float growthRate = (float)((double)this.getGrowthRate(world, rootPos) * (Double)DTConfigs.TREE_GROWTH_MULTIPLIER.get() * (double)((Integer)DTConfigs.TREE_GROWTH_FOLDING.get()).intValue());
        do {
            if (fertility <= 0 || !(growthRate > random.nextFloat())) continue;
            GrowSignal signal = new GrowSignal(this, rootPos, this.getEnergy(world, rootPos), world.field_73012_v);
            boolean success = treeBase.growSignal((World)world, (BlockPos)treePos, (GrowSignal)signal).success;
            int soilLongevity = this.getSoilLongevity(world, rootPos) * (success ? 1 : 16);
            if (soilLongevity <= 0 || random.nextInt(soilLongevity) == 0) {
                rootyDirt.setFertility(world, rootPos, fertility - 1);
            }
            if (!signal.choked) continue;
            fertility = 0;
            rootyDirt.setFertility(world, rootPos, fertility);
            TreeHelper.startAnalysisFromRoot((IWorld)world, rootPos, new MapSignal(new ShrinkerNode(signal.getSpecies())));
        } while ((growthRate -= 1.0f) > 0.0f);
        this.postGrow(world, rootPos, treePos, fertility, natural);
        return true;
    }

    public Species setGrowthLogicKit(GrowthLogicKit logicKit) {
        this.logicKit = (GrowthLogicKitConfiguration)logicKit.getDefaultConfiguration();
        return this;
    }

    public Species setGrowthLogicKit(GrowthLogicKitConfiguration logicKit) {
        this.logicKit = logicKit;
        return this;
    }

    public GrowthLogicKitConfiguration getGrowthLogicKit() {
        return this.logicKit;
    }

    public void setCanBoneMealTree(boolean canBoneMealTree) {
        this.canBoneMealTree = canBoneMealTree;
    }

    public boolean canBoneMealTree() {
        return this.canBoneMealTree;
    }

    public boolean postGrow(World world, BlockPos rootPos, BlockPos treePos, int fertility, boolean natural) {
        this.genFeatures.forEach(configuration -> configuration.generate(GenFeature.Type.POST_GROW, new PostGrowContext(world, rootPos, this, treePos, fertility, natural)));
        return true;
    }

    public boolean handleDisease(World world, TreePart baseTreePart, BlockPos treePos, Random random, int fertility) {
        if (fertility == 0 && (Double)DTConfigs.DISEASE_CHANCE.get() > (double)random.nextFloat()) {
            baseTreePart.analyse(world.func_180495_p(treePos), (IWorld)world, treePos, Direction.DOWN, new MapSignal(new DiseaseNode(this)));
            return true;
        }
        return false;
    }

    public Species envFactor(BiomeDictionary.Type type, float factor) {
        this.envFactors.put(type, Float.valueOf(factor));
        return this;
    }

    public float biomeSuitability(World world, BlockPos pos) {
        Biome biome = world.func_226691_t_(pos);
        BiomeSuitabilityEvent suitabilityEvent = new BiomeSuitabilityEvent(world, biome, this, pos);
        MinecraftForge.EVENT_BUS.post((Event)suitabilityEvent);
        if (suitabilityEvent.isHandled()) {
            return suitabilityEvent.getSuitability();
        }
        float ugs = (float)((Double)DTConfigs.SCALE_BIOME_GROWTH_RATE.get()).doubleValue();
        if (ugs == 1.0f || this.isBiomePerfect(biome)) {
            return 1.0f;
        }
        float suit = Species.defaultSuitability();
        for (BiomeDictionary.Type t : BiomeDictionary.getTypes((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName()))) {
            suit *= this.envFactors.getOrDefault(t, Float.valueOf(1.0f)).floatValue();
        }
        suit = ugs <= 0.5f ? ugs * 2.0f * suit : ((1.0f - ugs) * suit + (ugs - 0.5f)) * 2.0f;
        return MathHelper.func_76131_a((float)suit, (float)0.0f, (float)1.0f);
    }

    public boolean isBiomePerfect(Biome biome) {
        return this.perfectBiomes.contains(biome);
    }

    public boolean isBiomePerfect(RegistryKey<Biome> biome) {
        return false;
    }

    public List<Biome> getPerfectBiomes() {
        return this.perfectBiomes;
    }

    public static Biome getBiome(RegistryKey<Biome> biomeKey) {
        return (Biome)Objects.requireNonNull(ForgeRegistries.BIOMES.getValue(biomeKey.getRegistryName()));
    }

    public static RegistryKey<Biome> getBiomeKey(Biome biome) {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Objects.requireNonNull(biome.getRegistryName()));
    }

    public static float defaultSuitability() {
        return 0.85f;
    }

    @SafeVarargs
    public static boolean isOneOfBiomes(RegistryKey<Biome> biomeToCheck, RegistryKey<Biome> ... biomes) {
        for (RegistryKey<Biome> biome : biomes) {
            if (!biomeToCheck.equals(biome)) continue;
            return true;
        }
        return false;
    }

    public void setSeasonalGrowthOffset(@Nullable Float offset) {
        this.seasonalGrowthOffset = offset;
    }

    public void setSeasonalSeedDropOffset(@Nullable Float offset) {
        this.seasonalSeedDropOffset = offset;
    }

    public void setSeasonalFruitingOffset(@Nullable Float offset) {
        this.seasonalFruitingOffset = offset;
    }

    public float seasonalGrowthFactor(WorldContext worldContext, BlockPos rootPos) {
        return this.seasonalGrowthOffset != null ? SeasonHelper.globalSeasonalGrowthFactor(worldContext, rootPos, -this.seasonalGrowthOffset.floatValue()) : 1.0f;
    }

    public float seasonalSeedDropFactor(WorldContext worldContext, BlockPos pos) {
        return this.seasonalSeedDropOffset != null ? SeasonHelper.globalSeasonalSeedDropFactor(worldContext, pos, -this.seasonalSeedDropOffset.floatValue()) : 1.0f;
    }

    public float seasonalFruitProductionFactor(WorldContext worldContext, BlockPos pos) {
        return this.seasonalFruitingOffset != null ? SeasonHelper.globalSeasonalFruitProductionFactor(worldContext, pos, -this.seasonalFruitingOffset.floatValue(), false) : 1.0f;
    }

    public void inheritSeasonalFruitingOffsetToFruits() {
        this.fruits.forEach(fruit -> fruit.setSeasonOffset(this.seasonalFruitingOffset));
    }

    public void inheritSeasonalFruitingOffsetToPods() {
        this.pods.forEach(pod -> pod.setSeasonOffset(this.seasonalFruitingOffset));
    }

    public int getSeasonalTooltipFlags(World world) {
        float seasonStart = 0.16666667f;
        float seasonEnd = 0.8333333f;
        float threshold = 0.75f;
        if (this.hasFruits() || this.hasPods()) {
            int seasonFlags = 0;
            for (int i = 0; i < 4; ++i) {
                boolean isValidSeason = false;
                if (this.seasonalFruitingOffset != null) {
                    float prod2;
                    WorldContext worldContext = WorldContext.create((IWorld)world);
                    float prod1 = SeasonHelper.globalSeasonalFruitProductionFactor(worldContext, new BlockPos(0, (int)(((float)i + 0.16666667f - this.seasonalFruitingOffset.floatValue()) * 64.0f), 0), true);
                    if (Math.min(prod1, prod2 = SeasonHelper.globalSeasonalFruitProductionFactor(worldContext, new BlockPos(0, (int)(((float)i + 0.8333333f - this.seasonalFruitingOffset.floatValue()) * 64.0f), 0), true)) > 0.75f) {
                        isValidSeason = true;
                    }
                } else {
                    isValidSeason = true;
                }
                if (!isValidSeason) continue;
                seasonFlags |= 1 << i;
            }
            return seasonFlags;
        }
        return 0;
    }

    public Species setFlowerSeasonHold(float min, float max) {
        this.flowerSeasonHoldMin = min;
        this.flowerSeasonHoldMax = max;
        return this;
    }

    public boolean testFlowerSeasonHold(Float seasonValue) {
        if (this.seasonalFruitingOffset == null) {
            return false;
        }
        return SeasonHelper.isSeasonBetween(seasonValue, this.flowerSeasonHoldMin + this.seasonalFruitingOffset.floatValue(), this.flowerSeasonHoldMax + this.seasonalFruitingOffset.floatValue());
    }

    @Nullable
    public SubstanceEffect getSubstanceEffect(ItemStack itemStack) {
        if (this.canBoneMealTree() && itemStack.func_77973_b().func_206844_a(DTItemTags.FERTILIZER)) {
            return new FertilizeSubstance().setAmount(2).setGrow(true).setPulses(() -> ((ForgeConfigSpec.IntValue)DTConfigs.BONE_MEAL_GROWTH_PULSES).get());
        }
        if (itemStack.func_77973_b() instanceof SubstanceEffectProvider) {
            SubstanceEffectProvider provider = (SubstanceEffectProvider)itemStack.func_77973_b();
            return provider.getSubstanceEffect(itemStack);
        }
        if (itemStack.func_77973_b().func_206844_a(DTItemTags.ENHANCED_FERTILIZER)) {
            return new GrowthSubstance();
        }
        return null;
    }

    public boolean applySubstance(World world, BlockPos rootPos, BlockPos hitPos, PlayerEntity player, Hand hand, ItemStack itemStack) {
        SubstanceEffect effect = this.getSubstanceEffect(itemStack);
        if (effect != null) {
            boolean applied = effect.apply(world, rootPos);
            if (applied && effect.isLingering()) {
                world.func_217376_c((Entity)new LingeringEffectorEntity(world, rootPos, effect));
                return true;
            }
            return applied;
        }
        return false;
    }

    public boolean onTreeActivated(Family.TreeActivationContext context) {
        if (context.heldItem != null && this.applySubstance(context.world, context.rootPos, context.hitPos, context.player, context.hand, context.heldItem)) {
            Species.consumePlayerItem(context.player, context.hand, context.heldItem);
            return true;
        }
        return false;
    }

    public static void consumePlayerItem(PlayerEntity player, Hand hand, ItemStack heldItem) {
        if (!player.func_184812_l_()) {
            if (heldItem.func_77973_b() instanceof Emptiable) {
                Emptiable emptiable = (Emptiable)heldItem.func_77973_b();
                player.func_184611_a(hand, emptiable.getEmptyContainer());
            } else if (heldItem.func_77973_b() == Items.field_151068_bn) {
                player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151069_bo));
            } else {
                heldItem.func_190918_g(1);
            }
        }
    }

    public boolean useDefaultWailaBody() {
        return true;
    }

    public Species setAlwaysShowOnWaila(boolean alwaysShowOnWaila) {
        this.alwaysShowOnWaila = alwaysShowOnWaila;
        return this;
    }

    public boolean showSpeciesOnWaila() {
        if (this.alwaysShowOnWaila == null) {
            return this != this.getFamily().getCommonSpecies();
        }
        return this.alwaysShowOnWaila;
    }

    public Species getMegaSpecies() {
        return this.megaSpecies;
    }

    public boolean isMegaSpecies() {
        return this.isMegaSpecies;
    }

    public void setMegaSpecies(Species megaSpecies) {
        this.megaSpecies = megaSpecies;
        megaSpecies.isMegaSpecies = true;
    }

    public AnimationHandler selectAnimationHandler(FallingTreeEntity fallingEntity) {
        return this.getFamily().selectAnimationHandler(fallingEntity);
    }

    @Nullable
    public HashMap<BlockPos, BlockState> getFellingLeavesClusters(BranchDestructionData destructionData) {
        return null;
    }

    public PottedSaplingBlock getPottedSapling() {
        return DTRegistries.POTTED_SAPLING;
    }

    public boolean generate(WorldContext worldContext, BlockPos rootPos, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
        Optional<JoCode> code;
        AtomicBoolean fullGen = new AtomicBoolean(false);
        FullGenerationContext context = new FullGenerationContext(worldContext.access(), rootPos, this, biome, radius, safeBounds);
        this.genFeatures.forEach(configuration -> fullGen.set(fullGen.get() || configuration.generate(GenFeature.Type.FULL, context) != false));
        if (fullGen.get()) {
            return true;
        }
        if (!this.shouldGenerate(worldContext, rootPos)) {
            return false;
        }
        Direction facing = CoordUtils.getRandomDir(random);
        if (!JoCodeRegistry.getCodes(this.getRegistryName()).isEmpty() && (code = this.getRandomJoCode(radius, random)).isPresent()) {
            code.get().generate(worldContext, this, rootPos, biome, facing, radius, safeBounds, false);
            return true;
        }
        return false;
    }

    private boolean shouldGenerate(WorldContext worldContext, BlockPos rootPos) {
        BlockPos.Mutable pos = rootPos.func_177984_a().func_239590_i_();
        int i = 0;
        while ((float)i < this.signalEnergy) {
            if (!TreeFeature.func_236404_a_((IWorldGenerationBaseReader)worldContext.access(), (BlockPos)pos)) {
                return false;
            }
            pos.func_189536_c(Direction.UP);
            ++i;
        }
        return true;
    }

    public JoCode getJoCode(String joCodeString) {
        return new JoCode(joCodeString);
    }

    public Optional<JoCode> getRandomJoCode(Random random) {
        return this.getRandomJoCode(random.nextInt(7) + 2, random);
    }

    public Optional<JoCode> getRandomJoCode(int radius, Random random) {
        return Optional.ofNullable(JoCodeRegistry.getRandomCode(this.getRegistryName(), radius, random));
    }

    public Collection<JoCode> getJoCodes() {
        return JoCodeRegistry.getCodes(this.getRegistryName()).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Species addGenFeature(GenFeature feature) {
        return this.addGenFeature((GenFeatureConfiguration)feature.getDefaultConfiguration());
    }

    public Species addGenFeature(GenFeatureConfiguration configuration) {
        if (configuration.shouldApply(this)) {
            this.genFeatures.add(configuration);
        } else {
            LogManager.getLogger().warn("Gen Feature \"{}\" refused to be applied to Species \"{}\".", (Object)configuration.getGenFeature().getRegistryName(), (Object)this.getRegistryName());
        }
        return this;
    }

    public boolean hasGenFeatures() {
        return this.genFeatures.size() > 0;
    }

    public List<GenFeatureConfiguration> getGenFeatures() {
        return this.genFeatures;
    }

    public BlockPos preGeneration(IWorld world, BlockPos rootPosition, int radius, Direction facing, SafeChunkBounds safeBounds, JoCode joCode) {
        AtomicReference<BlockPos> rootPos = new AtomicReference<BlockPos>(rootPosition);
        this.genFeatures.forEach(configuration -> rootPos.set(configuration.generate(GenFeature.Type.PRE_GENERATION, new PreGenerationContext(world, (BlockPos)rootPos.get(), this, radius, facing, safeBounds, joCode))));
        return rootPos.get();
    }

    public void postGeneration(PostGenerationContext context) {
        this.genFeatures.forEach(configuration -> configuration.generate(GenFeature.Type.POST_GENERATION, context));
    }

    public float getWorldGenTaperingFactor() {
        return 1.5f;
    }

    public int getWorldGenLeafMapHeight() {
        return this.worldGenLeafMapHeight;
    }

    public void setWorldGenLeafMapHeight(int worldGenLeafMapHeight) {
        this.worldGenLeafMapHeight = worldGenLeafMapHeight;
    }

    public int getWorldGenAgeIterations() {
        return 3;
    }

    public NodeInspector getNodeInflator(SimpleVoxmap leafMap) {
        return new InflatorNode(this, leafMap);
    }

    public int coordHashCode(BlockPos pos) {
        return CoordUtils.coordHashCode(pos, 2);
    }

    public boolean hasFruit(Fruit fruit) {
        return this.fruits.contains(fruit);
    }

    public boolean hasFruits() {
        return !this.fruits.isEmpty();
    }

    public void addFruits(Collection<Fruit> fruits) {
        this.fruits.addAll(fruits);
    }

    public Set<Fruit> getFruits() {
        return Collections.unmodifiableSet(this.fruits);
    }

    public boolean hasPod(Pod pod) {
        return this.pods.contains(pod);
    }

    public boolean hasPods() {
        return !this.pods.isEmpty();
    }

    public void addPods(Collection<Pod> pods) {
        this.pods.addAll(pods);
    }

    public Set<Pod> getPods() {
        return Collections.unmodifiableSet(this.pods);
    }

    public List<ITag.INamedTag<Block>> defaultSaplingTags() {
        return Collections.singletonList(DTBlockTags.SAPLINGS);
    }

    public List<ITag.INamedTag<Item>> defaultSeedTags() {
        return Collections.singletonList(DTItemTags.SEEDS);
    }

    public ResourceLocation getSaplingSmartModelLocation() {
        return DynamicTrees.resLoc("block/smartmodel/sapling");
    }

    public void addSaplingTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation leavesTextureLocation, ResourceLocation barkTextureLocation) {
        textureConsumer.accept("particle", leavesTextureLocation);
        textureConsumer.accept("log", barkTextureLocation);
        textureConsumer.accept("leaves", leavesTextureLocation);
    }

    @Override
    public void generateStateData(DTBlockStateProvider provider) {
        this.saplingStateGenerator.get().generate(provider, this);
    }

    public ResourceLocation getSeedParentLocation() {
        return DynamicTrees.resLoc("item/standard_seed");
    }

    public Generator<DTItemModelProvider, Species> getSeedModelGenerator() {
        return this.seedModelGenerator.get();
    }

    @Override
    public void generateItemModelData(DTItemModelProvider provider) {
        this.seedModelGenerator.get().generate(provider, this);
    }

    public boolean shouldGenerateVoluntaryDrops() {
        return this.seed != null;
    }

    public ResourceLocation getVoluntaryDropsPath() {
        return this.voluntaryDropsPath.get();
    }

    public LootTable.Builder createVoluntaryDrops() {
        return DTLootTableProvider.createVoluntaryDrops(this.seed);
    }

    public void setDropSeeds(boolean dropSeeds) {
        this.dropSeeds = dropSeeds;
    }

    public boolean shouldDropSeeds() {
        return Optional.ofNullable(this.dropSeeds).orElse(!this.hasFruits());
    }

    @Override
    public String toLoadDataString() {
        RegistryHandler registryHandler = RegistryHandler.get(this.getRegistryName().func_110624_b());
        return this.getString(Pair.of((Object)"seed", this.seed != null ? registryHandler.getRegName(this.seed) : null), Pair.of((Object)"sapling", this.saplingBlock != null ? "Block{" + registryHandler.getRegName(this.saplingBlock) + "}" : null));
    }

    @Override
    public String toReloadDataString() {
        return this.getString(Pair.of((Object)"tapering", (Object)Float.valueOf(this.tapering)), Pair.of((Object)"upProbability", (Object)this.upProbability), Pair.of((Object)"lowestBranchHeight", (Object)this.lowestBranchHeight), Pair.of((Object)"signalEnergy", (Object)Float.valueOf(this.signalEnergy)), Pair.of((Object)"growthRate", (Object)Float.valueOf(this.growthRate)), Pair.of((Object)"soilLongevity", (Object)this.soilLongevity), Pair.of((Object)"soilTypeFlags", (Object)this.soilTypeFlags), Pair.of((Object)"maxBranchRadius", (Object)this.maxBranchRadius), Pair.of((Object)"transformable", (Object)this.transformable), Pair.of((Object)"logicKit", (Object)this.logicKit), Pair.of((Object)"leavesProperties", (Object)this.leavesProperties), Pair.of((Object)"envFactors", this.envFactors), Pair.of((Object)"megaSpecies", (Object)this.megaSpecies), Pair.of((Object)"seed", (Object)((Object)this.seed)), Pair.of((Object)"primitive_sapling", (Object)TreeRegistry.SAPLING_REPLACERS.entrySet().stream().filter(entry -> entry.getValue() == this).map(Map.Entry::getKey).findAny().orElse(BlockStates.AIR)), Pair.of((Object)"perfectBiomes", this.perfectBiomes), Pair.of((Object)"acceptableBlocksForGrowth", this.acceptableBlocksForGrowth), Pair.of((Object)"genFeatures", this.genFeatures));
    }

    public static class LogsAndSticks {
        public List<ItemStack> logs;
        public final int sticks;

        public LogsAndSticks(List<ItemStack> logs, int sticks) {
            this.logs = logs;
            this.sticks = (Boolean)DTConfigs.DROP_STICKS.get() != false ? sticks : 0;
        }
    }

    @FunctionalInterface
    public static interface CommonOverride
    extends BiPredicate<IBlockReader, BlockPos> {
    }
}

