/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees.species;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import com.mojang.datafixers.util.Function3;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;

public class SwampOakSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = SwampOakSpecies.createDefaultType((Function3<ResourceLocation, Family, LeavesProperties, Species>)((Function3)SwampOakSpecies::new));
    private static final int minRadiusForSunkGeneration = 5;

    public SwampOakSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
    }

    @Override
    public boolean generate(WorldContext worldContext, BlockPos rootPos, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
        if (this.isWater(worldContext.access().func_180495_p(rootPos))) {
            switch ((DynamicTrees.SwampOakWaterState)((Object)DTConfigs.SWAMP_OAKS_IN_WATER.get())) {
                case SUNK: {
                    if (radius >= 5) {
                        return super.generate(worldContext, rootPos.func_177977_b(), biome, random, radius, safeBounds);
                    }
                    return false;
                }
                case DISABLED: {
                    return false;
                }
            }
        }
        return super.generate(worldContext, rootPos, biome, random, radius, safeBounds);
    }
}

