/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.Region;
import net.minecraft.world.World;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.gen.Heightmap;

public final class CoordUtils {
    public static int coordXor = 0;
    public static final Direction[] HORIZONTALS = new Direction[]{Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST};
    private static final int[][] coordHashMap = new int[][]{{4111, 271, 3067}, {7933711, 6144389, 9538033}, {9973, 8287, 9721}, {7211, 5437, 9613}};

    public static boolean isSurroundedByLoadedChunks(World world, BlockPos pos) {
        for (Surround surr : Surround.values()) {
            Vector3i dir = surr.getOffset();
            if (world.func_72863_F().func_222865_a(new ChunkPos((pos.func_177958_n() >> 4) + dir.func_177958_n(), (pos.func_177952_p() >> 4) + dir.func_177952_p()))) continue;
            return false;
        }
        return true;
    }

    public static boolean canAccessStateSafely(IBlockReader blockReader, BlockPos pos) {
        if (blockReader instanceof IWorldReader) {
            return ((IWorldReader)blockReader).func_217354_b(SectionPos.func_218159_a((int)pos.func_177958_n()), SectionPos.func_218159_a((int)pos.func_177952_p()));
        }
        if (blockReader instanceof Region) {
            return !(((Region)blockReader).func_226703_d_(pos) instanceof EmptyChunk);
        }
        return true;
    }

    @Nullable
    public static BlockState getStateSafe(IBlockReader blockReader, BlockPos blockPos) {
        return CoordUtils.canAccessStateSafely(blockReader, blockPos) ? blockReader.func_180495_p(blockPos) : null;
    }

    public static Direction getRandomDir(Random rand) {
        return Direction.values()[2 + rand.nextInt(4)];
    }

    public static BlockPos getRayTraceFruitPos(IWorld world, Species species, BlockPos treePos, BlockPos branchPos, SafeChunkBounds safeBounds) {
        BlockPos hitPos;
        BlockRayTraceResult result = CoordUtils.branchRayTrace(world, species, treePos, branchPos, 45.0f, 60.0f, 4 + world.func_201674_k().nextInt(3), safeBounds);
        if (result != null && (hitPos = new BlockPos(result.func_216347_e())) != BlockPos.field_177992_a) {
            do {
                hitPos = hitPos.func_177977_b();
            } while (species.getFamily().isCompatibleGenericLeaves(species, world.func_180495_p(hitPos), world, hitPos));
            if (world.func_175623_d(hitPos)) {
                return hitPos;
            }
        }
        return BlockPos.field_177992_a;
    }

    @Nullable
    public static BlockRayTraceResult branchRayTrace(IWorld world, Species species, BlockPos treePos, BlockPos branchPos, float spreadHor, float spreadVer, float distance, SafeChunkBounds safeBounds) {
        treePos = new BlockPos(treePos.func_177958_n(), branchPos.func_177956_o(), treePos.func_177952_p());
        Vector3d vOut = new Vector3d((double)(branchPos.func_177958_n() - treePos.func_177958_n()), 0.0, (double)(branchPos.func_177952_p() - treePos.func_177952_p()));
        if (vOut.equals((Object)Vector3d.field_186680_a)) {
            vOut = new Vector3d(1.0, 0.0, 0.0);
            spreadHor = 180.0f;
        }
        float deltaYaw = world.func_201674_k().nextFloat() * spreadHor * 2.0f - spreadHor;
        float deltaPitch = world.func_201674_k().nextFloat() * -spreadVer;
        vOut = vOut.func_72432_b().func_72441_c(0.0, Math.tan(Math.toRadians(deltaPitch)), 0.0).func_72432_b().func_178785_b((float)Math.toRadians(deltaYaw)).func_186678_a((double)distance);
        Vector3d branchVec = new Vector3d((double)branchPos.func_177958_n(), (double)branchPos.func_177956_o(), (double)branchPos.func_177952_p()).func_72441_c(0.5, 0.5, 0.5);
        Vector3d vantageVec = branchVec.func_178787_e(vOut);
        BlockPos vantagePos = new BlockPos(vantageVec);
        if (!safeBounds.inBounds(vantagePos, false) || world.func_175623_d(vantagePos)) {
            BlockRayTraceResult result = CoordUtils.rayTraceBlocks(world, new CustomRayTraceContext(vantageVec, branchVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE), safeBounds);
            BlockPos hitPos = new BlockPos(result.func_216347_e());
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK && !hitPos.equals((Object)BlockPos.field_177992_a) && species.getFamily().isCompatibleGenericLeaves(species, world.func_180495_p(hitPos), world, hitPos)) {
                return result;
            }
        }
        return null;
    }

    public static BlockRayTraceResult rayTraceBlocks(IWorld world, CustomRayTraceContext context, SafeChunkBounds safeBounds) {
        return CoordUtils.getRayTraceVector(context, (fromContext, blockPos) -> {
            BlockState blockstate = safeBounds.inBounds((BlockPos)blockPos, false) ? world.func_180495_p(blockPos) : Blocks.field_150350_a.func_176223_P();
            FluidState fluidState = safeBounds.inBounds((BlockPos)blockPos, false) ? world.func_204610_c(blockPos) : Fluids.field_204541_a.func_207188_f();
            Vector3d startVec = fromContext.getStartVector();
            Vector3d endVec = fromContext.getEndVector();
            VoxelShape voxelshape = safeBounds.inBounds((BlockPos)blockPos, false) ? fromContext.getBlockShape(blockstate, (IBlockReader)world, (BlockPos)blockPos) : VoxelShapes.func_197880_a();
            BlockRayTraceResult blockraytraceresult = world.func_217296_a(startVec, endVec, blockPos, voxelshape, blockstate);
            VoxelShape voxelshape1 = safeBounds.inBounds((BlockPos)blockPos, false) ? fromContext.getFluidShape(fluidState, (IBlockReader)world, (BlockPos)blockPos) : VoxelShapes.func_197880_a();
            BlockRayTraceResult blockraytraceresult1 = voxelshape1.func_212433_a(startVec, endVec, blockPos);
            double d0 = blockraytraceresult == null ? Double.MAX_VALUE : fromContext.getStartVector().func_72436_e(blockraytraceresult.func_216347_e());
            double d1 = blockraytraceresult1 == null ? Double.MAX_VALUE : fromContext.getStartVector().func_72436_e(blockraytraceresult1.func_216347_e());
            return d0 <= d1 ? blockraytraceresult : blockraytraceresult1;
        }, context1 -> {
            Vector3d vec3d = context1.getStartVector().func_178788_d(context1.getEndVector());
            return BlockRayTraceResult.func_216352_a((Vector3d)context1.getEndVector(), (Direction)Direction.func_210769_a((double)vec3d.field_72450_a, (double)vec3d.field_72448_b, (double)vec3d.field_72449_c), (BlockPos)new BlockPos(context1.getEndVector()));
        });
    }

    private static <T> T getRayTraceVector(CustomRayTraceContext context, BiFunction<CustomRayTraceContext, BlockPos, T> biFunction, Function<CustomRayTraceContext, T> function) {
        int k;
        int j;
        Vector3d endVec;
        Vector3d startVec = context.getStartVector();
        if (startVec.equals((Object)(endVec = context.getEndVector()))) {
            return function.apply(context);
        }
        double vantX = MathHelper.func_219803_d((double)-1.0E-7, (double)endVec.field_72450_a, (double)startVec.field_72450_a);
        double vantY = MathHelper.func_219803_d((double)-1.0E-7, (double)endVec.field_72448_b, (double)startVec.field_72448_b);
        double vantZ = MathHelper.func_219803_d((double)-1.0E-7, (double)endVec.field_72449_c, (double)startVec.field_72449_c);
        double lookX = MathHelper.func_219803_d((double)-1.0E-7, (double)startVec.field_72450_a, (double)endVec.field_72450_a);
        double lookY = MathHelper.func_219803_d((double)-1.0E-7, (double)startVec.field_72448_b, (double)endVec.field_72448_b);
        double lookZ = MathHelper.func_219803_d((double)-1.0E-7, (double)startVec.field_72449_c, (double)endVec.field_72449_c);
        int i = MathHelper.func_76128_c((double)lookX);
        BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable(i, j = MathHelper.func_76128_c((double)lookY), k = MathHelper.func_76128_c((double)lookZ));
        T t = biFunction.apply(context, (BlockPos)blockpos$mutableblockpos);
        if (t != null) {
            return t;
        }
        double d6 = vantX - lookX;
        double d7 = vantY - lookY;
        double d8 = vantZ - lookZ;
        int l = MathHelper.func_219802_k((double)d6);
        int i1 = MathHelper.func_219802_k((double)d7);
        int j1 = MathHelper.func_219802_k((double)d8);
        double d9 = l == 0 ? Double.MAX_VALUE : (double)l / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / d8;
        double d12 = d9 * (l > 0 ? 1.0 - MathHelper.func_181162_h((double)lookX) : MathHelper.func_181162_h((double)lookX));
        double d13 = d10 * (i1 > 0 ? 1.0 - MathHelper.func_181162_h((double)lookY) : MathHelper.func_181162_h((double)lookY));
        double d14 = d11 * (j1 > 0 ? 1.0 - MathHelper.func_181162_h((double)lookZ) : MathHelper.func_181162_h((double)lookZ));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    i += l;
                    d12 += d9;
                } else {
                    k += j1;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                j += i1;
                d13 += d10;
            } else {
                k += j1;
                d14 += d11;
            }
            if ((t1 = biFunction.apply(context, (BlockPos)blockpos$mutableblockpos.func_181079_c(i, j, k))) == null) continue;
            return t1;
        }
        return function.apply(context);
    }

    public static BlockPos findWorldSurface(IWorld world, BlockPos startPos, boolean worldGen) {
        return new BlockPos(startPos.func_177958_n(), world.func_201676_a(worldGen ? Heightmap.Type.WORLD_SURFACE_WG : Heightmap.Type.WORLD_SURFACE, startPos.func_177958_n(), startPos.func_177952_p()) - 1, startPos.func_177952_p());
    }

    public static int coordHashCode(BlockPos pos, int a, int b, int c) {
        int hash = (pos.func_177958_n() * a ^ pos.func_177956_o() * b ^ pos.func_177952_p() * c) >> 1;
        return (hash ^ coordXor) & 0xFFFF;
    }

    public static int coordHashCode(BlockPos pos, int readyMade) {
        int[] factors = coordHashMap[readyMade & 3];
        return CoordUtils.coordHashCode(pos, factors[0], factors[1], factors[2]);
    }

    public static Iterable<BlockPos> goHorSides(BlockPos pos) {
        return CoordUtils.goHorSides(pos, null);
    }

    public static Iterable<BlockPos> goHorSides(final BlockPos pos, final @Nullable Direction ignore) {
        return new Iterable<BlockPos>(){

            @Override
            @Nonnull
            public Iterator<BlockPos> iterator() {
                return new AbstractIterator<BlockPos>(){
                    private int currentDir = 0;

                    protected BlockPos computeNext() {
                        while (this.currentDir < HORIZONTALS.length) {
                            Direction face;
                            if ((face = HORIZONTALS[this.currentDir++]) == ignore) continue;
                            return pos.func_177972_a(face);
                        }
                        return (BlockPos)this.endOfData();
                    }
                };
            }
        };
    }

    private static class CustomRayTraceContext {
        private final Vector3d startVec;
        private final Vector3d endVec;
        private final RayTraceContext.BlockMode blockMode;
        private final RayTraceContext.FluidMode fluidMode;

        public CustomRayTraceContext(Vector3d startVecIn, Vector3d endVecIn, RayTraceContext.BlockMode blockModeIn, RayTraceContext.FluidMode fluidModeIn) {
            this.startVec = startVecIn;
            this.endVec = endVecIn;
            this.blockMode = blockModeIn;
            this.fluidMode = fluidModeIn;
        }

        public Vector3d getEndVector() {
            return this.endVec;
        }

        public Vector3d getStartVector() {
            return this.startVec;
        }

        public VoxelShape getBlockShape(BlockState state, IBlockReader world, BlockPos pos) {
            return this.blockMode.get(state, world, pos, ISelectionContext.func_216377_a());
        }

        public VoxelShape getFluidShape(FluidState state, IBlockReader world, BlockPos pos) {
            return this.fluidMode.func_222248_a(state) ? state.func_215676_d(world, pos) : VoxelShapes.func_197880_a();
        }
    }

    public static enum Surround implements IStringSerializable
    {
        N("n", Direction.NORTH),
        NW("nw", Direction.NORTH, Direction.WEST),
        W("w", Direction.WEST),
        SW("sw", Direction.SOUTH, Direction.WEST),
        S("s", Direction.SOUTH),
        SE("se", Direction.SOUTH, Direction.EAST),
        E("e", Direction.EAST),
        NE("ne", Direction.NORTH, Direction.EAST);

        private final String name;
        private final Vector3i offset;

        private Surround(String name, Direction ... dirs) {
            this.name = name;
            BlockPos pos = BlockPos.field_177992_a;
            for (Direction d : dirs) {
                pos = pos.func_177971_a(d.func_176730_m());
            }
            this.offset = pos;
        }

        public String func_176610_l() {
            return this.name;
        }

        public Vector3i getOffset() {
            return this.offset;
        }

        public BlockPos getOffsetPos() {
            return new BlockPos(this.offset);
        }

        public Surround getOpposite() {
            return Surround.values()[this.ordinal() + 4 & 7];
        }
    }
}

