/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public final class ShapeFunctions {
    private static final Map<String, ShapeFunction<?>> SHAPE_FUNCTIONS = (Map)Util.func_200696_a((Object)Maps.newHashMap(), shapeFunctions -> {
        shapeFunctions.put("fruit", new FruitShapeFunction());
        shapeFunctions.put("pod", new PodShapeFunction());
    });

    public static boolean registerShapeFunction(String functionId, ShapeFunction<?> shapeFunction) {
        return SHAPE_FUNCTIONS.putIfAbsent(functionId, shapeFunction) == null;
    }

    public static DataResult<VoxelShape> calculateShape(String functionId, JsonElement parametersJson) {
        ShapeFunction<?> shapeFunction = SHAPE_FUNCTIONS.get(functionId);
        return shapeFunction != null ? ShapeFunctions.calculateShape(shapeFunction, parametersJson) : DataResult.error((String)("No shape function with ID \"" + functionId + "\"."));
    }

    private static <P> DataResult<VoxelShape> calculateShape(ShapeFunction<P> shapeFunction, JsonElement parametersJson) {
        return shapeFunction.getParameters(parametersJson).map(pair -> shapeFunction.calculateShape(pair.getFirst()));
    }

    public static class PodShapeFunction
    implements ShapeFunction<Parameters> {
        @Override
        public DataResult<Pair<Parameters, JsonElement>> getParameters(JsonElement json) {
            return Parameters.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
        }

        @Override
        public VoxelShape calculateShape(Parameters parameters) {
            float fraction = parameters.fraction;
            float radius = parameters.radius;
            float topHeight = fraction - parameters.stemLength;
            float bottomHeight = topHeight - parameters.height;
            float sideOffset = parameters.sideOffset / fraction;
            Direction side = parameters.side;
            return VoxelShapes.func_197881_a((AxisAlignedBB)PodShapeFunction.offsetBoundingBox(FruitShapeFunction.createFruitShape(fraction, radius, topHeight, bottomHeight), side, sideOffset));
        }

        public static AxisAlignedBB offsetBoundingBox(AxisAlignedBB box, Direction dir, float offset) {
            return box.func_72317_d((double)((float)dir.func_82601_c() * offset), (double)((float)dir.func_96559_d() * offset), (double)((float)dir.func_82599_e() * offset));
        }

        public static class Parameters {
            public static final Codec<Parameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("radius").forGetter(Parameters::getRadius), (App)Codec.FLOAT.fieldOf("height").forGetter(Parameters::getHeight), (App)Codec.FLOAT.fieldOf("stem_length").forGetter(Parameters::getStemLength), (App)Codec.FLOAT.optionalFieldOf("fraction", (Object)Float.valueOf(16.0f)).forGetter(Parameters::getFraction), (App)Codec.FLOAT.fieldOf("side_offset").forGetter(Parameters::getSideOffset), (App)Codec.STRING.fieldOf("side").forGetter(Parameters::getSide)).apply((Applicative)instance, Parameters::new));
            private final float radius;
            private final float height;
            private final float stemLength;
            private final float fraction;
            private final float sideOffset;
            private final Direction side;

            public Parameters(float radius, float height, float stemLength, float fraction, float sideOffset, String side) {
                this.radius = radius;
                this.height = height;
                this.stemLength = stemLength;
                this.fraction = fraction;
                this.sideOffset = sideOffset;
                this.side = Optional.ofNullable(Direction.func_176739_a((String)side)).orElse(Direction.NORTH);
            }

            public float getRadius() {
                return this.radius;
            }

            public float getHeight() {
                return this.height;
            }

            public float getStemLength() {
                return this.stemLength;
            }

            public float getFraction() {
                return this.fraction;
            }

            public float getSideOffset() {
                return this.sideOffset;
            }

            public String getSide() {
                return this.side.name();
            }
        }
    }

    public static class FruitShapeFunction
    implements ShapeFunction<Parameters> {
        @Override
        public DataResult<Pair<Parameters, JsonElement>> getParameters(JsonElement json) {
            return Parameters.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
        }

        @Override
        public VoxelShape calculateShape(Parameters parameters) {
            float fraction = parameters.fraction;
            float radius = parameters.radius;
            float topHeight = fraction - parameters.stemLength;
            float bottomHeight = topHeight - parameters.height;
            return VoxelShapes.func_197881_a((AxisAlignedBB)FruitShapeFunction.createFruitShape(fraction, radius, topHeight, bottomHeight));
        }

        public static AxisAlignedBB createFruitShape(float fraction, float radius, float topHeight, float bottomHeight) {
            return new AxisAlignedBB((double)((fraction / 2.0f - radius) / fraction), (double)(topHeight / fraction), (double)((fraction / 2.0f - radius) / fraction), (double)((fraction / 2.0f + radius) / fraction), (double)(bottomHeight / fraction), (double)((fraction / 2.0f + radius) / fraction));
        }

        public static class Parameters {
            public static final Codec<Parameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("radius").forGetter(Parameters::getRadius), (App)Codec.FLOAT.fieldOf("height").forGetter(Parameters::getHeight), (App)Codec.FLOAT.fieldOf("stem_length").forGetter(Parameters::getStemLength), (App)Codec.FLOAT.optionalFieldOf("fraction", (Object)Float.valueOf(20.0f)).forGetter(Parameters::getFraction)).apply((Applicative)instance, Parameters::new));
            private final float radius;
            private final float height;
            private final float stemLength;
            private final float fraction;

            public Parameters(float radius, float height, float stemLength, float fraction) {
                this.radius = radius;
                this.height = height;
                this.stemLength = stemLength;
                this.fraction = fraction;
            }

            public float getRadius() {
                return this.radius;
            }

            public float getHeight() {
                return this.height;
            }

            public float getStemLength() {
                return this.stemLength;
            }

            public float getFraction() {
                return this.fraction;
            }
        }
    }

    public static interface ShapeFunction<P> {
        public DataResult<Pair<P, JsonElement>> getParameters(JsonElement var1);

        public VoxelShape calculateShape(P var1);
    }
}

