/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.google.common.collect.AbstractIterator;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class SimpleVoxmap {
    private final byte[] data;
    private final boolean[] touched;
    private final int lenX;
    private final int lenY;
    private final int lenZ;
    private final int layerSize;
    BlockPos center = new BlockPos(0, 0, 0);

    public SimpleVoxmap(int lenX, int lenY, int lenZ) {
        this.data = new byte[lenX * lenY * lenZ];
        this.touched = new boolean[lenY];
        this.lenX = lenX;
        this.lenY = lenY;
        this.lenZ = lenZ;
        this.layerSize = lenX * lenZ;
    }

    public SimpleVoxmap(int lenX, int lenY, int lenZ, byte[] extData) {
        this.data = Arrays.copyOf(extData, lenX * lenY * lenZ);
        this.touched = new boolean[lenY];
        for (int y = 0; y < lenY; ++y) {
            this.touched[y] = true;
        }
        this.lenX = lenX;
        this.lenY = lenY;
        this.lenZ = lenZ;
        this.layerSize = lenX * lenZ;
    }

    public SimpleVoxmap(SimpleVoxmap vmp) {
        this(vmp.getLenX(), vmp.getLenY(), vmp.getLenZ(), vmp.data);
        this.center = vmp.center;
    }

    public SimpleVoxmap(BlockBounds bounds) {
        this(bounds.getXSize(), bounds.getYSize(), bounds.getZSize());
        this.setMapAndCenter(bounds.getMin(), new BlockPos(0, 0, 0));
    }

    public SimpleVoxmap setMapAndCenter(BlockPos mapPos, BlockPos centerPos) {
        this.setCenter(centerPos);
        this.center = this.center.func_177973_b((Vector3i)mapPos);
        return this;
    }

    public SimpleVoxmap setMap(BlockPos mapPos) {
        this.center = this.center.func_177973_b((Vector3i)mapPos);
        return this;
    }

    public SimpleVoxmap setCenter(BlockPos centerPos) {
        this.center = centerPos;
        return this;
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLenX() {
        return this.lenX;
    }

    public int getLenY() {
        return this.lenY;
    }

    public int getLenZ() {
        return this.lenZ;
    }

    public BlockBounds getBounds() {
        int minX = this.center.func_177958_n() - this.lenX + 1;
        int minY = this.center.func_177956_o() - this.lenY + 1;
        int minZ = this.center.func_177952_p() - this.lenZ + 1;
        int maxX = minX + this.lenX - 1;
        int maxY = minY + this.lenY - 1;
        int maxZ = minZ + this.lenZ - 1;
        return new BlockBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public SimpleVoxmap blitOp(BlockPos pos, SimpleVoxmap src, BlitOp op) {
        for (int iy = 0; iy < src.getLenY(); ++iy) {
            int srcY = iy - src.center.func_177956_o();
            int dstY = pos.func_177956_o() + srcY;
            this.setYTouched(dstY);
            for (int iz = 0; iz < src.getLenZ(); ++iz) {
                int srcZ = iz - src.center.func_177952_p();
                int dstZ = pos.func_177952_p() + srcZ;
                for (int ix = 0; ix < src.getLenX(); ++ix) {
                    int srcX = ix - src.center.func_177958_n();
                    int dstX = pos.func_177958_n() + srcX;
                    byte srcValue = src.getVoxel(srcX, srcY, srcZ);
                    byte dstValue = this.getVoxel(dstX, dstY, dstZ);
                    this.setVoxel(dstX, dstY, dstZ, op.getOp(srcValue, dstValue));
                }
            }
        }
        return this;
    }

    public SimpleVoxmap blitReplace(BlockPos pos, SimpleVoxmap src) {
        return this.blitOp(pos, src, (s, d) -> s);
    }

    public SimpleVoxmap blitMax(BlockPos pos, SimpleVoxmap src) {
        return this.blitOp(pos, src, (s, d) -> s >= d ? s : d);
    }

    public SimpleVoxmap blitClear(BlockPos pos, SimpleVoxmap src) {
        return this.blitOp(pos, src, (s, d) -> s >= 0 ? (byte)0 : d);
    }

    public SimpleVoxmap filter(FilterOp op) {
        Arrays.fill(this.touched, true);
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = op.getOp(this.data[i]);
        }
        return this;
    }

    public SimpleVoxmap crop(BlockPos from, BlockPos to) {
        for (BlockPos.Mutable pos : this.getAllNonZero()) {
            if (pos.func_177958_n() >= from.func_177958_n() && pos.func_177956_o() >= from.func_177956_o() && pos.func_177952_p() >= from.func_177952_p() && pos.func_177958_n() <= to.func_177958_n() && pos.func_177956_o() <= to.func_177956_o() && pos.func_177952_p() <= to.func_177952_p()) continue;
            this.setVoxel((BlockPos)pos, (byte)0);
        }
        return this;
    }

    public SimpleVoxmap filter(BlockPos from, BlockPos to, FilterOp op) {
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)from, (BlockPos)to)) {
            this.setVoxel(pos, op.getOp(this.getVoxel(pos)));
        }
        return this;
    }

    public SimpleVoxmap fill(byte value) {
        return this.filter(v -> value);
    }

    public SimpleVoxmap fill(BlockPos from, BlockPos to, byte value) {
        return this.filter(from, to, v -> value);
    }

    private int calcPos(int x, int y, int z) {
        return y * this.lenX * this.lenZ + z * this.lenX + x;
    }

    public void setVoxel(BlockPos pos, byte value) {
        this.setVoxel(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), value);
    }

    public void setVoxelOr(BlockPos pos, byte value) {
        this.setVoxelOr(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), value);
    }

    public void setVoxel(int x, int y, int z, byte value) {
        if (this.testBounds(x += this.center.func_177958_n(), y += this.center.func_177956_o(), z += this.center.func_177952_p())) {
            if (value != 0) {
                this.setYTouched(y - this.center.func_177956_o());
            }
            this.data[this.calcPos((int)x, (int)y, (int)z)] = value;
        }
    }

    public void setVoxelOr(int x, int y, int z, byte value) {
        if (this.testBounds(x += this.center.func_177958_n(), y += this.center.func_177956_o(), z += this.center.func_177952_p())) {
            if (value != 0) {
                this.setYTouched(y - this.center.func_177956_o());
            }
            int n = this.calcPos(x, y, z);
            this.data[n] = (byte)(this.data[n] | value);
        }
    }

    public byte getVoxel(BlockPos relPos, BlockPos pos) {
        return this.getVoxel(pos.func_177958_n() - relPos.func_177958_n(), pos.func_177956_o() - relPos.func_177956_o(), pos.func_177952_p() - relPos.func_177952_p());
    }

    public byte getVoxel(BlockPos pos) {
        return this.getVoxel(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public byte getVoxel(int x, int y, int z) {
        if (this.isYTouched(y)) {
            return this.testBounds(x += this.center.func_177958_n(), y += this.center.func_177956_o(), z += this.center.func_177952_p()) ? this.data[this.calcPos(x, y, z)] : (byte)0;
        }
        return 0;
    }

    private boolean testBounds(int x, int y, int z) {
        return x >= 0 && x < this.lenX && y >= 0 && y < this.lenY && z >= 0 && z < this.lenZ;
    }

    public boolean isYTouched(int y) {
        return (y += this.center.func_177956_o()) >= 0 && y < this.lenY && this.touched[y];
    }

    public void setYTouched(int y) {
        if ((y += this.center.func_177956_o()) >= 0 && y < this.lenY) {
            this.touched[y] = true;
        }
    }

    public Iterable<Cell> getAllNonZeroCells() {
        return this.getAllNonZeroCells((byte)-1);
    }

    public Iterable<Cell> getAllNonZeroCells(final byte mask) {
        return new Iterable<Cell>(){

            @Override
            public Iterator<Cell> iterator() {
                return new AbstractIterator<Cell>(){
                    private int x = -1;
                    private int y = 0;
                    private int z = 0;
                    private int dataPos = -1;
                    private final Cell workingCell = new Cell();
                    private final BlockPos.Mutable dPos = this.workingCell.getPos();

                    protected Cell computeNext() {
                        byte value;
                        block0: while (true) {
                            if (this.x < SimpleVoxmap.this.lenX - 1) {
                                ++this.x;
                            } else if (this.z < SimpleVoxmap.this.lenZ - 1) {
                                this.x = 0;
                                ++this.z;
                            } else {
                                this.x = -1;
                                this.z = 0;
                                ++this.y;
                                while (this.y < SimpleVoxmap.this.lenY) {
                                    if (SimpleVoxmap.this.touched[this.y]) continue block0;
                                    this.dataPos += SimpleVoxmap.this.layerSize;
                                    ++this.y;
                                }
                                return (Cell)this.endOfData();
                            }
                            if ((value = (byte)(SimpleVoxmap.this.data[++this.dataPos] & mask)) > 0) break;
                        }
                        this.dPos.func_181079_c(this.x - SimpleVoxmap.this.center.func_177958_n(), this.y - SimpleVoxmap.this.center.func_177956_o(), this.z - SimpleVoxmap.this.center.func_177952_p());
                        return this.workingCell.setValue(value);
                    }
                };
            }
        };
    }

    public Iterable<BlockPos.Mutable> getAllNonZero() {
        return this.getAllNonZero((byte)-1);
    }

    public Iterable<BlockPos.Mutable> getAllNonZero(final byte mask) {
        return new Iterable<BlockPos.Mutable>(){

            @Override
            public Iterator<BlockPos.Mutable> iterator() {
                return new AbstractIterator<BlockPos.Mutable>(){
                    private int x = -1;
                    private int y = 0;
                    private int z = 0;
                    private int dataPos = -1;
                    private boolean yclean;
                    private final BlockPos.Mutable dPos = new BlockPos.Mutable();

                    protected BlockPos.Mutable computeNext() {
                        block0: while (true) {
                            if (this.x < SimpleVoxmap.this.lenX - 1) {
                                ++this.x;
                            } else if (this.z < SimpleVoxmap.this.lenZ - 1) {
                                this.x = 0;
                                ++this.z;
                            } else {
                                this.x = -1;
                                this.z = 0;
                                ((SimpleVoxmap)SimpleVoxmap.this).touched[this.y] = !this.yclean;
                                ++this.y;
                                this.yclean = true;
                                while (this.y < SimpleVoxmap.this.lenY) {
                                    if (SimpleVoxmap.this.touched[this.y]) continue block0;
                                    this.dataPos += SimpleVoxmap.this.layerSize;
                                    ++this.y;
                                    this.yclean = true;
                                }
                                return (BlockPos.Mutable)this.endOfData();
                            }
                            if ((SimpleVoxmap.this.data[++this.dataPos] & mask) > 0) break;
                        }
                        this.yclean = false;
                        return this.dPos.func_181079_c(this.x - SimpleVoxmap.this.center.func_177958_n(), this.y - SimpleVoxmap.this.center.func_177956_o(), this.z - SimpleVoxmap.this.center.func_177952_p());
                    }
                };
            }
        };
    }

    public Iterable<BlockPos.Mutable> getTops() {
        return new Iterable<BlockPos.Mutable>(){

            @Override
            public Iterator<BlockPos.Mutable> iterator() {
                return new AbstractIterator<BlockPos.Mutable>(){
                    private int x = -1;
                    private int y = 0;
                    private int z = 0;
                    private final int yStart = this.getStartY();
                    private final BlockPos.Mutable dPos = new BlockPos.Mutable();

                    protected int getStartY() {
                        int yi;
                        for (yi = SimpleVoxmap.this.lenY - 1; yi >= 0 && !SimpleVoxmap.this.touched[yi]; --yi) {
                        }
                        return yi;
                    }

                    protected BlockPos.Mutable computeNext() {
                        block0: while (true) {
                            if (this.x < SimpleVoxmap.this.lenX - 1) {
                                ++this.x;
                            } else if (this.z < SimpleVoxmap.this.lenZ - 1) {
                                this.x = 0;
                                ++this.z;
                            } else {
                                return (BlockPos.Mutable)this.endOfData();
                            }
                            this.y = this.yStart;
                            int dataPos = SimpleVoxmap.this.calcPos(this.x, this.y, this.z);
                            while (true) {
                                if (this.y < 0) continue block0;
                                if (SimpleVoxmap.this.data[dataPos] != 0) {
                                    return this.dPos.func_181079_c(this.x - SimpleVoxmap.this.center.func_177958_n(), this.y - SimpleVoxmap.this.center.func_177956_o(), this.z - SimpleVoxmap.this.center.func_177952_p());
                                }
                                dataPos -= SimpleVoxmap.this.layerSize;
                                --this.y;
                            }
                            break;
                        }
                    }
                };
            }
        };
    }

    public void print() {
        for (int y = 0; y < this.lenY; ++y) {
            StringBuilder buffer;
            System.out.println("Touched: " + this.touched[y]);
            for (int z = 0; z < this.lenZ; ++z) {
                buffer = new StringBuilder();
                for (int x = 0; x < this.lenX; ++x) {
                    byte b = this.getVoxel(x - this.center.func_177958_n(), y - this.center.func_177956_o(), z - this.center.func_177952_p());
                    if ((b & 0x20) != 0) {
                        buffer.append("B");
                        continue;
                    }
                    if ((b & 0x10) != 0) {
                        buffer.append("T");
                        continue;
                    }
                    buffer.append(Integer.toHexString(b & 0xF));
                }
                System.out.println(buffer);
            }
            buffer = new StringBuilder();
            for (int k = 0; k < this.lenX; ++k) {
                buffer.append("-");
            }
            System.out.println(buffer);
        }
    }

    public static class Cell {
        private byte value;
        private final BlockPos.Mutable pos = new BlockPos.Mutable();

        public Cell setValue(byte value) {
            this.value = value;
            return this;
        }

        public byte getValue() {
            return this.value;
        }

        public BlockPos.Mutable getPos() {
            return this.pos;
        }
    }

    @FunctionalInterface
    public static interface FilterOp {
        public byte getOp(byte var1);
    }

    @FunctionalInterface
    public static interface BlitOp {
        public byte getOp(byte var1, byte var2);
    }
}

