/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.GroundFinder;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeDatabase {
    public static final Entry BAD_ENTRY = new Entry(){

        @Override
        public void setChanceSelector(BiomePropertySelectors.ChanceSelector chanceSelector) {
        }

        @Override
        public void setDensitySelector(BiomePropertySelectors.DensitySelector densitySelector) {
        }

        @Override
        public void setSpeciesSelector(BiomePropertySelectors.SpeciesSelector speciesSelector) {
        }

        @Override
        public void setSubterranean(boolean is) {
        }
    };
    private final Map<ResourceLocation, Entry> entries = new HashMap<ResourceLocation, Entry>();

    public Entry getEntry(@Nullable Biome biome) {
        if (biome == null) {
            return BAD_ENTRY;
        }
        return this.entries.computeIfAbsent(biome.getRegistryName(), k -> new Entry(this, biome));
    }

    public Entry getEntry(ResourceLocation biomeResLoc) {
        return this.getEntry((Biome)ForgeRegistries.BIOMES.getValue(biomeResLoc));
    }

    public Collection<Entry> getAllEntries() {
        return this.entries.values();
    }

    public void reset() {
        this.entries.values().forEach(Entry::reset);
    }

    public void clear() {
        this.entries.clear();
    }

    public boolean isValid() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            Entry entry = this.getEntry(biome);
            ResourceLocation biomeRegistryName = entry.getBiome().getRegistryName();
            if (biomeRegistryName == null || biomeRegistryName.equals((Object)biome.getRegistryName())) continue;
            return false;
        }
        return true;
    }

    public boolean isPopulated() {
        return this.entries.size() > 0;
    }

    public BiomePropertySelectors.SpeciesSelector getSpecies(Biome biome) {
        return this.getEntry(biome).speciesSelector;
    }

    public BiomePropertySelectors.ChanceSelector getChance(Biome biome) {
        return this.getEntry(biome).chanceSelector;
    }

    public BiomePropertySelectors.DensitySelector getDensitySelector(Biome biome) {
        return this.getEntry(biome).densitySelector;
    }

    public float getForestness(Biome biome) {
        return this.getEntry(biome).getForestness();
    }

    public Function<Integer, Integer> getMultipass(Biome biome) {
        return this.getEntry(biome).getMultipass();
    }

    public BiomeDatabase setSpeciesSelector(Biome biome, @Nullable BiomePropertySelectors.SpeciesSelector selector, Operation op) {
        if (selector == null) {
            return this;
        }
        Entry entry = this.getEntry(biome);
        BiomePropertySelectors.SpeciesSelector existing = entry.getSpeciesSelector();
        switch (op) {
            case REPLACE: {
                entry.setSpeciesSelector(selector);
                break;
            }
            case SPLICE_BEFORE: {
                entry.setSpeciesSelector((pos, dirt, rnd) -> {
                    BiomePropertySelectors.SpeciesSelection ss = selector.getSpecies(pos, dirt, rnd);
                    return ss.isHandled() ? ss : existing.getSpecies(pos, dirt, rnd);
                });
                break;
            }
            case SPLICE_AFTER: {
                entry.setSpeciesSelector((pos, dirt, rnd) -> {
                    BiomePropertySelectors.SpeciesSelection ss = existing.getSpecies(pos, dirt, rnd);
                    return ss.isHandled() ? ss : selector.getSpecies(pos, dirt, rnd);
                });
            }
        }
        return this;
    }

    public BiomeDatabase setChanceSelector(Biome biome, @Nullable BiomePropertySelectors.ChanceSelector selector, Operation op) {
        if (selector == null) {
            return this;
        }
        Entry entry = this.getEntry(biome);
        BiomePropertySelectors.ChanceSelector existing = entry.getChanceSelector();
        switch (op) {
            case REPLACE: {
                entry.setChanceSelector(selector);
                break;
            }
            case SPLICE_BEFORE: {
                entry.setChanceSelector((rnd, spc, rad) -> {
                    BiomePropertySelectors.Chance c = selector.getChance(rnd, spc, rad);
                    return c != BiomePropertySelectors.Chance.UNHANDLED ? c : existing.getChance(rnd, spc, rad);
                });
                break;
            }
            case SPLICE_AFTER: {
                entry.setChanceSelector((rnd, spc, rad) -> {
                    BiomePropertySelectors.Chance c = existing.getChance(rnd, spc, rad);
                    return c != BiomePropertySelectors.Chance.UNHANDLED ? c : selector.getChance(rnd, spc, rad);
                });
            }
        }
        return this;
    }

    public BiomeDatabase setDensitySelector(Biome biome, @Nullable BiomePropertySelectors.DensitySelector selector, Operation op) {
        if (selector == null) {
            return this;
        }
        Entry entry = this.getEntry(biome);
        BiomePropertySelectors.DensitySelector existing = entry.getDensitySelector();
        switch (op) {
            case REPLACE: {
                entry.setDensitySelector(selector);
                break;
            }
            case SPLICE_BEFORE: {
                entry.setDensitySelector((rnd, nd) -> {
                    double d = selector.getDensity(rnd, nd);
                    return d >= 0.0 ? d : existing.getDensity(rnd, nd);
                });
                break;
            }
            case SPLICE_AFTER: {
                entry.setDensitySelector((rnd, nd) -> {
                    double d = existing.getDensity(rnd, nd);
                    return d >= 0.0 ? d : selector.getDensity(rnd, nd);
                });
            }
        }
        return this;
    }

    public BiomeDatabase setIsSubterranean(Biome biome, boolean is) {
        this.getEntry(biome).setSubterranean(is);
        return this;
    }

    public BiomeDatabase setForestness(Biome biome, float forestness) {
        this.getEntry(biome).setForestness((float)Math.max((double)forestness, (Double)DTConfigs.SEED_MIN_FORESTNESS.get()));
        return this;
    }

    public BiomeDatabase setMultipass(Biome biome, Function<Integer, Integer> multipass) {
        this.getEntry(biome).setMultipass(multipass);
        return this;
    }

    public static BiomeDatabase copyOf(BiomeDatabase database) {
        BiomeDatabase databaseCopy = new BiomeDatabase();
        databaseCopy.entries.putAll(database.entries);
        return databaseCopy;
    }

    public static enum Operation {
        REPLACE,
        SPLICE_BEFORE,
        SPLICE_AFTER;

    }

    public static class Entry {
        private final BiomeDatabase database;
        private final Biome biome;
        private BiomePropertySelectors.ChanceSelector chanceSelector = (rnd, spc, rad) -> BiomePropertySelectors.Chance.UNHANDLED;
        private BiomePropertySelectors.DensitySelector densitySelector = (rnd, nd) -> -1.0;
        private BiomePropertySelectors.SpeciesSelector speciesSelector = (pos, dirt, rnd) -> new BiomePropertySelectors.SpeciesSelection();
        private final BiomePropertySelectors.FeatureCancellations featureCancellations = new BiomePropertySelectors.FeatureCancellations();
        private boolean blacklisted = false;
        private boolean subterranean = false;
        private float forestness = 0.0f;
        private static final Function<Integer, Integer> defaultMultipass = pass -> pass == 0 ? 0 : -1;
        private Function<Integer, Integer> multipass = defaultMultipass;
        private GroundFinder groundFinder = GroundFinder.OVERWORLD;

        public Entry() {
            this.database = null;
            this.biome = (Biome)ForgeRegistries.BIOMES.getValue(Biomes.field_76771_b.getRegistryName());
        }

        public Entry(BiomeDatabase database, Biome biome) {
            this.database = database;
            this.biome = biome;
        }

        public BiomeDatabase getDatabase() {
            return this.database;
        }

        public Biome getBiome() {
            return this.biome;
        }

        public BiomePropertySelectors.ChanceSelector getChanceSelector() {
            return this.chanceSelector;
        }

        public BiomePropertySelectors.DensitySelector getDensitySelector() {
            return this.densitySelector;
        }

        public BiomePropertySelectors.SpeciesSelector getSpeciesSelector() {
            return this.speciesSelector;
        }

        public void setChanceSelector(BiomePropertySelectors.ChanceSelector chanceSelector) {
            this.chanceSelector = chanceSelector;
        }

        public void setDensitySelector(BiomePropertySelectors.DensitySelector densitySelector) {
            this.densitySelector = densitySelector;
        }

        public void setSpeciesSelector(BiomePropertySelectors.SpeciesSelector speciesSelector) {
            this.speciesSelector = speciesSelector;
        }

        public BiomePropertySelectors.FeatureCancellations getFeatureCancellations() {
            return this.featureCancellations;
        }

        public void setBlacklisted(boolean blacklisted) {
            this.blacklisted = blacklisted;
        }

        public void setSubterranean(boolean is) {
            this.subterranean = is;
            this.groundFinder = is ? GroundFinder.SUBTERRANEAN : GroundFinder.OVERWORLD;
        }

        public boolean isBlacklisted() {
            return this.blacklisted;
        }

        public boolean isSubterranean() {
            return this.subterranean;
        }

        public void setForestness(float forestness) {
            this.forestness = forestness;
        }

        public float getForestness() {
            return this.forestness;
        }

        public void setMultipass(Function<Integer, Integer> multipass) {
            this.multipass = multipass;
        }

        public Function<Integer, Integer> getMultipass() {
            return this.multipass;
        }

        public GroundFinder getGroundFinder() {
            return this.groundFinder;
        }

        public void setGroundFinder(GroundFinder groundFinder) {
            this.groundFinder = groundFinder;
        }

        public void enableDefaultMultipass() {
            this.multipass = pass -> {
                switch (pass) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 5;
                    }
                    case 2: {
                        return 3;
                    }
                }
                return -1;
            };
        }

        public void setCustomMultipass(JsonObject json) {
            Map<Integer, Integer> passMap = this.deserialiseCustomMultipass(json);
            this.multipass = pass -> passMap.getOrDefault(pass, -1);
        }

        private Map<Integer, Integer> deserialiseCustomMultipass(JsonObject json) {
            HashMap passMap = Maps.newHashMap();
            for (Map.Entry passEntry : json.entrySet()) {
                try {
                    int pass = Integer.parseInt((String)passEntry.getKey());
                    int radius = JsonDeserialisers.INTEGER.deserialise(passEntry.getValue()).orElse(-1);
                    if (radius == -1) break;
                    passMap.put(pass, radius);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return passMap;
        }

        public void reset() {
            this.speciesSelector = (pos, dirt, rnd) -> new BiomePropertySelectors.SpeciesSelection();
            this.densitySelector = (rnd, nd) -> -1.0;
            this.chanceSelector = (rnd, spc, rad) -> BiomePropertySelectors.Chance.UNHANDLED;
            this.forestness = 0.0f;
            this.blacklisted = false;
            this.subterranean = false;
            this.multipass = defaultMultipass;
        }
    }
}

