/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.RadiusCoordinator;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabases;
import com.ferreusveritas.dynamictrees.worldgen.TreeGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.PerlinNoiseGenerator;

public class BiomeRadiusCoordinator
implements RadiusCoordinator {
    public PerlinNoiseGenerator noiseGenerator = new PerlinNoiseGenerator(new SharedSeedRandom(96L), new ArrayList<Integer>(Collections.singletonList(1)));
    protected final TreeGenerator treeGenerator;
    protected final IWorld world;
    protected final ResourceLocation dimRegName;
    protected int pass;
    protected Function<Integer, Integer> chunkMultipass;

    public BiomeRadiusCoordinator(TreeGenerator treeGenerator, ResourceLocation dimRegName, IWorld world) {
        this.world = world;
        this.dimRegName = dimRegName;
        this.treeGenerator = treeGenerator;
    }

    @Override
    public int getRadiusAtCoords(int x, int z) {
        int rad = this.chunkMultipass.apply(this.pass);
        if (rad >= 2 && rad <= 8) {
            return rad;
        }
        double scale = 128.0;
        Biome biome = this.world.func_225604_a_(x + 8 >> 2, 0, z + 8 >> 2);
        double noiseDensity = (this.noiseGenerator.func_215464_a((double)x / 128.0, (double)z / 128.0, false) + 1.0) / 2.0;
        double density = BiomeDatabases.getDimensionalOrDefault(this.dimRegName).getDensitySelector(biome).getDensity(this.world.func_201674_k(), noiseDensity);
        double size = (1.0 - density) * 9.0;
        int kindaRandom = (x * 674365771 ^ z * 254326997) >> 4;
        int shakelow = (kindaRandom & 3) % 3;
        int shakehigh = (kindaRandom & 0xC) % 3;
        return MathHelper.func_76125_a((int)((int)size), (int)(2 + shakelow), (int)(8 - shakehigh));
    }

    @Override
    public boolean runPass(int chunkX, int chunkZ, int pass) {
        this.pass = pass;
        if (pass == 0) {
            Biome biome = this.world.func_225604_a_((chunkX << 4) + 8 >> 2, 0, (chunkZ << 4) + 8 >> 2);
            this.chunkMultipass = BiomeDatabases.getDimensionalOrDefault(this.dimRegName).getMultipass(biome);
        }
        return this.chunkMultipass.apply(pass) >= 0;
    }
}

