/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.GroundFinder;
import com.ferreusveritas.dynamictrees.blocks.DynamicSaplingBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;

public class SubterraneanGroundFinder
implements GroundFinder {
    private static final List<BlockPos> NO_LAYERS = Collections.singletonList(BlockPos.field_177992_a);

    protected boolean isReplaceable(IWorld world, BlockPos pos) {
        return (world.func_175623_d(pos) || !world.func_180495_p(pos).func_185904_a().func_76230_c() || world.func_180495_p(pos).func_177230_c() instanceof DynamicSaplingBlock) && !world.func_180495_p(pos).func_185904_a().func_76224_d();
    }

    protected boolean inRange(BlockPos pos, int minY, int maxY) {
        return pos.func_177956_o() >= minY && pos.func_177956_o() <= maxY;
    }

    protected int getTopY(IWorld world, BlockPos pos) {
        return world.func_217349_x(pos).func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177958_n(), pos.func_177952_p());
    }

    protected ArrayList<Integer> findSubterraneanLayerHeights(IWorld world, BlockPos start) {
        int maxY = this.getTopY(world, start);
        BlockPos.Mutable pos = new BlockPos.Mutable(start.func_177958_n(), 0, start.func_177952_p());
        ArrayList<Integer> layers = new ArrayList<Integer>();
        while (this.inRange((BlockPos)pos, 0, maxY)) {
            while (!this.isReplaceable(world, (BlockPos)pos) && this.inRange((BlockPos)pos, 0, maxY)) {
                pos.func_189534_c(Direction.UP, 4);
            }
            while (this.isReplaceable(world, (BlockPos)pos) && this.inRange((BlockPos)pos, 0, maxY)) {
                pos.func_189536_c(Direction.DOWN);
            }
            if (this.isReplaceable(world, pos.func_177981_b(6))) {
                layers.add(pos.func_177956_o());
            }
            pos.func_189534_c(Direction.UP, 8);
            while (this.isReplaceable(world, (BlockPos)pos) && this.inRange((BlockPos)pos, 0, maxY)) {
                pos.func_189534_c(Direction.UP, 4);
            }
        }
        if (layers.size() > 0) {
            layers.remove(layers.size() - 1);
        }
        return layers;
    }

    @Override
    public List<BlockPos> findGround(IWorld world, BlockPos start) {
        ArrayList<Integer> layers = this.findSubterraneanLayerHeights(world, start);
        if (layers.size() < 1) {
            return NO_LAYERS;
        }
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        for (int y : layers) {
            positions.add(new BlockPos(start.func_177958_n(), y, start.func_177952_p()));
        }
        return positions;
    }
}

