/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.poissondisc.PoissonDisc;
import com.ferreusveritas.dynamictrees.systems.poissondisc.UniversalPoissonDiscProvider;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.RandomXOR;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabase;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class TreeGenerator {
    private static Block[] concreteBlocks;
    protected static TreeGenerator INSTANCE;
    protected final UniversalPoissonDiscProvider circleProvider;
    protected final RandomXOR random = new RandomXOR();

    public static void initialise() {
        new TreeGenerator();
    }

    public static void setup() {
        concreteBlocks = (Block[])Arrays.stream(DyeColor.values()).map(color -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(color.func_176762_d() + "_concrete"))).toArray(Block[]::new);
    }

    public static TreeGenerator getTreeGenerator() {
        return INSTANCE;
    }

    public TreeGenerator() {
        INSTANCE = this;
        this.circleProvider = new UniversalPoissonDiscProvider();
    }

    public UniversalPoissonDiscProvider getCircleProvider() {
        return this.circleProvider;
    }

    public void makeConcreteCircle(IWorld world, PoissonDisc circle, int h, GeneratorResult resultType, SafeChunkBounds safeBounds) {
        this.makeConcreteCircle(world, circle, h, resultType, safeBounds, 0);
    }

    private BlockState getConcreteByColor(DyeColor color) {
        return ((Block)Objects.requireNonNull(ForgeRegistries.BLOCKS.getValue(new ResourceLocation(color + "_concrete")))).func_176223_P();
    }

    public void makeConcreteCircle(IWorld world, PoissonDisc circle, int h, GeneratorResult resultType, SafeChunkBounds safeBounds, int flags) {
        for (int ix = -circle.radius; ix <= circle.radius; ++ix) {
            for (int iz = -circle.radius; iz <= circle.radius; ++iz) {
                if (!circle.isEdge(circle.x + ix, circle.z + iz)) continue;
                safeBounds.setBlockState(world, new BlockPos(circle.x + ix, h, circle.z + iz), concreteBlocks[(circle.x ^ circle.z) & 0xF].func_176223_P(), flags, true);
            }
        }
        if (resultType != GeneratorResult.GENERATED) {
            BlockPos pos = new BlockPos(circle.x, h, circle.z);
            BlockState coloredBlock = resultType.getColoredBlock();
            safeBounds.setBlockState(world, pos, coloredBlock, true);
            safeBounds.setBlockState(world, pos.func_177984_a(), coloredBlock, true);
        }
    }

    public void makeTrees(WorldContext worldContext, BiomeDatabase biomeDataBase, PoissonDisc circle, SafeChunkBounds safeBounds) {
        BlockPos pos = new BlockPos(circle.x, 0, circle.z);
        BiomeDatabase.Entry entry = biomeDataBase.getEntry(worldContext.access().func_226691_t_(pos));
        for (BlockPos groundPos : entry.getGroundFinder().findGround(worldContext.access(), pos)) {
            this.makeTree(worldContext, entry, circle, groundPos, safeBounds);
        }
    }

    public GeneratorResult makeTree(WorldContext worldContext, BiomeDatabase.Entry biomeEntry, PoissonDisc circle, BlockPos groundPos, SafeChunkBounds safeBounds) {
        Biome biome = worldContext.access().func_226691_t_(groundPos);
        if (biomeEntry.isBlacklisted()) {
            return GeneratorResult.UNHANDLED_BIOME;
        }
        if (groundPos == BlockPos.field_177992_a) {
            return GeneratorResult.NO_GROUND;
        }
        this.random.setXOR(groundPos);
        BlockState dirtState = worldContext.access().func_180495_p(groundPos);
        GeneratorResult result = GeneratorResult.GENERATED;
        BiomePropertySelectors.SpeciesSelector speciesSelector = biomeEntry.getSpeciesSelector();
        BiomePropertySelectors.SpeciesSelection speciesSelection = speciesSelector.getSpecies(groundPos, dirtState, this.random);
        if (speciesSelection.isHandled()) {
            Species species = speciesSelection.getSpecies();
            if (species.isValid()) {
                if (species.isAcceptableSoilForWorldgen(worldContext.access(), groundPos, dirtState)) {
                    if (biomeEntry.getChanceSelector().getChance(this.random, species, circle.radius) == BiomePropertySelectors.Chance.OK) {
                        if (!species.generate(worldContext, groundPos, biome, this.random, circle.radius, safeBounds)) {
                            result = GeneratorResult.FAIL_GENERATION;
                        }
                    } else {
                        result = GeneratorResult.FAIL_CHANCE;
                    }
                } else {
                    result = GeneratorResult.FAIL_SOIL;
                }
            } else {
                result = GeneratorResult.NO_TREE;
            }
        } else {
            result = GeneratorResult.UNHANDLED_BIOME;
        }
        if (((Boolean)DTConfigs.WORLD_GEN_DEBUG.get()).booleanValue()) {
            this.makeConcreteCircle(worldContext.access(), circle, groundPos.func_177956_o(), result, safeBounds);
        }
        return result;
    }

    public static enum GeneratorResult {
        GENERATED(DyeColor.WHITE),
        NO_TREE(DyeColor.BLACK),
        UNHANDLED_BIOME(DyeColor.YELLOW),
        FAIL_SOIL(DyeColor.BROWN),
        FAIL_CHANCE(DyeColor.BLUE),
        FAIL_GENERATION(DyeColor.RED),
        NO_GROUND(DyeColor.PURPLE);

        private final DyeColor color;

        private GeneratorResult(DyeColor color) {
            this.color = color;
        }

        public DyeColor getColor() {
            return this.color;
        }

        public BlockState getColoredBlock() {
            return concreteBlocks[this.color.func_196059_a()].func_176223_P();
        }
    }
}

