/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.cancellers;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;

public class MushroomFeatureCanceller<T extends IFeatureConfig>
extends FeatureCanceller {
    private final Class<T> mushroomFeatureConfigClass;

    public MushroomFeatureCanceller(ResourceLocation registryName, Class<T> mushroomFeatureConfigClass) {
        super(registryName);
        this.mushroomFeatureConfigClass = mushroomFeatureConfigClass;
    }

    @Override
    public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.FeatureCancellations featureCancellations) {
        if (!(configuredFeature.field_222738_b instanceof DecoratedFeatureConfig)) {
            return false;
        }
        ConfiguredFeature nextConfiguredFeature = (ConfiguredFeature)((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a.get();
        ResourceLocation featureRegistryName = nextConfiguredFeature.field_222737_a.getRegistryName();
        if (featureRegistryName == null) {
            return false;
        }
        if (!(nextConfiguredFeature.field_222738_b instanceof TwoFeatureChoiceConfig)) {
            return false;
        }
        return this.getConfigs((TwoFeatureChoiceConfig)nextConfiguredFeature.field_222738_b).stream().anyMatch(this.mushroomFeatureConfigClass::isInstance) && featureCancellations.shouldCancelNamespace(featureRegistryName.func_110624_b());
    }

    private List<IFeatureConfig> getConfigs(TwoFeatureChoiceConfig twoFeatureConfig) {
        return Arrays.asList(((ConfiguredFeature)twoFeatureConfig.field_227285_a_.get()).field_222738_b, ((ConfiguredFeature)twoFeatureConfig.field_227286_b_.get()).field_222738_b);
    }
}

