/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.deserialisation;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.deserialisation.DeserialisationException;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.result.JsonResult;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.worldgen.deserialisation.JsonBiomeDatabaseDeserialiser;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class SpeciesSelectorDeserialiser
implements JsonBiomeDatabaseDeserialiser<BiomePropertySelectors.SpeciesSelector> {
    @Override
    public Result<BiomePropertySelectors.SpeciesSelector, JsonElement> deserialise(JsonElement input) {
        return JsonResult.forInput(input).mapIfType(Species.class, this::readStatic).elseMapIfType(String.class, this::readStatic).elseMapIfType(JsonObject.class, this::readSelector).elseTypeError();
    }

    private BiomePropertySelectors.SpeciesSelector readStatic(Species species) {
        return new BiomePropertySelectors.StaticSpeciesSelector(new BiomePropertySelectors.SpeciesSelection(species));
    }

    private BiomePropertySelectors.SpeciesSelector readStatic(String string) throws DeserialisationException {
        if (this.isDefault(string)) {
            return new BiomePropertySelectors.StaticSpeciesSelector();
        }
        throw new DeserialisationException("\"" + string + "\" is not a supported parameter for a static species selector.");
    }

    private BiomePropertySelectors.SpeciesSelector readSelector(JsonObject object, Consumer<String> warningConsumer) throws DeserialisationException {
        return (BiomePropertySelectors.SpeciesSelector)JsonResult.forInput((JsonElement)object).mapIfContains("static", JsonElement.class, input -> (BiomePropertySelectors.SpeciesSelector)JsonResult.forInput(input).mapIfType(Species.class, this::readStatic).elseMapIfType(String.class, this::readStatic).elseTypeError().forEachWarning(warningConsumer).orElseThrow()).elseMapIfContains("random", JsonElement.class, input -> this.getRandomSpeciesSelector((JsonElement)input, warningConsumer)).forEachWarning(warningConsumer).orElseThrow();
    }

    @Nullable
    private BiomePropertySelectors.SpeciesSelector getRandomSpeciesSelector(JsonElement input, Consumer<String> warningConsumer) throws DeserialisationException {
        return (BiomePropertySelectors.SpeciesSelector)JsonDeserialisers.JSON_OBJECT.deserialise(input).map(object -> {
            BiomePropertySelectors.RandomSpeciesSelector randomSelector = new BiomePropertySelectors.RandomSpeciesSelector();
            for (Map.Entry entry : object.entrySet()) {
                String speciesName = (String)entry.getKey();
                JsonDeserialisers.INTEGER.deserialise(entry.getValue()).ifSuccessOrElseThrow(weight -> {
                    if (weight > 0) {
                        if (this.isDefault(speciesName)) {
                            randomSelector.add((int)weight);
                        } else {
                            TreeRegistry.findSpeciesSloppy(speciesName).ifValid(species -> randomSelector.add((Species)species, (int)weight));
                        }
                    }
                }, warningConsumer);
            }
            if (randomSelector.getSize() < 1) {
                throw new DeserialisationException("No species were selected in random selector '" + input + "'.");
            }
            return randomSelector;
        }).forEachWarning(warningConsumer).orElseThrow();
    }
}

