/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.structure;

import com.ferreusveritas.dynamictrees.worldgen.structure.PatternModifier;
import com.ferreusveritas.dynamictrees.worldgen.structure.VillageTreeReplacement;
import com.mojang.datafixers.util.Pair;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;

public class RegularPatternModifier
implements PatternModifier {
    private final JigsawPattern pattern;

    private RegularPatternModifier(JigsawPattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public PatternModifier replaceTemplate(int index, JigsawPiece newTemplate) {
        Pair removedRawTemplate = (Pair)this.pattern.field_214952_d.remove(index);
        this.pattern.field_214952_d.add(index, Pair.of((Object)newTemplate, (Object)removedRawTemplate.getSecond()));
        this.pattern.field_214953_e.replaceAll(template -> {
            if (template == removedRawTemplate.getFirst()) {
                return newTemplate;
            }
            return template;
        });
        return this;
    }

    @Override
    public PatternModifier removeTemplate(int index) {
        Pair removedRawTemplate = (Pair)this.pattern.field_214952_d.remove(index);
        this.pattern.field_214953_e.removeIf(template -> template == removedRawTemplate.getFirst());
        return this;
    }

    @Override
    public void removeAllTemplates() {
        this.pattern.field_214952_d.clear();
        this.pattern.field_214953_e.clear();
    }

    public static PatternModifier village(String type, String patternGroup) {
        ResourceLocation patternName = new ResourceLocation("village/" + type + "/" + patternGroup);
        JigsawPattern pattern = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(patternName);
        if (pattern == null) {
            VillageTreeReplacement.LOGGER.error("Could not find JigsawPattern with name {}.", (Object)patternName);
            return PatternModifier.NULL;
        }
        return new RegularPatternModifier(pattern);
    }
}

