/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.structure;

import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.JigsawBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.JigsawTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawOrientation;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class TreeJigsawPiece
extends JigsawPiece {
    public static final Codec<TreeJigsawPiece> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Species.CODEC.fieldOf("species").forGetter(TreeJigsawPiece::getSpecies), (App)BlockPos.field_239578_a_.fieldOf("offset").forGetter(TreeJigsawPiece::getOffset), (App)TreeJigsawPiece.func_236848_d_()).apply((Applicative)instance, TreeJigsawPiece::new));
    public static final IJigsawDeserializer<TreeJigsawPiece> TREE_POOL_ELEMENT = IJigsawDeserializer.func_236851_a_((String)"tree_pool_element", CODEC);
    private final Species species;
    private final BlockPos offset;
    private final CompoundNBT defaultJigsawNBT;

    public TreeJigsawPiece(Species species, JigsawPattern.PlacementBehaviour projection) {
        this(species, BlockPos.field_177992_a, projection);
    }

    public TreeJigsawPiece(Species species, BlockPos offset, JigsawPattern.PlacementBehaviour projection) {
        super(projection);
        this.species = species;
        this.offset = offset;
        this.defaultJigsawNBT = this.fillDefaultJigsawNBT();
    }

    private CompoundNBT fillDefaultJigsawNBT() {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("name", "minecraft:bottom");
        compoundnbt.func_74778_a("final_state", "minecraft:air");
        compoundnbt.func_74778_a("pool", "minecraft:empty");
        compoundnbt.func_74778_a("target", "minecraft:empty");
        compoundnbt.func_74778_a("joint", JigsawTileEntity.OrientationType.ROLLABLE.func_176610_l());
        return compoundnbt;
    }

    public List<Template.BlockInfo> func_214849_a(TemplateManager templateManager, BlockPos pos, Rotation rotation, Random random) {
        ArrayList list = Lists.newArrayList();
        list.add(new Template.BlockInfo(pos, (BlockState)Blocks.field_226904_lY_.func_176223_P().func_206870_a((Property)JigsawBlock.field_235506_a_, (Comparable)JigsawOrientation.func_239641_a_((Direction)Direction.DOWN, (Direction)Direction.SOUTH)), this.defaultJigsawNBT));
        return list;
    }

    public MutableBoundingBox func_214852_a(TemplateManager templateManager, BlockPos pos, Rotation rotation) {
        return new MutableBoundingBox(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean func_230378_a_(TemplateManager templateManager, ISeedReader world, StructureManager structureManager, ChunkGenerator generator, BlockPos pos, BlockPos p_230378_6_, Rotation rotation, MutableBoundingBox box, Random random, boolean keepJigsaws) {
        Seed seed = this.species.getSeed().orElse(null);
        if (seed == null) {
            return false;
        }
        ItemStack seedStack = new ItemStack((IItemProvider)seed);
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("ForcePlant", true);
        tag.func_74768_a("Code", random.nextInt(7) + 2);
        tag.func_74768_a("Lifespan", 0);
        seedStack.func_77982_d(tag);
        int posX = pos.func_177958_n() + this.getOffsetX(rotation);
        int posY = pos.func_177956_o() + this.getOffsetY(rotation);
        int posZ = pos.func_177952_p() + this.getOffsetZ(rotation);
        world.func_217376_c((Entity)new ItemEntity((World)world.func_201672_e(), (double)posX, (double)posY, (double)posZ, seedStack));
        return true;
    }

    private int getOffsetX(Rotation rotation) {
        return this.offset.func_177958_n() * (rotation.func_235574_a_().func_235529_a_(Direction.Axis.X) ? -1 : 1);
    }

    private int getOffsetY(Rotation rotation) {
        return this.offset.func_177956_o();
    }

    private int getOffsetZ(Rotation rotation) {
        return this.offset.func_177952_p() * (rotation.func_235574_a_().func_235529_a_(Direction.Axis.Z) ? -1 : 1);
    }

    public IJigsawDeserializer<?> func_214853_a() {
        return TREE_POOL_ELEMENT;
    }

    public Species getSpecies() {
        return this.species;
    }

    private BlockPos getOffset() {
        return this.offset;
    }
}

