/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.colour;

import codechicken.lib.colour.ColourRGBA;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;

public enum EnumColour implements IStringSerializable
{
    WHITE("white", "forge:dyes/white", "forge:wool/white", "item.minecraft.firework_star.white", 0xFFFFFF),
    ORANGE("orange", "forge:dyes/orange", "forge:wool/orange", "item.minecraft.firework_star.orange", 12608256),
    MAGENTA("magenta", "forge:dyes/magenta", "forge:wool/magenta", "item.minecraft.firework_star.magenta", 11868853),
    LIGHT_BLUE("light_blue", "forge:dyes/light_blue", "forge:wool/light_blue", "item.minecraft.firework_star.light_blue", 7308529),
    YELLOW("yellow", "forge:dyes/yellow", "forge:wool/yellow", "item.minecraft.firework_star.yellow", 0xBFBF00),
    LIME("lime", "forge:dyes/lime", "forge:wool/lime", "item.minecraft.firework_star.lime", 7074048),
    PINK("pink", "forge:dyes/pink", "forge:wool/pink", "item.minecraft.firework_star.pink", 15812213),
    GRAY("gray", "forge:dyes/gray", "forge:wool/gray", "item.minecraft.firework_star.gray", 0x535353),
    LIGHT_GRAY("light_gray", "forge:dyes/light_gray", "forge:wool/light_gray", "item.minecraft.firework_star.light_gray", 0x939393),
    CYAN("cyan", "forge:dyes/cyan", "forge:wool/cyan", "item.minecraft.firework_star.cyan", 34695),
    PURPLE("purple", "forge:dyes/purple", "forge:wool/purple", "item.minecraft.firework_star.purple", 6160576),
    BLUE("blue", "forge:dyes/blue", "forge:wool/blue", "item.minecraft.firework_star.blue", 1250240),
    BROWN("brown", "forge:dyes/brown", "forge:wool/brown", "item.minecraft.firework_star.brown", 5187328),
    GREEN("green", "forge:dyes/green", "forge:wool/green", "item.minecraft.firework_star.green", 558848),
    RED("red", "forge:dyes/red", "forge:wool/red", "item.minecraft.firework_star.red", 10620678),
    BLACK("black", "forge:dyes/black", "forge:wool/black", "item.minecraft.firework_star.black", 0x1F1F1F);

    private final String name;
    private final ResourceLocation dyeTagName;
    private final ResourceLocation woolTagName;
    private final String unlocalizedName;
    private final int rgb;
    private static final ImmutableTable<EnumColour, EnumColour, EnumColour> mixMap;
    private static final Map<String, EnumColour> nameLookup;
    private static final Map<ResourceLocation, EnumColour> dyeTagLookup;
    private static final Map<ResourceLocation, EnumColour> woolTagLookup;

    private EnumColour(String name, String dyeTagName, String woolTagName, String unlocalizedName, int rgb) {
        this.name = name;
        this.dyeTagName = new ResourceLocation(dyeTagName);
        this.woolTagName = new ResourceLocation(woolTagName);
        this.unlocalizedName = unlocalizedName;
        this.rgb = rgb;
    }

    public String func_176610_l() {
        return this.name;
    }

    public ResourceLocation getDyeTagName() {
        return this.dyeTagName;
    }

    public ResourceLocation getWoolTagName() {
        return this.woolTagName;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    public int getWoolMeta() {
        return this.ordinal();
    }

    public int getDyeMeta() {
        return 15 - this.ordinal();
    }

    public int rgba() {
        return this.rgba(255);
    }

    public int rgba(int alpha) {
        return this.rgb << 8 | alpha & 0xFF;
    }

    public int argb() {
        return this.argb(255);
    }

    public int argb(int alpha) {
        return (alpha & 0xFF) << 24 | this.rgb;
    }

    public int rgb() {
        return this.rgb;
    }

    public float rF() {
        return (float)(this.rgb >> 16 & 0xFF) / 255.0f;
    }

    public float gF() {
        return (float)(this.rgb >> 8 & 0xFF) / 255.0f;
    }

    public float bF() {
        return (float)(this.rgb & 0xFF) / 255.0f;
    }

    public ColourRGBA getColour() {
        return this.getColour(255);
    }

    public ColourRGBA getColour(int alpha) {
        return new ColourRGBA(this.rgba(alpha));
    }

    public EnumColour mix(EnumColour b) {
        return EnumColour.mix(this, b);
    }

    public static EnumColour mix(EnumColour a, EnumColour b) {
        if (a == b) {
            return a;
        }
        return (EnumColour)((Object)mixMap.get((Object)a, (Object)b));
    }

    public static EnumColour fromWoolMeta(int id) {
        return EnumColour.values()[id];
    }

    public static EnumColour fromDyeMeta(int id) {
        return EnumColour.values()[15 - id];
    }

    public static EnumColour fromDyeTag(ResourceLocation tag) {
        return dyeTagLookup.get(tag);
    }

    public static EnumColour fromWoolTag(ResourceLocation tag) {
        return woolTagLookup.get(tag);
    }

    public static EnumColour fromDyeStack(ItemStack stack) {
        return stack.func_77973_b().getTags().stream().map(dyeTagLookup::get).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static EnumColour fromWoolStack(ItemStack stack) {
        return stack.func_77973_b().getTags().stream().map(woolTagLookup::get).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static EnumColour fromName(String name) {
        return nameLookup.get(name);
    }

    static {
        nameLookup = Arrays.stream(EnumColour.values()).collect(Collectors.toMap(e -> e.name, Function.identity()));
        dyeTagLookup = Arrays.stream(EnumColour.values()).collect(Collectors.toMap(e -> e.dyeTagName, Function.identity()));
        woolTagLookup = Arrays.stream(EnumColour.values()).collect(Collectors.toMap(e -> e.woolTagName, Function.identity()));
        HashBasedTable tmp = HashBasedTable.create();
        tmp.put((Object)YELLOW, (Object)RED, (Object)ORANGE);
        tmp.put((Object)PINK, (Object)PURPLE, (Object)MAGENTA);
        tmp.put((Object)WHITE, (Object)BLUE, (Object)LIGHT_BLUE);
        tmp.put((Object)WHITE, (Object)GREEN, (Object)LIME);
        tmp.put((Object)WHITE, (Object)RED, (Object)PINK);
        tmp.put((Object)WHITE, (Object)BLACK, (Object)GRAY);
        tmp.put((Object)WHITE, (Object)GRAY, (Object)LIGHT_GRAY);
        tmp.put((Object)BLUE, (Object)GREEN, (Object)CYAN);
        tmp.put((Object)BLUE, (Object)RED, (Object)PURPLE);
        tmp.put((Object)ORANGE, (Object)RED, (Object)BROWN);
        tmp.put((Object)YELLOW, (Object)BLUE, (Object)GREEN);
        ImmutableTable.Builder builder = ImmutableTable.builder();
        tmp.cellSet().forEach(e -> {
            builder.put(e.getRowKey(), e.getColumnKey(), e.getValue());
            builder.put(e.getColumnKey(), e.getRowKey(), e.getValue());
        });
        mixMap = builder.build();
    }
}

