/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.TransformingVertexBuilder;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class RenderUtils {
    private static final Vector3[] vectors = new Vector3[8];

    public static RenderType getFluidRenderType() {
        return RenderType.func_228632_a_((String)"ccl:fluid_render", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(RenderType.field_228522_n_).func_228726_a_(RenderType.field_228515_g_).func_228725_a_(new RenderState.TexturingState("disable_lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    }

    public static void renderFluidCuboid(CCRenderState ccrs, Matrix4 mat, RenderType renderType, IRenderTypeBuffer getter, FluidStack stack, Cuboid6 bound, double capacity, double res) {
        if (stack.isEmpty()) {
            return;
        }
        int alpha = 255;
        FluidAttributes attributes = stack.getFluid().getAttributes();
        if (attributes.isGaseous(stack)) {
            alpha = (int)(Math.pow(capacity, 0.4) * 255.0);
        } else {
            bound.max.y = bound.min.y + (bound.max.y - bound.min.y) * capacity;
        }
        RenderMaterial material = ForgeHooksClient.getBlockMaterial((ResourceLocation)attributes.getStillTexture(stack));
        ccrs.bind(renderType, getter);
        ccrs.baseColour = attributes.getColor(stack) << 8 | alpha;
        RenderUtils.makeFluidModel(bound, material.func_229314_c_(), res).render(ccrs, mat);
    }

    public static CCModel makeFluidModel(Cuboid6 bound, TextureAtlasSprite tex, double res) {
        CCModel model = CCModel.newModel(7);
        ArrayList<Vertex5> verts = new ArrayList<Vertex5>();
        RenderUtils.makeFluidCuboid(verts, bound, tex, res);
        model.verts = verts.toArray(new Vertex5[0]);
        return model;
    }

    public static void makeFluidCuboid(List<Vertex5> vertices, Cuboid6 bound, TextureAtlasSprite tex, double res) {
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), tex, res);
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), tex, res);
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.max.x, bound.max.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.makeFluidQuadVertices(vertices, new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), tex, res);
    }

    public static void makeFluidQuadVertices(List<Vertex5> vertices, Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, TextureAtlasSprite icon, double res) {
        RenderUtils.makeFluidQuadVertices(vertices, point2, vectors[0].set(point4).subtract(point1), vectors[1].set(point1).subtract(point2), icon, res);
    }

    public static void makeFluidQuadVertices(List<Vertex5> vertices, Vector3 base, Vector3 wide, Vector3 high, TextureAtlasSprite icon, double res) {
        double rx;
        Vector3 a = new Vector3();
        Vector3 b = new Vector3();
        Vector3 c = new Vector3();
        Vector3 d = new Vector3();
        double u1 = icon.func_94209_e();
        double du = icon.func_94212_f() - icon.func_94209_e();
        double v2 = icon.func_94210_h();
        double dv = icon.func_94210_h() - icon.func_94206_g();
        double wlen = wide.mag();
        double hlen = high.mag();
        for (double x = 0.0; x < wlen; x += rx) {
            double ry;
            rx = wlen - x;
            if (rx > res) {
                rx = res;
            }
            for (double y = 0.0; y < hlen; y += ry) {
                ry = hlen - y;
                if (ry > res) {
                    ry = res;
                }
                Vector3 dx1 = a.set(wide).multiply(x / wlen);
                Vector3 dx2 = b.set(wide).multiply((x + rx) / wlen);
                Vector3 dy1 = c.set(high).multiply(y / hlen);
                Vector3 dy2 = d.set(high).multiply((y + ry) / hlen);
                vertices.add(new Vertex5(base.x + dx1.x + dy2.x, base.y + dx1.y + dy2.y, base.z + dx1.z + dy2.z, u1, v2 - ry / res * dv));
                vertices.add(new Vertex5(base.x + dx1.x + dy1.x, base.y + dx1.y + dy1.y, base.z + dx1.z + dy1.z, u1, v2));
                vertices.add(new Vertex5(base.x + dx2.x + dy1.x, base.y + dx2.y + dy1.y, base.z + dx2.z + dy1.z, u1 + rx / res * du, v2));
                vertices.add(new Vertex5(base.x + dx2.x + dy2.x, base.y + dx2.y + dy2.y, base.z + dx2.z + dy2.z, u1 + rx / res * du, v2 - ry / res * dv));
            }
        }
    }

    public static void bufferCuboidSolid(IVertexBuilder builder, Cuboid6 c, float r, float g, float b, float a) {
        builder.func_225582_a_(c.min.x, c.max.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.max.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.min.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.min.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.min.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.min.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.max.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.max.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.min.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.min.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.min.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.min.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.max.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.max.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.max.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.max.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.min.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.max.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.max.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.min.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.min.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.max.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.max.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.min.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void bufferHitbox(Matrix4 mat, IRenderTypeBuffer getter, ActiveRenderInfo renderInfo, Cuboid6 cuboid) {
        Vector3d projectedView = renderInfo.func_216785_c();
        RenderUtils.bufferHitBox(mat.copy().translate(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c), getter, cuboid);
    }

    public static void bufferHitBox(Matrix4 mat, IRenderTypeBuffer getter, Cuboid6 cuboid) {
        TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer(RenderType.func_228659_m_()), mat);
        RenderUtils.bufferCuboidOutline(builder, cuboid.copy().expand(0.002f), 0.0f, 0.0f, 0.0f, 0.4f);
    }

    public static void bufferCuboidOutline(IVertexBuilder builder, Cuboid6 c, float r, float g, float b, float a) {
        builder.func_225582_a_(c.min.x, c.min.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.min.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.min.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.min.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.min.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.min.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.min.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.min.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.max.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.max.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.max.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.max.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.max.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.max.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.max.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.max.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.min.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.max.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.min.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.max.y, c.min.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.min.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.max.x, c.max.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.min.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_225582_a_(c.min.x, c.max.y, c.max.z).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void bufferShapeHitBox(Matrix4 mat, IRenderTypeBuffer buffers, ActiveRenderInfo renderInfo, VoxelShape shape) {
        Vector3d projectedView = renderInfo.func_216785_c();
        RenderUtils.bufferShapeHitBox(mat.copy().translate(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c), buffers, shape);
    }

    public static void bufferShapeHitBox(Matrix4 mat, IRenderTypeBuffer buffers, VoxelShape shape) {
        TransformingVertexBuilder builder = new TransformingVertexBuilder(buffers.getBuffer(RenderType.func_228659_m_()), mat);
        RenderUtils.bufferShapeOutline(builder, shape, 0.0f, 0.0f, 0.0f, 0.4f);
    }

    public static void bufferShapeOutline(IVertexBuilder builder, VoxelShape shape, float r, float g, float b, float a) {
        shape.func_197754_a((x1, y1, z1, x2, y2, z2) -> {
            builder.func_225582_a_(x1, y1, z1).func_227885_a_(r, g, b, a).func_181675_d();
            builder.func_225582_a_(x2, y2, z2).func_227885_a_(r, g, b, a).func_181675_d();
        });
    }

    public static Matrix4 getMatrix(Matrix4 in, Vector3 translation, Rotation rotation, double scale) {
        return in.translate(translation).scale(scale).rotate(rotation);
    }

    @Deprecated
    public static Matrix4 getMatrix(Vector3 translation, Rotation rotation, double scale) {
        return RenderUtils.getMatrix(new Matrix4(), translation, rotation, scale);
    }

    public static float getPearlBob(double time) {
        return (float)Math.sin(time / 25.0 * 3.141593) * 0.1f;
    }

    public static int getTimeOffset(BlockPos pos) {
        return RenderUtils.getTimeOffset(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static int getTimeOffset(int x, int y, int z) {
        return x * 3 + y * 5 + z * 9;
    }

    static {
        for (int i = 0; i < vectors.length; ++i) {
            RenderUtils.vectors[i] = new Vector3();
        }
    }
}

