/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.dropdown.DropDownWidget;
import xaero.common.minimap.info.InfoDisplay;
import xaero.common.minimap.info.InfoDisplayManager;
import xaero.common.settings.ModSettings;

public class GuiInfoDisplayEdit
extends ScreenBase {
    private static final int FRAME_TOP_SIZE = 30;
    private static final int FRAME_BOTTOM_SIZE = 61;
    private static final int SELECTION_ITEM_HEIGHT = 24;
    private static final TranslationTextComponent HELP_COMPONENT = new TranslationTextComponent("gui.xaero_minimap_info_display_manager_help");
    private SelectionList selectionList;
    private final InfoDisplayManager manager;
    private List<String> currentOrder;
    private int selected;
    private int subSelected;
    private final Map<String, MoveableEntry> moveableEntries;

    protected GuiInfoDisplayEdit(IXaeroMinimap modMain, Screen parent, Screen escape) {
        super(modMain, parent, escape, (ITextComponent)new TranslationTextComponent("gui.xaero_minimap_info_display_manager"));
        this.manager = modMain.getInterfaces().getMinimapInterface().getInfoDisplayManager();
        this.currentOrder = new ArrayList<String>();
        this.manager.getStream().forEach(info -> this.currentOrder.add(info.getId()));
        this.moveableEntries = new HashMap<String, MoveableEntry>();
        this.selected = -1;
        this.subSelected = -1;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.selectionList = new SelectionList();
        this.func_230481_d_(this.selectionList);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 34, 200, 20, (ITextComponent)new TranslationTextComponent("gui.done", new Object[0]), b -> this.goBack()));
        this.moveableEntries.clear();
        for (String id : this.currentOrder) {
            InfoDisplay<?> infoDisplay = this.manager.get(id);
            MoveableEntry moveable = new MoveableEntry();
            this.addSubElements(moveable, infoDisplay);
            this.moveableEntries.put(id, moveable);
        }
    }

    public String[] createColorOptions(String symbol, boolean noneOption) {
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length + (noneOption ? 1 : 0)];
        if (noneOption) {
            options[0] = "\u25a1\u25a1";
        }
        for (int i = 0; i < ModSettings.ENCHANT_COLOR_NAMES.length; ++i) {
            options[i + (noneOption ? 1 : 0)] = "\u00a7" + ModSettings.ENCHANT_COLORS[i] + symbol;
        }
        return options;
    }

    private <T> void addSubElements(MoveableEntry moveable, InfoDisplay<T> infoDisplay) {
        Widget stateWidget = infoDisplay.getWidgetFactory().create(this.field_230708_k_ / 2 + 150 - 102, 0, 100, 20, infoDisplay, this.modMain.getSettings());
        if (stateWidget != null) {
            moveable.addSubElement(stateWidget);
        }
        DropDownWidget textColorWidget = DropDownWidget.Builder.begin().setOptions(this.createColorOptions("Aa", false)).setX(this.field_230708_k_ / 2 - 147).setW(20).setSelected(infoDisplay.getTextColor() % ModSettings.ENCHANT_COLOR_NAMES.length).setContainer(this).setCallback((menu, index) -> {
            infoDisplay.setTextColor(index);
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }).setNarrationTitle((ITextComponent)new TranslationTextComponent("gui.xaero_dropdown_info_display_text_color")).build();
        moveable.addSubElement(textColorWidget);
        int currentBackgroundIndex = infoDisplay.getBackgroundColor();
        DropDownWidget backgroundColorWidget = DropDownWidget.Builder.begin().setOptions(this.createColorOptions("\u25a0\u25a0", true)).setX(this.field_230708_k_ / 2 - 124).setW(20).setSelected(currentBackgroundIndex < 0 ? 0 : currentBackgroundIndex % ModSettings.ENCHANT_COLOR_NAMES.length + 1).setContainer(this).setCallback((menu, index) -> {
            infoDisplay.setBackgroundColor(index - 1);
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }).setNarrationTitle((ITextComponent)new TranslationTextComponent("gui.xaero_dropdown_info_display_background_color")).build();
        moveable.addSubElement(backgroundColorWidget);
    }

    @Override
    public boolean func_231048_c_(double d, double e, int i) {
        if (this.selectionList != null) {
            this.selectionList.releaseDrag();
        }
        return super.func_231048_c_(d, e, i);
    }

    public void func_231035_a_(IGuiEventListener guiEventListener) {
        super.func_231035_a_(guiEventListener);
        if (this.selectionList != null && guiEventListener == this.selectionList) {
            this.selectionList.narrateSelection();
        }
    }

    @Override
    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.selectionList.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        GuiInfoDisplayEdit.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)5, (int)-1);
        GuiInfoDisplayEdit.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)HELP_COMPONENT, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ - 52), (int)-1);
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
    }

    class SelectionList
    extends ExtendedList<Entry> {
        private boolean dragging;
        private int dragStartX;
        private int dragStartY;
        private int dragged;
        private int draggedOffsetX;
        private int draggedOffsetY;

        public SelectionList() {
            super(GuiInfoDisplayEdit.this.field_230706_i_, GuiInfoDisplayEdit.this.field_230708_k_, GuiInfoDisplayEdit.this.field_230709_l_, 30, GuiInfoDisplayEdit.this.field_230709_l_ - 61, 24);
            this.createEntries();
            if (GuiInfoDisplayEdit.this.selected != -1) {
                this.setSelected((Entry)this.func_230953_d_(GuiInfoDisplayEdit.this.selected));
            }
            this.dragged = -1;
        }

        public boolean func_230971_aw__() {
            return GuiInfoDisplayEdit.this.func_241217_q_() == this;
        }

        public void setSelected(Entry entry) {
            Entry oldSelected;
            if (GuiInfoDisplayEdit.this.subSelected != -1 && (oldSelected = (Entry)this.func_230958_g_()) != null) {
                MoveableEntry moveable = oldSelected.getMoveable();
                ((Widget)moveable.subElements.get(GuiInfoDisplayEdit.this.subSelected)).func_231049_c__(true);
            }
            GuiInfoDisplayEdit.this.selected = entry == null ? -1 : entry.index;
            GuiInfoDisplayEdit.this.subSelected = -1;
            super.func_241215_a_((AbstractList.AbstractListEntry)entry);
            super.func_231035_a_((IGuiEventListener)entry);
            this.narrateSelection();
        }

        private void narrateSelection() {
            Entry entry = (Entry)this.func_230958_g_();
            if (!this.func_230971_aw__()) {
                return;
            }
            if (entry == null) {
                return;
            }
            String infoDisplayId = (String)GuiInfoDisplayEdit.this.currentOrder.get(entry.index);
            InfoDisplay<?> infoDisplay = GuiInfoDisplayEdit.this.manager.get(infoDisplayId);
            String narration = entry == null ? I18n.func_135052_a((String)"gui.xaero_narrator_select_nothing", (Object[])new Object[0]) : infoDisplay.getName().getString();
            NarratorChatListener.field_193643_a.func_216864_a(I18n.func_135052_a((String)"narrator.select", (Object[])new Object[]{narration}) + " . " + I18n.func_135052_a((String)"narration.xaero_ui_list_left_right_usage", (Object[])new Object[0]));
        }

        private void createEntries() {
            for (int i = 0; i < GuiInfoDisplayEdit.this.manager.getCount(); ++i) {
                Entry entry = new Entry(i);
                this.func_230513_b_((AbstractList.AbstractListEntry)entry);
            }
        }

        private void releaseDrag() {
            this.dragging = false;
            this.dragged = -1;
        }

        protected int func_230952_d_() {
            return this.field_230670_d_ / 2 + 164;
        }

        public int func_230949_c_() {
            return 300;
        }

        public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
            if (this.dragging) {
                int hoveredIndex;
                Entry draggedEntry = (Entry)this.func_230953_d_(this.dragged);
                draggedEntry.renderNonInteractable(poseStack, mouseX + this.draggedOffsetX, mouseY + this.draggedOffsetY);
                Entry hoveredEntry = (Entry)this.func_230933_a_(mouseX, mouseY);
                int n = hoveredIndex = hoveredEntry == null ? -1 : hoveredEntry.index;
                if (hoveredIndex != -1 && hoveredIndex != this.dragged) {
                    String draggedId = (String)GuiInfoDisplayEdit.this.currentOrder.get(this.dragged);
                    int slideDirection = hoveredIndex < this.dragged ? 1 : -1;
                    for (int i = this.dragged; i != hoveredIndex; i -= slideDirection) {
                        GuiInfoDisplayEdit.this.currentOrder.set(i, GuiInfoDisplayEdit.this.currentOrder.get(i - slideDirection));
                    }
                    GuiInfoDisplayEdit.this.currentOrder.set(hoveredIndex, draggedId);
                    GuiInfoDisplayEdit.this.manager.setOrder(GuiInfoDisplayEdit.this.currentOrder);
                    this.dragged = hoveredIndex;
                    try {
                        GuiInfoDisplayEdit.this.modMain.getSettings().saveSettings();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else if (this.dragged != -1 && (Math.abs(mouseX - this.dragStartX) > 5 || Math.abs(mouseY - this.dragStartY) > 5)) {
                this.dragging = true;
                this.setSelected(null);
            }
        }

        public class Entry
        extends ExtendedList.AbstractListEntry<Entry> {
            private final int index;
            private int lastRenderX;
            private int lastRenderY;

            public Entry(int index) {
                this.index = index;
            }

            private void renderNonInteractable(MatrixStack poseStack, int x, int y) {
                String infoDisplayId = (String)GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                InfoDisplay<?> infoDisplay = GuiInfoDisplayEdit.this.manager.get(infoDisplayId);
                AbstractGui.func_238475_b_((MatrixStack)poseStack, (FontRenderer)GuiInfoDisplayEdit.this.field_230712_o_, (ITextComponent)infoDisplay.getName(), (int)(x + 48), (int)(y + 6), (int)-1);
            }

            private MoveableEntry getMoveable() {
                String infoDisplayId = (String)GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                return (MoveableEntry)GuiInfoDisplayEdit.this.moveableEntries.get(infoDisplayId);
            }

            public void func_230432_a_(MatrixStack poseStack, int index, int y, int x, int l, int m, int mouseX, int mouseY, boolean bl, float partialTicks) {
                this.lastRenderX = x;
                this.lastRenderY = y;
                if (SelectionList.this.dragging && SelectionList.this.dragged == index) {
                    return;
                }
                this.renderNonInteractable(poseStack, x, y);
                MoveableEntry moveableEntry = this.getMoveable();
                for (Widget subElement : moveableEntry.subElements) {
                    subElement.field_230691_m_ = y - 2 + 12 - subElement.func_238483_d_() / 2;
                    if (subElement instanceof DropDownWidget) {
                        --subElement.field_230691_m_;
                    }
                    subElement.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
                }
            }

            public boolean func_231044_a_(double d, double e, int i) {
                MoveableEntry moveableEntry = this.getMoveable();
                for (Widget subElement : moveableEntry.subElements) {
                    if (!subElement.func_231047_b_(d, e) || !subElement.func_231044_a_(d, e, i)) continue;
                    return true;
                }
                if (i == 0) {
                    if (SelectionList.this.func_230958_g_() != this) {
                        SelectionList.this.setSelected(this);
                    } else {
                        SelectionList.this.setSelected(null);
                    }
                    SelectionList.this.dragging = false;
                    SelectionList.this.dragged = this.index;
                    SelectionList.this.draggedOffsetX = (int)((double)this.lastRenderX - d);
                    SelectionList.this.draggedOffsetY = (int)((double)this.lastRenderY - e);
                    SelectionList.this.dragStartX = (int)d;
                    SelectionList.this.dragStartY = (int)e;
                } else {
                    SelectionList.this.setSelected(null);
                }
                return super.func_231044_a_(d, e, i);
            }

            public boolean func_231048_c_(double d, double e, int i) {
                MoveableEntry moveableEntry = this.getMoveable();
                for (Widget subElement : moveableEntry.subElements) {
                    subElement.func_231048_c_(d, e, i);
                }
                return super.func_231048_c_(d, e, i);
            }

            public void func_212927_b(double d, double e) {
                MoveableEntry moveableEntry = this.getMoveable();
                for (Widget subElement : moveableEntry.subElements) {
                    if (!subElement.func_231047_b_(d, e)) continue;
                    subElement.func_212927_b(d, e);
                }
                super.func_212927_b(d, e);
            }

            public boolean func_231045_a_(double d, double e, int i, double f, double g) {
                MoveableEntry moveableEntry = this.getMoveable();
                for (Widget subElement : moveableEntry.subElements) {
                    if (!subElement.func_231047_b_(d, e) || !subElement.func_231045_a_(d, e, i, f, g)) continue;
                    return true;
                }
                return super.func_231045_a_(d, e, i, f, g);
            }

            public boolean func_231043_a_(double d, double e, double f) {
                MoveableEntry moveableEntry = this.getMoveable();
                for (Widget subElement : moveableEntry.subElements) {
                    if (!subElement.func_231047_b_(d, e) || !subElement.func_231043_a_(d, e, f)) continue;
                    return true;
                }
                return super.func_231043_a_(d, e, f);
            }

            public boolean func_231046_a_(int i, int j, int k) {
                MoveableEntry moveableEntry = this.getMoveable();
                if (i == 262 || i == 263) {
                    if (GuiInfoDisplayEdit.this.subSelected != -1) {
                        ((Widget)moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected)).func_231049_c__(true);
                    }
                    if (i == 262) {
                        GuiInfoDisplayEdit.this.subSelected++;
                        if (GuiInfoDisplayEdit.this.subSelected == moveableEntry.subElements.size()) {
                            GuiInfoDisplayEdit.this.subSelected = -1;
                        }
                    } else {
                        GuiInfoDisplayEdit.this.subSelected--;
                        if (GuiInfoDisplayEdit.this.subSelected < -1) {
                            GuiInfoDisplayEdit.this.subSelected = moveableEntry.subElements.size() - 1;
                        }
                    }
                    if (GuiInfoDisplayEdit.this.subSelected != -1) {
                        ((Widget)moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected)).func_231049_c__(true);
                    }
                } else if (GuiInfoDisplayEdit.this.subSelected != -1 && ((Widget)moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected)).func_231046_a_(i, j, k)) {
                    return true;
                }
                return super.func_231046_a_(i, j, k);
            }

            public boolean func_223281_a_(int i, int j, int k) {
                MoveableEntry moveableEntry = this.getMoveable();
                if (GuiInfoDisplayEdit.this.subSelected != -1 && ((Widget)moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected)).func_223281_a_(i, j, k)) {
                    return true;
                }
                return super.func_223281_a_(i, j, k);
            }

            public boolean func_231042_a_(char c, int i) {
                MoveableEntry moveableEntry = this.getMoveable();
                if (GuiInfoDisplayEdit.this.subSelected != -1 && ((Widget)moveableEntry.subElements.get(GuiInfoDisplayEdit.this.subSelected)).func_231042_a_(c, i)) {
                    return true;
                }
                return super.func_231042_a_(c, i);
            }
        }
    }

    class MoveableEntry {
        private final List<Widget> subElements = new ArrayList<Widget>();

        public void addSubElement(Widget widget) {
            this.subElements.add(widget);
        }
    }
}

