/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.minimap.render.radar.ModelPartRenderDetectionInfo;

public class ModelRenderDetectionElement {
    public EntityModel<?> model;
    public ResourceLocation renderTexture;
    public TextureAtlasSprite renderAtlasSprite;
    CustomRenderTypes.EntityIconLayerPhases layerPhases;
    public float red;
    public float green;
    public float blue;
    public float alpha;
    public boolean allVisible;
    private HashMap<ModelRenderer, ModelPartRenderDetectionInfo> visibleParts;

    public ModelRenderDetectionElement(EntityModel<?> model, ResourceLocation renderTexture, TextureAtlasSprite renderAtlasSprite, CustomRenderTypes.EntityIconLayerPhases layerPhases, float red, float green, float blue, float alpha) {
        this.model = model;
        this.renderTexture = renderTexture;
        this.renderAtlasSprite = renderAtlasSprite;
        this.layerPhases = layerPhases;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public String toString() {
        return this.model + " " + this.layerPhases.texture;
    }

    public void addVisibleModelPart(ModelRenderer part, float red, float green, float blue, float alpha) {
        if (this.visibleParts == null) {
            this.visibleParts = new HashMap();
        }
        this.visibleParts.put(part, new ModelPartRenderDetectionInfo(part, red, green, blue, alpha));
    }

    public ModelPartRenderDetectionInfo getModelPartRenderInfo(ModelRenderer part) {
        ModelPartRenderDetectionInfo mprdi;
        ModelPartRenderDetectionInfo modelPartRenderDetectionInfo = mprdi = this.visibleParts == null ? null : this.visibleParts.get(part);
        if (mprdi == null && this.allVisible) {
            mprdi = new ModelPartRenderDetectionInfo(part, this.red, this.green, this.blue, this.alpha);
        }
        return mprdi;
    }

    public boolean isEmpty() {
        return !this.allVisible && (this.visibleParts == null || this.visibleParts.isEmpty());
    }

    public boolean sameVisibility(ModelRenderDetectionElement other) {
        HashMap<ModelRenderer, ModelPartRenderDetectionInfo> otherVisibleParts;
        if (this.visibleParts == null != ((otherVisibleParts = other.visibleParts) == null)) {
            return false;
        }
        if (this.visibleParts == null) {
            return true;
        }
        if (this.visibleParts.size() != otherVisibleParts.size()) {
            return false;
        }
        Set<ModelRenderer> keySet = this.visibleParts.keySet();
        for (ModelRenderer key : keySet) {
            if (otherVisibleParts.containsKey(key)) continue;
            return false;
        }
        return true;
    }
}

