/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar.resource;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import xaero.common.minimap.render.radar.resource.EntityIconDefinition;
import xaero.hud.minimap.MinimapLogs;

public class EntityIconDefinitionReloader {
    private final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    public void reloadResources(Map<ResourceLocation, EntityIconDefinition> iconDefinitions) {
        MinimapLogs.LOGGER.info("Reloading entity icon resources...");
        Set entityIds = ForgeRegistries.ENTITIES.getKeys();
        int attempts = 5;
        for (int i = 0; i < attempts; ++i) {
            try {
                this.reloadResourcesAttempt(iconDefinitions, this.gson, entityIds);
                break;
            }
            catch (IOException ioe) {
                if (i != attempts - 1) continue;
                throw new RuntimeException(ioe);
            }
        }
        MinimapLogs.LOGGER.info("Reloaded entity icon resources!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadResourcesAttempt(Map<ResourceLocation, EntityIconDefinition> iconDefinitions, Gson gson, Set<ResourceLocation> entityIds) throws IOException {
        iconDefinitions.clear();
        for (ResourceLocation id : entityIds) {
            InputStream resourceInput = null;
            BufferedReader reader = null;
            String entityDefinitionJson = null;
            IResource resource = null;
            try {
                resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation("xaerominimap", "entity/icon/definition/" + id.func_110624_b() + "/" + id.func_110623_a() + ".json"));
            }
            catch (FileNotFoundException fnfe) {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                if (resource == null) continue;
                resourceInput = resource.func_199027_b();
                reader = new BufferedReader(new InputStreamReader(resourceInput));
                StringBuilder stringBuilder = new StringBuilder();
                reader.lines().forEach(line -> {
                    stringBuilder.append((String)line);
                    stringBuilder.append('\n');
                });
                entityDefinitionJson = stringBuilder.toString();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                EntityIconDefinition entityIconDefinition = (EntityIconDefinition)gson.fromJson(entityDefinitionJson, EntityIconDefinition.class);
                entityIconDefinition.onConstruct(id);
                iconDefinitions.put(id, entityIconDefinition);
            }
            catch (JsonSyntaxException jse) {
                MinimapLogs.LOGGER.error("Json syntax exception when loading the entity icon definition for " + id + ".", (Throwable)jse);
            }
        }
    }
}

