/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.material;

import com.jozufozu.flywheel.backend.instancing.InstanceData;
import com.jozufozu.flywheel.backend.material.InstanceMaterial;
import com.jozufozu.flywheel.backend.material.MaterialGroup;
import com.jozufozu.flywheel.backend.material.MaterialSpec;
import com.jozufozu.flywheel.backend.state.IRenderState;
import com.jozufozu.flywheel.backend.state.RenderLayer;
import com.jozufozu.flywheel.backend.state.TextureRenderState;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.WorldContext;
import com.jozufozu.flywheel.core.materials.ModelData;
import com.jozufozu.flywheel.core.materials.OrientedData;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.util.WeakHashSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3i;

public class MaterialManager<P extends WorldProgram> {
    public static int MAX_ORIGIN_DISTANCE = 100;
    protected BlockPos originCoordinate = BlockPos.field_177992_a;
    protected final WorldContext<P> context;
    protected final GroupFactory<P> groupFactory;
    protected final boolean ignoreOriginCoordinate;
    protected final Map<RenderLayer, Map<IRenderState, MaterialGroup<P>>> layers;
    private final WeakHashSet<OriginShiftListener> listeners;

    public MaterialManager(WorldContext<P> context) {
        this(context, MaterialGroup::new, false);
    }

    public static <P extends WorldProgram> Builder<P> builder(WorldContext<P> context) {
        return new Builder<P>(context);
    }

    public MaterialManager(WorldContext<P> context, GroupFactory<P> groupFactory, boolean ignoreOriginCoordinate) {
        this.context = context;
        this.ignoreOriginCoordinate = ignoreOriginCoordinate;
        this.listeners = new WeakHashSet();
        this.groupFactory = groupFactory;
        this.layers = new EnumMap<RenderLayer, Map<IRenderState, MaterialGroup<P>>>(RenderLayer.class);
        for (RenderLayer value : RenderLayer.values()) {
            this.layers.put(value, new HashMap());
        }
    }

    public MaterialGroup<P> state(RenderLayer layer, IRenderState state) {
        return this.layers.get((Object)layer).computeIfAbsent(state, this::createGroup);
    }

    public MaterialGroup<P> solid(IRenderState state) {
        return this.layers.get((Object)RenderLayer.SOLID).computeIfAbsent(state, this::createGroup);
    }

    public MaterialGroup<P> cutout(IRenderState state) {
        return this.layers.get((Object)RenderLayer.CUTOUT).computeIfAbsent(state, this::createGroup);
    }

    public MaterialGroup<P> transparent(IRenderState state) {
        return this.layers.get((Object)RenderLayer.TRANSPARENT).computeIfAbsent(state, this::createGroup);
    }

    public MaterialGroup<P> defaultSolid() {
        return this.solid(TextureRenderState.get(PlayerContainer.field_226615_c_));
    }

    public MaterialGroup<P> defaultCutout() {
        return this.cutout(TextureRenderState.get(PlayerContainer.field_226615_c_));
    }

    public MaterialGroup<P> defaultTransparent() {
        return this.transparent(TextureRenderState.get(PlayerContainer.field_226615_c_));
    }

    public void render(RenderLayer layer, Matrix4f viewProjection, double camX, double camY, double camZ) {
        if (!this.ignoreOriginCoordinate) {
            Matrix4f translate = Matrix4f.func_226599_b_((float)((float)(-(camX -= (double)this.originCoordinate.func_177958_n()))), (float)((float)(-(camY -= (double)this.originCoordinate.func_177956_o()))), (float)((float)(-(camZ -= (double)this.originCoordinate.func_177952_p()))));
            translate.multiplyBackward(viewProjection);
            viewProjection = translate;
        }
        for (Map.Entry<IRenderState, MaterialGroup<P>> entry : this.layers.get((Object)layer).entrySet()) {
            IRenderState state = entry.getKey();
            MaterialGroup<P> group = entry.getValue();
            state.bind();
            group.render(viewProjection, camX, camY, camZ);
            state.unbind();
        }
    }

    public void delete() {
        for (Map<IRenderState, MaterialGroup<P>> groups : this.layers.values()) {
            groups.values().forEach(MaterialGroup::delete);
        }
    }

    @Deprecated
    public <D extends InstanceData> InstanceMaterial<D> getMaterial(MaterialSpec<D> materialType) {
        return this.defaultCutout().material(materialType);
    }

    @Deprecated
    public <D extends InstanceData> InstanceMaterial<D> getMaterial(MaterialSpec<D> materialType, ResourceLocation texture) {
        return this.cutout(TextureRenderState.get(texture)).material(materialType);
    }

    @Deprecated
    public InstanceMaterial<ModelData> getTransformMaterial() {
        return this.defaultCutout().material(Materials.TRANSFORMED);
    }

    @Deprecated
    public InstanceMaterial<OrientedData> getOrientedMaterial() {
        return this.defaultCutout().material(Materials.ORIENTED);
    }

    public Supplier<P> getProgram(ResourceLocation name) {
        return this.context.getProgramSupplier(name);
    }

    public Vector3i getOriginCoordinate() {
        return this.originCoordinate;
    }

    public void addListener(OriginShiftListener listener) {
        this.listeners.add(listener);
    }

    public void checkAndShiftOrigin(ActiveRenderInfo info) {
        int cX = MathHelper.func_76128_c((double)info.func_216785_c().field_72450_a);
        int cY = MathHelper.func_76128_c((double)info.func_216785_c().field_72448_b);
        int cZ = MathHelper.func_76128_c((double)info.func_216785_c().field_72449_c);
        int dX = cX - this.originCoordinate.func_177958_n();
        int dY = cY - this.originCoordinate.func_177956_o();
        int dZ = cZ - this.originCoordinate.func_177952_p();
        if (Math.abs(dX) > MAX_ORIGIN_DISTANCE || Math.abs(dY) > MAX_ORIGIN_DISTANCE || Math.abs(dZ) > MAX_ORIGIN_DISTANCE) {
            this.originCoordinate = new BlockPos(cX, cY, cZ);
            for (Map<IRenderState, MaterialGroup<P>> groups : this.layers.values()) {
                groups.values().forEach(MaterialGroup::clear);
            }
            this.listeners.forEach(OriginShiftListener::onOriginShift);
        }
    }

    private MaterialGroup<P> createGroup(IRenderState state) {
        return this.groupFactory.create(this, state);
    }

    public static class Builder<P extends WorldProgram> {
        protected final WorldContext<P> context;
        protected GroupFactory<P> groupFactory = MaterialGroup::new;
        protected boolean ignoreOriginCoordinate;

        public Builder(WorldContext<P> context) {
            this.context = context;
        }

        public Builder<P> setGroupFactory(GroupFactory<P> groupFactory) {
            this.groupFactory = groupFactory;
            return this;
        }

        public Builder<P> setIgnoreOriginCoordinate(boolean ignoreOriginCoordinate) {
            this.ignoreOriginCoordinate = ignoreOriginCoordinate;
            return this;
        }

        public MaterialManager<P> build() {
            return new MaterialManager<P>(this.context, this.groupFactory, this.ignoreOriginCoordinate);
        }
    }

    @FunctionalInterface
    public static interface GroupFactory<P extends WorldProgram> {
        public MaterialGroup<P> create(MaterialManager<P> var1, IRenderState var2);
    }

    @FunctionalInterface
    public static interface OriginShiftListener {
        public void onOriginShift();
    }
}

