/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class FlwConfig {
    private static final FlwConfig INSTANCE = new FlwConfig();
    public final ClientConfig client;

    public FlwConfig() {
        Pair client = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        this.client = (ClientConfig)client.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)client.getRight());
    }

    public static FlwConfig get() {
        return INSTANCE;
    }

    public boolean enabled() {
        return (Boolean)this.client.enabled.get();
    }

    public boolean debugNormals() {
        return (Boolean)this.client.debugNormals.get();
    }

    public static void init() {
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue enabled;
        public final ForgeConfigSpec.BooleanValue debugNormals;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.enabled = builder.comment("Enable or disable the entire engine").define("enabled", true);
            this.debugNormals = builder.comment("Enable or disable a debug overlay that colors pixels by their normal").define("debugNormals", false);
        }
    }
}

