/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.crumbling;

import com.jozufozu.flywheel.backend.loading.Program;
import com.jozufozu.flywheel.core.atlas.AtlasInfo;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.core.shader.extension.IProgramExtension;
import java.util.List;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;

public class CrumblingProgram
extends WorldProgram {
    protected final int uTextureScale = this.getUniformLocation("uTextureScale");
    protected int uCrumbling;

    public CrumblingProgram(Program program, List<IProgramExtension> extensions) {
        super(program, extensions);
    }

    @Override
    protected void registerSamplers() {
        super.registerSamplers();
        this.uCrumbling = this.setSamplerBinding("uCrumbling", 4);
    }

    public void setTextureScale(float x, float y) {
        GL20.glUniform2f((int)this.uTextureScale, (float)x, (float)y);
    }

    public void setAtlasSize(int width, int height) {
        AtlasTexture blockAtlas = AtlasInfo.getAtlas(PlayerContainer.field_226615_c_);
        if (blockAtlas == null) {
            return;
        }
        TextureAtlasSprite sprite = blockAtlas.func_195424_a((ResourceLocation)ModelBakery.field_229319_j_.get(0));
        this.setTextureScale((float)width / (float)sprite.func_94211_a(), (float)height / (float)sprite.func_94216_b());
    }
}

