/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.mantle.util.SupplierItemGroup;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.gadgets.block.FoodCakeBlock;
import slimeknights.tconstruct.gadgets.block.PunjiBlock;
import slimeknights.tconstruct.gadgets.capability.PiggybackCapability;
import slimeknights.tconstruct.gadgets.data.GadgetRecipeProvider;
import slimeknights.tconstruct.gadgets.entity.EflnBallEntity;
import slimeknights.tconstruct.gadgets.entity.FancyItemFrameEntity;
import slimeknights.tconstruct.gadgets.entity.FrameType;
import slimeknights.tconstruct.gadgets.entity.GlowballEntity;
import slimeknights.tconstruct.gadgets.entity.shuriken.FlintShurikenEntity;
import slimeknights.tconstruct.gadgets.entity.shuriken.QuartzShurikenEntity;
import slimeknights.tconstruct.gadgets.item.EflnBallItem;
import slimeknights.tconstruct.gadgets.item.FancyItemFrameItem;
import slimeknights.tconstruct.gadgets.item.GlowBallItem;
import slimeknights.tconstruct.gadgets.item.PiggyBackPackItem;
import slimeknights.tconstruct.gadgets.item.ShurikenItem;
import slimeknights.tconstruct.gadgets.item.slimesling.BaseSlimeSlingItem;
import slimeknights.tconstruct.gadgets.item.slimesling.EarthSlimeSlingItem;
import slimeknights.tconstruct.gadgets.item.slimesling.EnderSlimeSlingItem;
import slimeknights.tconstruct.gadgets.item.slimesling.IchorSlimeSlingItem;
import slimeknights.tconstruct.gadgets.item.slimesling.SkySlimeSlingItem;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.TinkerFood;
import slimeknights.tconstruct.shared.block.SlimeType;

public final class TinkerGadgets
extends TinkerModule {
    public static final ItemGroup TAB_GADGETS = new SupplierItemGroup("tconstruct", "gadgets", () -> new ItemStack((IItemProvider)slimeSling.get((Enum)SlimeType.EARTH)));
    static final Logger log = Util.getLogger("tinker_gadgets");
    private static final Item.Properties GADGET_PROPS = new Item.Properties().func_200916_a(TAB_GADGETS);
    private static final Item.Properties UNSTACKABLE_PROPS = new Item.Properties().func_200916_a(TAB_GADGETS).func_200917_a(1);
    private static final Function<Block, ? extends BlockItem> DEFAULT_BLOCK_ITEM = b -> new BlockItem(b, GADGET_PROPS);
    private static final Function<Block, ? extends BlockItem> TOOLTIP_BLOCK_ITEM = b -> new BlockTooltipItem(b, GADGET_PROPS);
    private static final Function<Block, ? extends BlockItem> UNSTACKABLE_BLOCK_ITEM = b -> new BlockTooltipItem(b, UNSTACKABLE_PROPS);
    public static final ItemObject<PunjiBlock> punji = BLOCKS.register("punji", () -> new PunjiBlock(TinkerGadgets.builder(Material.field_151585_k, NO_TOOL, SoundType.field_185850_c).func_200943_b(3.0f).func_226896_b_()), HIDDEN_BLOCK_ITEM);
    public static final ItemObject<PiggyBackPackItem> piggyBackpack = ITEMS.register("piggy_backpack", () -> new PiggyBackPackItem(new Item.Properties().func_200916_a(TAB_GADGETS).func_200917_a(16)));
    public static final EnumObject<FrameType, FancyItemFrameItem> itemFrame = ITEMS.registerEnum(FrameType.values(), "item_frame", type -> new FancyItemFrameItem(GADGET_PROPS, (world, pos, dir) -> new FancyItemFrameEntity((World)world, (BlockPos)pos, (Direction)dir, (FrameType)((Object)type))));
    private static final Item.Properties SLING_PROPS = new Item.Properties().func_200916_a(TAB_GADGETS).func_200917_a(1).func_200918_c(250);
    public static final EnumObject<SlimeType, BaseSlimeSlingItem> slimeSling = new EnumObject.Builder(SlimeType.class).put((Enum)SlimeType.EARTH, (Supplier)ITEMS.register("earth_slime_sling", () -> new EarthSlimeSlingItem(SLING_PROPS))).put((Enum)SlimeType.SKY, (Supplier)ITEMS.register("sky_slime_sling", () -> new SkySlimeSlingItem(SLING_PROPS))).put((Enum)SlimeType.ICHOR, (Supplier)ITEMS.register("ichor_slime_sling", () -> new IchorSlimeSlingItem(SLING_PROPS))).put((Enum)SlimeType.ENDER, (Supplier)ITEMS.register("ender_slime_sling", () -> new EnderSlimeSlingItem(SLING_PROPS))).build();
    public static final ItemObject<GlowBallItem> glowBall = ITEMS.register("glow_ball", GlowBallItem::new);
    public static final ItemObject<EflnBallItem> efln = ITEMS.register("efln_ball", EflnBallItem::new);
    private static final AbstractBlock.Properties CAKE = TinkerGadgets.builder(Material.field_151568_F, NO_TOOL, SoundType.field_185854_g).func_200943_b(0.5f);
    public static final EnumObject<SlimeType, FoodCakeBlock> cake = BLOCKS.registerEnum(SlimeType.LIQUID, "cake", type -> new FoodCakeBlock(CAKE, TinkerFood.getCake(type)), UNSTACKABLE_BLOCK_ITEM);
    public static final ItemObject<FoodCakeBlock> magmaCake = BLOCKS.register("magma_cake", () -> new FoodCakeBlock(CAKE, TinkerFood.MAGMA_CAKE), UNSTACKABLE_BLOCK_ITEM);
    private static final Item.Properties THROWABLE_PROPS = new Item.Properties().func_200917_a(16).func_200916_a(TAB_GADGETS);
    public static final ItemObject<ShurikenItem> quartzShuriken = ITEMS.register("quartz_shuriken", () -> new ShurikenItem(THROWABLE_PROPS, QuartzShurikenEntity::new));
    public static final ItemObject<ShurikenItem> flintShuriken = ITEMS.register("flint_shuriken", () -> new ShurikenItem(THROWABLE_PROPS, FlintShurikenEntity::new));
    public static final RegistryObject<EntityType<FancyItemFrameEntity>> itemFrameEntity = ENTITIES.register("fancy_item_frame", () -> EntityType.Builder.func_220322_a(FancyItemFrameEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(10).setUpdateInterval(Integer.MAX_VALUE).setCustomClientFactory((spawnEntity, world) -> new FancyItemFrameEntity((EntityType<? extends FancyItemFrameEntity>)((EntityType)itemFrameEntity.get()), (World)world)).setShouldReceiveVelocityUpdates(false));
    public static final RegistryObject<EntityType<GlowballEntity>> glowBallEntity = ENTITIES.register("glow_ball", () -> EntityType.Builder.func_220322_a(GlowballEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setCustomClientFactory((spawnEntity, world) -> new GlowballEntity((EntityType<? extends GlowballEntity>)((EntityType)glowBallEntity.get()), (World)world)).setShouldReceiveVelocityUpdates(true));
    public static final RegistryObject<EntityType<EflnBallEntity>> eflnEntity = ENTITIES.register("efln_ball", () -> EntityType.Builder.func_220322_a(EflnBallEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setCustomClientFactory((spawnEntity, world) -> new EflnBallEntity((EntityType<? extends EflnBallEntity>)((EntityType)eflnEntity.get()), (World)world)).setShouldReceiveVelocityUpdates(true));
    public static final RegistryObject<EntityType<QuartzShurikenEntity>> quartzShurikenEntity = ENTITIES.register("quartz_shuriken", () -> EntityType.Builder.func_220322_a(QuartzShurikenEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setCustomClientFactory((spawnEntity, world) -> new QuartzShurikenEntity((EntityType<? extends QuartzShurikenEntity>)((EntityType)quartzShurikenEntity.get()), (World)world)).setShouldReceiveVelocityUpdates(true));
    public static final RegistryObject<EntityType<FlintShurikenEntity>> flintShurikenEntity = ENTITIES.register("flint_shuriken", () -> EntityType.Builder.func_220322_a(FlintShurikenEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setCustomClientFactory((spawnEntity, world) -> new FlintShurikenEntity((EntityType<? extends FlintShurikenEntity>)((EntityType)flintShurikenEntity.get()), (World)world)).setShouldReceiveVelocityUpdates(true));
    public static final RegistryObject<PiggyBackPackItem.CarryPotionEffect> carryEffect = POTIONS.register("carry", PiggyBackPackItem.CarryPotionEffect::new);

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        PiggybackCapability.register();
        event.enqueueWork(() -> {
            cake.forEach(block -> ComposterBlock.func_220290_a((float)1.0f, (IItemProvider)block));
            ComposterBlock.func_220290_a((float)1.0f, (IItemProvider)((IItemProvider)magmaCake.get()));
        });
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            DataGenerator datagenerator = event.getGenerator();
            datagenerator.func_200390_a((IDataProvider)new GadgetRecipeProvider(datagenerator));
        }
    }
}

