/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;

public final class RenderUtils {
    public static void renderTransparentCuboid(MatrixStack matrices, IRenderTypeBuffer buffer, FluidCuboid cube, FluidStack fluid, int opacity, int light) {
        if (opacity < 0 || fluid.isEmpty()) {
            return;
        }
        FluidAttributes attributes = fluid.getFluid().getAttributes();
        TextureAtlasSprite still = FluidRenderer.getBlockSprite((ResourceLocation)attributes.getStillTexture(fluid));
        TextureAtlasSprite flowing = FluidRenderer.getBlockSprite((ResourceLocation)attributes.getFlowingTexture(fluid));
        boolean isGas = attributes.isGaseous(fluid);
        light = FluidRenderer.withBlockLight((int)light, (int)attributes.getLuminosity(fluid));
        int color = attributes.getColor(fluid);
        if (opacity < 255) {
            int alpha = (color >> 24 & 0xFF) * opacity / 255;
            color = color & 0xFFFFFF | alpha << 24;
        }
        FluidRenderer.renderCuboid((MatrixStack)matrices, (IVertexBuilder)buffer.getBuffer(FluidRenderer.RENDER_TYPE), (FluidCuboid)cube, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (Vector3f)cube.getFromScaled(), (Vector3f)cube.getToScaled(), (int)color, (int)light, (boolean)isGas);
    }

    public static void renderFluidTank(MatrixStack matrices, IRenderTypeBuffer buffer, FluidCuboid cube, FluidTankAnimated tank, int light, float partialTicks, boolean flipGas) {
        FluidStack liquid = tank.getFluid();
        int capacity = tank.getCapacity();
        if (!liquid.isEmpty() && capacity > 0) {
            float offset = tank.getRenderOffset();
            if (offset > 1.2f || offset < -1.2f) {
                offset -= (offset / 12.0f + 0.1f) * partialTicks;
                tank.setRenderOffset(offset);
            } else {
                tank.setRenderOffset(0.0f);
            }
            FluidRenderer.renderScaledCuboid((MatrixStack)matrices, (IRenderTypeBuffer)buffer, (FluidCuboid)cube, (FluidStack)liquid, (float)offset, (int)capacity, (int)light, (boolean)flipGas);
        } else {
            tank.setRenderOffset(0.0f);
        }
    }

    public static void setColorRGBA(int color) {
        float a = (float)RenderUtils.alpha(color) / 255.0f;
        float r = (float)RenderUtils.red(color) / 255.0f;
        float g = (float)RenderUtils.green(color) / 255.0f;
        float b = (float)RenderUtils.blue(color) / 255.0f;
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }

    private RenderUtils() {
    }
}

