/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.vector.TransformationMatrix;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class NormalModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = new Unbaked(-1, 0);
    private final RenderMaterial[] textures;
    private final int color;
    private final int luminosity;

    public NormalModifierModel(@Nullable RenderMaterial smallTexture, @Nullable RenderMaterial largeTexture, int color, int luminosity) {
        this.color = color;
        this.luminosity = luminosity;
        this.textures = new RenderMaterial[]{smallTexture, largeTexture};
    }

    public NormalModifierModel(@Nullable RenderMaterial smallTexture, @Nullable RenderMaterial largeTexture) {
        this(smallTexture, largeTexture, -1, 0);
    }

    @Override
    @Deprecated
    public ImmutableList<BakedQuad> getQuads(IModifierToolStack tool, ModifierEntry entry, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, TransformationMatrix transforms, boolean isLarge) {
        return this.getQuads(tool, entry, spriteGetter, transforms, isLarge, -1, null);
    }

    @Override
    public ImmutableList<BakedQuad> getQuads(IModifierToolStack tool, ModifierEntry entry, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, TransformationMatrix transforms, boolean isLarge, int startTintIndex, @Nullable ItemLayerPixels pixels) {
        int index = isLarge ? 1 : 0;
        return MantleItemLayerModel.getQuadsForSprite((int)this.color, (int)-1, (TextureAtlasSprite)spriteGetter.apply(this.textures[index]), (TransformationMatrix)transforms, (int)this.luminosity, (ItemLayerPixels)pixels);
    }

    private static class Unbaked
    implements IUnbakedModifierModel {
        private final int color;
        private final int luminosity;

        @Override
        @Nullable
        public IBakedModifierModel forTool(Function<String, RenderMaterial> smallGetter, Function<String, RenderMaterial> largeGetter) {
            RenderMaterial smallTexture = smallGetter.apply("");
            RenderMaterial largeTexture = largeGetter.apply("");
            if (smallTexture != null || largeTexture != null) {
                return new NormalModifierModel(smallTexture, largeTexture, this.color, this.luminosity);
            }
            return null;
        }

        @Override
        public IUnbakedModifierModel configure(JsonObject data) {
            int color = JsonHelper.parseColor((String)JSONUtils.func_151219_a((JsonObject)data, (String)"color", (String)""));
            int luminosity = JSONUtils.func_151203_m((JsonObject)data, (String)"luminosity");
            if (color != this.color || luminosity != this.luminosity) {
                return new Unbaked(color, luminosity);
            }
            return this;
        }

        public Unbaked(int color, int luminosity) {
            this.color = color;
            this.luminosity = luminosity;
        }
    }
}

