/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.material;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.data.GenericDataProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialDataProvider;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;

public abstract class AbstractMaterialStatsDataProvider
extends GenericDataProvider {
    private final Map<MaterialId, List<IMaterialStats>> allMaterialStats = new HashMap<MaterialId, List<IMaterialStats>>();
    private final AbstractMaterialDataProvider materials;

    public AbstractMaterialStatsDataProvider(DataGenerator gen, AbstractMaterialDataProvider materials) {
        super(gen, "materials/stats");
        this.materials = materials;
    }

    protected abstract void addMaterialStats();

    public void func_200398_a(DirectoryCache cache) {
        this.addMaterialStats();
        Set<MaterialId> materialsGenerated = this.materials.getAllMaterials();
        for (MaterialId material : materialsGenerated) {
            if (this.allMaterialStats.containsKey((Object)material)) continue;
            throw new IllegalStateException(String.format("Missing material stats for '%s'", new Object[]{material}));
        }
        this.allMaterialStats.forEach((materialId, materialStats) -> this.saveThing(cache, (ResourceLocation)materialId, this.convert((List<IMaterialStats>)materialStats)));
    }

    protected void addMaterialStats(MaterialId location, IMaterialStats ... stats) {
        this.allMaterialStats.computeIfAbsent(location, materialId -> new ArrayList()).addAll(Arrays.asList(stats));
    }

    private JsonWrapper convert(List<IMaterialStats> stats) {
        Map<ResourceLocation, IMaterialStats> wrappedStats = stats.stream().collect(Collectors.toMap(IMaterialStats::getIdentifier, stat -> stat));
        return new JsonWrapper(wrappedStats);
    }

    private static class JsonWrapper {
        private final Map<ResourceLocation, IMaterialStats> stats;

        public JsonWrapper(Map<ResourceLocation, IMaterialStats> stats) {
            this.stats = stats;
        }
    }
}

