/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.recipe;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.TrueCondition;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.common.registration.MetalItemObject;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.data.recipe.ICastCreationHelper;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public interface ISmelteryRecipeHelper
extends ICastCreationHelper {
    default public void metalMeltingBase(Consumer<IFinishedRecipe> consumer, Fluid fluid, int amount, String tagName, float factor, String recipePath, boolean isOptional) {
        Consumer<IFinishedRecipe> wrapped = isOptional ? this.withCondition(consumer, this.tagCondition(tagName)) : consumer;
        MeltingRecipeBuilder.melting(Ingredient.func_199805_a(this.getTag("forge", tagName)), fluid, amount, factor).build(wrapped, this.modResource(recipePath));
    }

    default public void oreMelting(Consumer<IFinishedRecipe> consumer, Fluid fluid, int amount, String tagName, float factor, String recipePath, boolean isOptional, IByproduct ... byproducts) {
        Consumer<IFinishedRecipe> wrapped = isOptional ? this.withCondition(consumer, this.tagCondition(tagName)) : consumer;
        Supplier<MeltingRecipeBuilder> supplier = () -> MeltingRecipeBuilder.melting(Ingredient.func_199805_a(this.getTag("forge", tagName)), fluid, amount, factor).setOre();
        ResourceLocation location = this.modResource(recipePath);
        if (byproducts.length == 0) {
            supplier.get().build(wrapped, location);
        } else if (byproducts[0].isAlwaysPresent()) {
            supplier.get().addByproduct(new FluidStack(byproducts[0].getFluid(), byproducts[0].getNuggets())).build(wrapped, location);
        } else {
            ConditionalRecipe.Builder builder = ConditionalRecipe.builder();
            boolean alwaysPresent = false;
            for (IByproduct byproduct : byproducts) {
                builder.addCondition(this.tagCondition("ingots/" + byproduct.getName()));
                builder.addRecipe(supplier.get().addByproduct(new FluidStack(byproduct.getFluid(), byproduct.getNuggets()))::build);
                alwaysPresent = byproduct.isAlwaysPresent();
                if (alwaysPresent) break;
            }
            if (!alwaysPresent) {
                builder.addCondition((ICondition)TrueCondition.INSTANCE);
                builder.addRecipe(supplier.get()::build);
            }
            builder.build(wrapped, location);
        }
    }

    default public void metalMelting(Consumer<IFinishedRecipe> consumer, Fluid fluid, String name, boolean hasOre, boolean hasDust, String folder, boolean isOptional, IByproduct ... byproducts) {
        String prefix = folder + "/" + name + "/";
        this.metalMeltingBase(consumer, fluid, 1296, "storage_blocks/" + name, 3.0f, prefix + "block", isOptional);
        this.metalMeltingBase(consumer, fluid, 144, "ingots/" + name, 1.0f, prefix + "ingot", isOptional);
        this.metalMeltingBase(consumer, fluid, 16, "nuggets/" + name, 0.33333334f, prefix + "nugget", isOptional);
        if (hasOre) {
            this.oreMelting(consumer, fluid, 144, "ores/" + name, 1.5f, prefix + "ore", isOptional, byproducts);
        }
        if (hasDust) {
            this.metalMeltingBase(consumer, fluid, 144, "dusts/" + name, 0.75f, prefix + "dust", true);
        }
        this.metalMeltingBase(consumer, fluid, 144, "plates/" + name, 1.0f, prefix + "plates", true);
        this.metalMeltingBase(consumer, fluid, 576, "gears/" + name, 2.0f, prefix + "gear", true);
        this.metalMeltingBase(consumer, fluid, 48, "coins/" + name, 0.6666667f, prefix + "coin", true);
        this.metalMeltingBase(consumer, fluid, 72, "rods/" + name, 0.2f, prefix + "rod", true);
        this.metalMeltingBase(consumer, fluid, 72, "wires/" + name, 0.2f, prefix + "wire", true);
        this.metalMeltingBase(consumer, fluid, 144, "sheetmetals/" + name, 1.0f, prefix + "sheetmetal", true);
    }

    default public void metalMelting(Consumer<IFinishedRecipe> consumer, Fluid fluid, String name, boolean hasOre, String folder, boolean isOptional, IByproduct ... byproducts) {
        this.metalMelting(consumer, fluid, name, hasOre, true, folder, isOptional, byproducts);
    }

    default public void castingWithCast(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, boolean forgeTag, int amount, CastItemObject cast, ItemOutput output, String location) {
        ItemCastingRecipeBuilder.tableRecipe(output).setFluidAndTime(fluid, forgeTag, amount).setCast((ITag<Item>)cast.getMultiUseTag(), false).build(consumer, this.modResource(location + "_gold_cast"));
        ItemCastingRecipeBuilder.tableRecipe(output).setFluidAndTime(fluid, forgeTag, amount).setCast((ITag<Item>)cast.getSingleUseTag(), true).build(consumer, this.modResource(location + "_sand_cast"));
    }

    default public void castingWithCast(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, int amount, CastItemObject cast, ItemOutput output, String location) {
        this.castingWithCast(consumer, fluid, false, amount, cast, output, location);
    }

    default public void castingWithCast(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, boolean forgeTag, int amount, CastItemObject cast, IItemProvider output, String location) {
        this.castingWithCast(consumer, fluid, forgeTag, amount, cast, ItemOutput.fromItem((IItemProvider)output), location);
    }

    default public void castingWithCast(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, int amount, CastItemObject cast, IItemProvider output, String location) {
        this.castingWithCast(consumer, fluid, amount, cast, ItemOutput.fromItem((IItemProvider)output), location);
    }

    default public void tagCasting(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, boolean forgeTag, int amount, CastItemObject cast, String tagName, String recipeName, boolean optional) {
        if (optional) {
            consumer = this.withCondition(consumer, this.tagCondition(tagName));
        }
        this.castingWithCast(consumer, fluid, forgeTag, amount, cast, ItemOutput.fromTag(this.getTag("forge", tagName), (int)1), recipeName);
    }

    default public void tagCasting(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, int amount, CastItemObject cast, String tagName, String recipeName, boolean optional) {
        this.tagCasting(consumer, fluid, false, amount, cast, tagName, recipeName, optional);
    }

    default public void ingotCasting(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, boolean forgeTag, int amount, IItemProvider ingot, String location) {
        this.castingWithCast(consumer, fluid, forgeTag, amount, TinkerSmeltery.ingotCast, ingot, location);
    }

    default public void ingotCasting(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, boolean forgeTag, IItemProvider ingot, String location) {
        this.ingotCasting(consumer, fluid, forgeTag, 144, ingot, location);
    }

    default public void ingotCasting(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, int amount, IItemProvider ingot, String location) {
        this.ingotCasting(consumer, fluid, false, amount, ingot, location);
    }

    default public void ingotCasting(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, IItemProvider ingot, String location) {
        this.ingotCasting(consumer, fluid, 144, ingot, location);
    }

    default public void gemCasting(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, IItemProvider gem, String location) {
        this.castingWithCast(consumer, fluid, 144, TinkerSmeltery.gemCast, gem, location);
    }

    default public void nuggetCasting(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, boolean forgeTag, IItemProvider nugget, String location) {
        this.castingWithCast(consumer, fluid, forgeTag, 16, TinkerSmeltery.nuggetCast, nugget, location);
    }

    default public void nuggetCastingRecipe(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, IItemProvider nugget, String location) {
        this.nuggetCasting(consumer, fluid, false, nugget, location);
    }

    default public void metalCasting(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, boolean forgeTag, @Nullable IItemProvider block, @Nullable IItemProvider ingot, @Nullable IItemProvider nugget, String folder, String metal) {
        String metalFolder = folder + metal + "/";
        if (block != null) {
            ItemCastingRecipeBuilder.basinRecipe(block).setFluidAndTime(fluid, forgeTag, 1296).build(consumer, this.modResource(metalFolder + "block"));
        }
        if (ingot != null) {
            this.ingotCasting(consumer, fluid, forgeTag, ingot, metalFolder + "ingot");
        }
        if (nugget != null) {
            this.nuggetCasting(consumer, fluid, forgeTag, nugget, metalFolder + "nugget");
        }
        this.tagCasting(consumer, fluid, forgeTag, 144, TinkerSmeltery.plateCast, "plates/" + metal, folder + metal + "/plate", true);
        this.tagCasting(consumer, fluid, forgeTag, 576, TinkerSmeltery.gearCast, "gears/" + metal, folder + metal + "/gear", true);
        this.tagCasting(consumer, fluid, forgeTag, 48, TinkerSmeltery.coinCast, "coins/" + metal, folder + metal + "/coin", true);
        this.tagCasting(consumer, fluid, forgeTag, 72, TinkerSmeltery.rodCast, "rods/" + metal, folder + metal + "/rod", true);
        this.tagCasting(consumer, fluid, forgeTag, 72, TinkerSmeltery.wireCast, "wires/" + metal, folder + metal + "/wire", true);
    }

    default public void metalCasting(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, @Nullable IItemProvider block, @Nullable IItemProvider ingot, @Nullable IItemProvider nugget, String folder, String metal) {
        this.metalCasting(consumer, fluid, false, block, ingot, nugget, folder, metal);
    }

    default public void metalCasting(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, MetalItemObject metal, String folder, String name) {
        this.metalCasting(consumer, fluid, (IItemProvider)metal.get(), (IItemProvider)metal.getIngot(), (IItemProvider)metal.getNugget(), folder, name);
    }

    default public void metalTagCasting(Consumer<IFinishedRecipe> consumer, FluidObject<?> fluid, String name, String folder, boolean forceStandard) {
        this.tagCasting(consumer, fluid, true, 16, TinkerSmeltery.nuggetCast, "nuggets/" + name, folder + name + "/nugget", !forceStandard);
        this.tagCasting(consumer, fluid, true, 144, TinkerSmeltery.ingotCast, "ingots/" + name, folder + name + "/ingot", !forceStandard);
        this.tagCasting(consumer, fluid, true, 144, TinkerSmeltery.plateCast, "plates/" + name, folder + name + "/plate", true);
        this.tagCasting(consumer, fluid, true, 576, TinkerSmeltery.gearCast, "gears/" + name, folder + name + "/gear", true);
        this.tagCasting(consumer, fluid, true, 48, TinkerSmeltery.coinCast, "coins/" + name, folder + name + "/coin", true);
        this.tagCasting(consumer, fluid, true, 72, TinkerSmeltery.rodCast, "rods/" + name, folder + name + "/rod", true);
        this.tagCasting(consumer, fluid, true, 72, TinkerSmeltery.wireCast, "wires/" + name, folder + name + "/wire", true);
        ITag.INamedTag<Item> block = this.getTag("forge", "storage_blocks/" + name);
        Consumer<IFinishedRecipe> wrapped = forceStandard ? consumer : this.withCondition(consumer, this.tagCondition("storage_blocks/" + name));
        ItemCastingRecipeBuilder.basinRecipe(block).setFluidAndTime(fluid, true, 1296).build(wrapped, this.modResource(folder + name + "/block"));
    }
}

