/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialManager;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsManager;
import slimeknights.tconstruct.library.materials.traits.MaterialTraitsManager;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;

public class MaterialRegistryImpl
implements IMaterialRegistry {
    private final MaterialManager materialManager;
    private final MaterialStatsManager materialStatsManager;
    private final MaterialTraitsManager materialTraitsManager;

    protected MaterialRegistryImpl(MaterialManager materialManager, MaterialStatsManager materialStatsManager, MaterialTraitsManager materialTraitsManager) {
        this.materialManager = materialManager;
        this.materialStatsManager = materialStatsManager;
        this.materialTraitsManager = materialTraitsManager;
    }

    @Override
    public MaterialId resolve(MaterialId id) {
        return this.materialManager.resolveRedirect(id);
    }

    @Override
    public IMaterial getMaterial(MaterialId id) {
        return this.materialManager.getMaterial(id).orElse(IMaterial.UNKNOWN);
    }

    @Override
    public Collection<IMaterial> getVisibleMaterials() {
        return this.materialManager.getVisibleMaterials();
    }

    @Override
    public Collection<IMaterial> getAllMaterials() {
        return this.materialManager.getAllMaterials();
    }

    @Override
    public <T extends IMaterialStats> Optional<T> getMaterialStats(MaterialId materialId, MaterialStatsId statsId) {
        return this.materialStatsManager.getStats(materialId, statsId);
    }

    @Override
    public Collection<IMaterialStats> getAllStats(MaterialId materialId) {
        return this.materialStatsManager.getAllStats(materialId);
    }

    @Override
    public <T extends IMaterialStats> T getDefaultStats(MaterialStatsId statsId) {
        return this.materialStatsManager.getDefaultStats(statsId);
    }

    @Override
    public boolean canRepair(MaterialStatsId statsId) {
        return this.materialStatsManager.canRepair(statsId);
    }

    @Override
    public <T extends IMaterialStats> void registerStatType(T defaultStats, Class<T> clazz) {
        this.materialStatsManager.registerMaterialStat(defaultStats, clazz);
    }

    @Override
    public List<ModifierEntry> getDefaultTraits(MaterialId materialId) {
        return this.materialTraitsManager.getDefaultTraits(materialId);
    }

    @Override
    public boolean hasUniqueTraits(MaterialId materialId, MaterialStatsId statsId) {
        return this.materialTraitsManager.hasUniqueTraits(materialId, statsId);
    }

    @Override
    public List<ModifierEntry> getTraits(MaterialId materialId, MaterialStatsId statsId) {
        return this.materialTraitsManager.getTraits(materialId, statsId);
    }
}

