/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.definition;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.library.materials.definition.Material;
import slimeknights.tconstruct.library.materials.definition.MaterialId;

public interface IMaterial
extends Comparable<IMaterial> {
    public static final MaterialId UNKNOWN_ID = new MaterialId("tconstruct", "unknown");
    public static final IMaterial UNKNOWN = new Material(UNKNOWN_ID, false, true);

    public MaterialId getIdentifier();

    public boolean isCraftable();

    default public String getTranslationKey() {
        return Util.func_200697_a((String)"material", (ResourceLocation)this.getIdentifier());
    }

    default public ITextComponent getDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    default public ITextComponent getColoredDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey()).func_240700_a_(style -> style.func_240718_a_(this.getColor()));
    }

    public Color getColor();

    public boolean isHidden();

    public int getTier();

    public int getSortOrder();

    @Override
    default public int compareTo(IMaterial other) {
        if (this.getTier() != other.getTier()) {
            return Integer.compare(this.getTier(), other.getTier());
        }
        if (this.getSortOrder() != other.getSortOrder()) {
            return Integer.compare(this.getSortOrder(), other.getSortOrder());
        }
        return this.getIdentifier().compareTo(other.getIdentifier());
    }
}

