/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.recipe.ItemOutput;

public abstract class RandomItem {
    public static RandomItem range(ItemOutput result, int minCount) {
        return new Range(result, minCount);
    }

    public static RandomItem range(ItemOutput result) {
        return RandomItem.range(result, 0);
    }

    public static RandomItem chance(ItemOutput result, float chance) {
        return new Chance(result, chance);
    }

    public static RandomItem constant(ItemOutput result) {
        return RandomItem.chance(result, 1.0f);
    }

    public abstract ItemStack get(Random var1);

    public abstract JsonElement serialize();

    public abstract void write(PacketBuffer var1);

    public static RandomItem fromJson(JsonElement element, String name) {
        JsonObject object;
        if (element.isJsonObject() && (object = element.getAsJsonObject()).has("max")) {
            object.addProperty("count", (Number)JSONUtils.func_151203_m((JsonObject)object, (String)"max"));
            object.remove("max");
        }
        ItemOutput result = ItemOutput.fromJson((JsonElement)element);
        if (element.isJsonPrimitive()) {
            return RandomItem.constant(result);
        }
        if (!element.isJsonObject()) {
            throw new JsonSyntaxException("Invalid RandomItem at '" + name + "', must be a string or an object");
        }
        JsonObject object2 = element.getAsJsonObject();
        if (object2.has("min")) {
            return RandomItem.range(result, JSONUtils.func_151203_m((JsonObject)object2, (String)"min"));
        }
        if (object2.has("chance")) {
            return RandomItem.chance(result, JSONUtils.func_151217_k((JsonObject)object2, (String)"chance"));
        }
        return RandomItem.constant(result);
    }

    public static RandomItem read(PacketBuffer buffer) {
        ItemOutput result = ItemOutput.read((PacketBuffer)buffer);
        RandomType type = (RandomType)buffer.func_179257_a(RandomType.class);
        switch (type) {
            case RANGE: {
                int min = buffer.func_150792_a();
                return RandomItem.range(result, min);
            }
            case CHANCE: {
                float chance = buffer.readFloat();
                return RandomItem.chance(result, chance);
            }
        }
        throw new DecoderException("Invalid random type " + (Object)((Object)type) + " for RandomItem");
    }

    private static enum RandomType {
        RANGE,
        CHANCE;

    }

    private static class Chance
    extends RandomItem {
        private final ItemOutput result;
        private final float chance;

        @Override
        public ItemStack get(Random random) {
            if (this.chance >= 1.0f || random.nextFloat() < this.chance) {
                return this.result.get().func_77946_l();
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public JsonElement serialize() {
            JsonObject object;
            JsonElement resultElement = this.result.serialize();
            if (this.chance >= 1.0f) {
                return resultElement;
            }
            if (resultElement.isJsonPrimitive()) {
                object = new JsonObject();
                object.add("item", resultElement);
            } else {
                object = resultElement.getAsJsonObject();
            }
            object.addProperty("chance", (Number)Float.valueOf(this.chance));
            return object;
        }

        @Override
        public void write(PacketBuffer buffer) {
            this.result.write(buffer);
            buffer.func_179249_a((Enum)RandomType.CHANCE);
            buffer.writeFloat(this.chance);
        }

        public Chance(ItemOutput result, float chance) {
            this.result = result;
            this.chance = chance;
        }
    }

    private static class Range
    extends RandomItem {
        private final ItemOutput result;
        private final int minCount;

        @Override
        public ItemStack get(Random random) {
            ItemStack result = this.result.get();
            int newCount = result.func_190916_E();
            if (result.func_190916_E() > this.minCount && (newCount = this.minCount + random.nextInt(result.func_190916_E() - this.minCount)) <= 0) {
                return ItemStack.field_190927_a;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)result, (int)newCount);
        }

        @Override
        public JsonElement serialize() {
            JsonObject object;
            JsonElement resultElement = this.result.serialize();
            if (resultElement.isJsonPrimitive()) {
                object = new JsonObject();
                object.add("item", resultElement);
            } else {
                object = resultElement.getAsJsonObject();
            }
            object.addProperty("min", (Number)this.minCount);
            object.addProperty("max", (Number)JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1));
            object.remove("count");
            return object;
        }

        @Override
        public void write(PacketBuffer buffer) {
            this.result.write(buffer);
            buffer.func_179249_a((Enum)RandomType.RANGE);
            buffer.func_150787_b(this.minCount);
        }

        public Range(ItemOutput result, int minCount) {
            this.result = result;
            this.minCount = minCount;
        }
    }
}

