/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.container;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.container.ContainerFillingRecipeSerializer;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class ContainerFillingRecipeBuilder
extends AbstractRecipeBuilder<ContainerFillingRecipeBuilder> {
    private final ResourceLocation result;
    private final int fluidAmount;
    private final ContainerFillingRecipeSerializer<?> recipeSerializer;

    public static ContainerFillingRecipeBuilder castingRecipe(IItemProvider result, int fluidAmount, ContainerFillingRecipeSerializer<?> recipeSerializer) {
        return new ContainerFillingRecipeBuilder(Objects.requireNonNull(result.func_199767_j().getRegistryName()), fluidAmount, recipeSerializer);
    }

    public static ContainerFillingRecipeBuilder basinRecipe(ResourceLocation result, int fluidAmount) {
        return ContainerFillingRecipeBuilder.castingRecipe(result, fluidAmount, (ContainerFillingRecipeSerializer)TinkerSmeltery.basinFillingRecipeSerializer.get());
    }

    public static ContainerFillingRecipeBuilder basinRecipe(IItemProvider result, int fluidAmount) {
        return ContainerFillingRecipeBuilder.castingRecipe(result, fluidAmount, (ContainerFillingRecipeSerializer)TinkerSmeltery.basinFillingRecipeSerializer.get());
    }

    public static ContainerFillingRecipeBuilder tableRecipe(ResourceLocation result, int fluidAmount) {
        return ContainerFillingRecipeBuilder.castingRecipe(result, fluidAmount, (ContainerFillingRecipeSerializer)TinkerSmeltery.tableFillingRecipeSerializer.get());
    }

    public static ContainerFillingRecipeBuilder tableRecipe(IItemProvider result, int fluidAmount) {
        return ContainerFillingRecipeBuilder.castingRecipe(result, fluidAmount, (ContainerFillingRecipeSerializer)TinkerSmeltery.tableFillingRecipeSerializer.get());
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.result);
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "casting");
        consumerIn.accept((IFinishedRecipe)new Result(id, advancementId));
    }

    private ContainerFillingRecipeBuilder(ResourceLocation result, int fluidAmount, ContainerFillingRecipeSerializer<?> recipeSerializer) {
        this.result = result;
        this.fluidAmount = fluidAmount;
        this.recipeSerializer = recipeSerializer;
    }

    public static ContainerFillingRecipeBuilder castingRecipe(ResourceLocation result, int fluidAmount, ContainerFillingRecipeSerializer<?> recipeSerializer) {
        return new ContainerFillingRecipeBuilder(result, fluidAmount, recipeSerializer);
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)ContainerFillingRecipeBuilder.this, ID, advancementID);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return ContainerFillingRecipeBuilder.this.recipeSerializer;
        }

        public void func_218610_a(JsonObject json) {
            if (!ContainerFillingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", ContainerFillingRecipeBuilder.this.group);
            }
            json.addProperty("fluid_amount", (Number)ContainerFillingRecipeBuilder.this.fluidAmount);
            json.addProperty("container", ContainerFillingRecipeBuilder.this.result.toString());
        }
    }
}

