/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.recipe.ICastingInventory;

public abstract class CompositeCastingRecipe
extends MaterialCastingRecipe {
    public CompositeCastingRecipe(IRecipeType<?> type, ResourceLocation id, String group, IMaterialItem result, int itemCost) {
        super(type, id, group, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{result}), itemCost, result, true, false);
    }

    @Override
    protected Optional<MaterialFluidRecipe> getMaterialFluid(ICastingInventory inv) {
        return MaterialCastingLookup.getCompositeFluid(inv);
    }

    @Override
    public List<IDisplayableCastingRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            IRecipeType<?> type = this.func_222127_g();
            this.multiRecipes = MaterialCastingLookup.getAllCompositeFluids().stream().filter(recipe -> {
                IMaterial output = recipe.getOutput();
                IMaterial input = recipe.getInput();
                return output != IMaterial.UNKNOWN && input != null && input != IMaterial.UNKNOWN && !output.isHidden() && !input.isHidden() && this.result.canUseMaterial(output) && this.result.canUseMaterial(input);
            }).map(recipe -> {
                List<FluidStack> fluids = this.resizeFluids(recipe.getFluids());
                int fluidAmount = fluids.stream().mapToInt(FluidStack::getAmount).max().orElse(0);
                return new DisplayCastingRecipe(type, Collections.singletonList(this.result.withMaterial(recipe.getInput())), fluids, this.result.withMaterial(recipe.getOutput()), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), this.itemCost * fluidAmount), this.consumed);
            }).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }

    public static class Serializer<T extends CompositeCastingRecipe>
    extends LoggingRecipeSerializer<T> {
        private final IFactory<T> factory;

        public T read(ResourceLocation id, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            IMaterialItem result = (IMaterialItem)RecipeHelper.deserializeItem((String)JSONUtils.func_151200_h((JsonObject)json, (String)"result"), (String)"result", IMaterialItem.class);
            int itemCost = JSONUtils.func_151203_m((JsonObject)json, (String)"item_cost");
            return this.factory.create(id, group, result, itemCost);
        }

        @Override
        @Nullable
        protected T readSafe(ResourceLocation id, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            IMaterialItem result = (IMaterialItem)RecipeHelper.readItem((PacketBuffer)buffer, IMaterialItem.class);
            int itemCost = buffer.func_150792_a();
            return this.factory.create(id, group, result, itemCost);
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, T recipe) {
            buffer.func_180714_a(((CompositeCastingRecipe)recipe).group);
            RecipeHelper.writeItem((PacketBuffer)buffer, (IItemProvider)((CompositeCastingRecipe)recipe).result);
            buffer.func_150787_b(((CompositeCastingRecipe)recipe).itemCost);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    public static interface IFactory<T extends CompositeCastingRecipe> {
        public T create(ResourceLocation var1, String var2, IMaterialItem var3, int var4);
    }

    public static class Table
    extends CompositeCastingRecipe {
        public Table(ResourceLocation id, String group, IMaterialItem result, int itemCost) {
            super(RecipeTypes.CASTING_TABLE, id, group, result, itemCost);
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)TinkerSmeltery.tableCompositeSerializer.get();
        }
    }

    public static class Basin
    extends CompositeCastingRecipe {
        public Basin(ResourceLocation id, String group, IMaterialItem result, int itemCost) {
            super(RecipeTypes.CASTING_BASIN, id, group, result, itemCost);
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)TinkerSmeltery.basinCompositeSerializer.get();
        }
    }
}

