/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.data.CompoundIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.tools.TinkerModifiers;

public abstract class AbstractModifierRecipeBuilder<T extends AbstractModifierRecipeBuilder<T>>
extends AbstractRecipeBuilder<T> {
    protected static final Lazy<Ingredient> DEFAULT_TOOL = Lazy.of(() -> Ingredient.func_199805_a(TinkerTags.Items.MODIFIABLE));
    protected static final Lazy<ModifierMatch> UNARMED_MODIFIER = Lazy.of(() -> ModifierMatch.entry((Modifier)TinkerModifiers.unarmed.get()));
    protected static final String UNARMED_ERROR = TConstruct.makeTranslationKey("recipe", "modifier.unarmed");
    protected final ModifierEntry result;
    protected Ingredient tools = Ingredient.field_193370_a;
    protected int maxToolSize = 16;
    protected SlotType slotType;
    protected int slots;
    protected int maxLevel = 0;
    protected ModifierMatch requirements = ModifierMatch.ALWAYS;
    protected String requirementsError = null;
    protected int salvageMinLevel = 1;
    protected int salvageMaxLevel = 0;
    protected boolean includeUnarmed = false;

    public T includeUnarmed() {
        this.includeUnarmed = true;
        return (T)((Object)this);
    }

    public T setTools(Ingredient tools) {
        return this.setTools(tools, 16);
    }

    public T setTools(Ingredient tools, int maxSize) {
        this.tools = tools;
        this.maxToolSize = maxSize;
        return (T)((Object)this);
    }

    public T setTools(ITag<Item> tag) {
        return this.setTools(Ingredient.func_199805_a(tag));
    }

    public T setRequirements(ModifierMatch requirements) {
        this.requirements = requirements;
        return (T)((Object)this);
    }

    public T setRequirementsError(String requirementsError) {
        this.requirementsError = requirementsError;
        return (T)((Object)this);
    }

    public T setMinSalvageLevel(int level) {
        if (level < 1) {
            throw new IllegalArgumentException("Min level must be greater than 0");
        }
        this.salvageMinLevel = level;
        return (T)((Object)this);
    }

    public T setSalvageLevelRange(int minLevel, int maxLevel) {
        this.setMinSalvageLevel(minLevel);
        if (maxLevel < minLevel) {
            throw new IllegalArgumentException("Max level must be grater than or equal to min level");
        }
        this.salvageMaxLevel = maxLevel;
        return (T)((Object)this);
    }

    public T setMaxLevel(int level) {
        if (level < 1) {
            throw new IllegalArgumentException("Max level must be greater than 0");
        }
        this.maxLevel = level;
        return (T)((Object)this);
    }

    public T setSlots(SlotType slotType, int slots) {
        if (slots < 0) {
            throw new IllegalArgumentException("Slots must be positive");
        }
        this.slotType = slotType;
        this.slots = slots;
        return (T)((Object)this);
    }

    @Deprecated
    public T setUpgradeSlots(int slots) {
        return this.setSlots(SlotType.UPGRADE, slots);
    }

    public T setAbilitySlots(int slots) {
        return this.setSlots(SlotType.ABILITY, slots);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.result.getModifier().getId());
    }

    public abstract T buildSalvage(Consumer<IFinishedRecipe> var1, ResourceLocation var2);

    private void writeCommon(JsonObject json, @Nullable Boolean unarmed) {
        Ingredient ingredient = this.tools;
        if (this.tools == Ingredient.field_193370_a) {
            ingredient = (Ingredient)DEFAULT_TOOL.get();
        }
        if (unarmed == Boolean.TRUE) {
            ingredient = Ingredient.func_199805_a(TinkerTags.Items.CHESTPLATES);
        } else if (unarmed == null) {
            ingredient = CompoundIngredient.from((Ingredient[])new Ingredient[]{ingredient, Ingredient.func_199805_a(TinkerTags.Items.CHESTPLATES)});
        }
        json.add("tools", ingredient.func_200304_c());
        if (this.maxToolSize != 16) {
            json.addProperty("max_tool_size", (Number)this.maxToolSize);
        }
        if (this.slotType != null && this.slots > 0) {
            JsonObject slotJson = new JsonObject();
            slotJson.addProperty(this.slotType.getName(), (Number)this.slots);
            json.add("slots", (JsonElement)slotJson);
        }
    }

    protected AbstractModifierRecipeBuilder(ModifierEntry result) {
        this.result = result;
    }

    protected abstract class SalvageFinishedRecipe
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public SalvageFinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)AbstractModifierRecipeBuilder.this, ID, advancementID);
        }

        public void func_218610_a(JsonObject json) {
            AbstractModifierRecipeBuilder.this.writeCommon(json, AbstractModifierRecipeBuilder.this.includeUnarmed ? null : Boolean.valueOf(false));
            json.addProperty("modifier", AbstractModifierRecipeBuilder.this.result.getModifier().getId().toString());
            json.addProperty("min_level", (Number)AbstractModifierRecipeBuilder.this.salvageMinLevel);
            if (AbstractModifierRecipeBuilder.this.salvageMaxLevel != 0) {
                json.addProperty("max_level", (Number)AbstractModifierRecipeBuilder.this.salvageMaxLevel);
            }
        }
    }

    protected abstract class ModifierFinishedRecipe
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        private final boolean withUnarmed;

        public ModifierFinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID, boolean withUnarmed) {
            super((AbstractRecipeBuilder)AbstractModifierRecipeBuilder.this, ID, advancementID);
            this.withUnarmed = withUnarmed;
        }

        public ModifierFinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            this(ID, advancementID, false);
        }

        public void func_218610_a(JsonObject json) {
            AbstractModifierRecipeBuilder.this.writeCommon(json, this.withUnarmed);
            if (this.withUnarmed) {
                JsonObject reqJson = ((ModifierMatch)UNARMED_MODIFIER.get()).serialize();
                reqJson.addProperty("error", UNARMED_ERROR);
                json.add("requirements", (JsonElement)reqJson);
            } else if (AbstractModifierRecipeBuilder.this.requirements != ModifierMatch.ALWAYS) {
                JsonObject reqJson = AbstractModifierRecipeBuilder.this.requirements.serialize();
                reqJson.addProperty("error", AbstractModifierRecipeBuilder.this.requirementsError);
                json.add("requirements", (JsonElement)reqJson);
            }
            json.add("result", (JsonElement)AbstractModifierRecipeBuilder.this.result.toJson());
            if (AbstractModifierRecipeBuilder.this.maxLevel != 0) {
                json.addProperty("max_level", (Number)AbstractModifierRecipeBuilder.this.maxLevel);
            }
        }
    }
}

