/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.BitSet;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRecipe
extends AbstractModifierRecipe {
    protected final List<SizedIngredient> inputs;

    @Deprecated
    public ModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, int upgradeSlots, int abilitySlots) {
        super(id, toolRequirement, requirements, requirementsError, result, maxLevel, upgradeSlots, abilitySlots);
        this.inputs = inputs;
        for (SizedIngredient ingredient : inputs) {
            ModifierRecipeLookup.addIngredient(ingredient);
        }
    }

    public ModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
        this(id, inputs, toolRequirement, 16, requirements, requirementsError, result, maxLevel, slots);
    }

    public ModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
        super(id, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots);
        this.inputs = inputs;
        for (SizedIngredient ingredient : inputs) {
            ModifierRecipeLookup.addIngredient(ingredient);
        }
    }

    private static BitSet makeBitset(ITinkerStationInventory inv) {
        int inputs = inv.getInputCount();
        BitSet used = new BitSet(inputs);
        for (int i = 0; i < inputs; ++i) {
            if (!inv.getInput(i).func_190926_b()) continue;
            used.set(i);
        }
        return used;
    }

    private static int findMatch(SizedIngredient ingredient, ITinkerStationInventory inv, BitSet used) {
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack;
            if (used.get(i) || !ingredient.test(stack = inv.getInput(i))) continue;
            used.set(i);
            return i;
        }
        return -1;
    }

    @Override
    public boolean matches(ITinkerStationInventory inv, World world) {
        if (!this.toolRequirement.test(inv.getTinkerableStack())) {
            return false;
        }
        BitSet used = ModifierRecipe.makeBitset(inv);
        for (SizedIngredient ingredient : this.inputs) {
            int index = ModifierRecipe.findMatch(ingredient, inv, used);
            if (index != -1) continue;
            return false;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            if (used.get(i) || inv.getInput(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationInventory inv) {
        ItemStack tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        ValidatedResult commonError = this.validatePrerequisites(tool);
        if (commonError.hasError()) {
            return commonError;
        }
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        SlotType.SlotCount slots = this.getSlots();
        if (slots != null) {
            persistentData.addSlots(slots.getType(), -slots.getCount());
        }
        tool.addModifier(this.result.getModifier(), this.result.getLevel());
        ValidatedResult toolValidation = tool.validate();
        if (toolValidation.hasError()) {
            return toolValidation;
        }
        return ValidatedResult.success(tool.createStack(Math.min(tinkerable.func_190916_E(), this.shrinkToolSlotBy())));
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationInventory inv) {
        BitSet used = ModifierRecipe.makeBitset(inv);
        for (SizedIngredient ingredient : this.inputs) {
            int index = ModifierRecipe.findMatch(ingredient, inv, used);
            if (index != -1) {
                inv.shrinkInput(index, ingredient.getAmountNeeded());
                continue;
            }
            TConstruct.LOG.warn("Missing ingredient in modifier recipe input consume");
        }
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerModifiers.modifierSerializer.get();
    }

    @Override
    protected void addIngredients(Consumer<List<ItemStack>> builder) {
        for (SizedIngredient ingredient : this.inputs) {
            builder.accept(ingredient.getMatchingStacks());
        }
    }

    public static class Serializer
    extends AbstractModifierRecipe.Serializer<ModifierRecipe> {
        @Override
        public ModifierRecipe read(ResourceLocation id, JsonObject json, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            List ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            return new ModifierRecipe(id, (List<SizedIngredient>)ingredients, toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots);
        }

        @Override
        public ModifierRecipe read(ResourceLocation id, PacketBuffer buffer, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            int size = buffer.func_150792_a();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)SizedIngredient.read((PacketBuffer)buffer));
            }
            return new ModifierRecipe(id, (List<SizedIngredient>)builder.build(), toolRequirement, maxToolSize, requirements, requirementsError, result, maxLevel, slots);
        }

        @Override
        public ModifierRecipe read(ResourceLocation id, JsonObject json, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, int upgradeSlots, int abilitySlots) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ModifierRecipe read(ResourceLocation id, PacketBuffer buffer, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, int upgradeSlots, int abilitySlots) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, ModifierRecipe recipe) {
            super.writeSafe(buffer, recipe);
            buffer.func_150787_b(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
        }
    }
}

