/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.TinkerRegistries;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;

public class ModifierRepairRecipeSerializer<T extends IRecipe<?> & IModifierRepairRecipe>
extends LoggingRecipeSerializer<T> {
    private final IFactory<T> factory;

    public T func_199425_a_(ResourceLocation id, JsonObject json) {
        Modifier modifier = ModifierEntry.deserializeModifier(json, "modifier");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
        int repairAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"repair_amount");
        return this.factory.create(id, modifier, ingredient, repairAmount);
    }

    @Override
    @Nullable
    protected T readSafe(ResourceLocation id, PacketBuffer buffer) {
        Modifier modifier = (Modifier)buffer.readRegistryIdUnsafe(TinkerRegistries.MODIFIERS);
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        int repairAmount = buffer.func_150792_a();
        return this.factory.create(id, modifier, ingredient, repairAmount);
    }

    @Override
    protected void writeSafe(PacketBuffer buffer, T recipe) {
        buffer.writeRegistryIdUnsafe(TinkerRegistries.MODIFIERS, (IForgeRegistryEntry)((IModifierRepairRecipe)recipe).getModifier());
        ((IModifierRepairRecipe)recipe).getIngredient().func_199564_a(buffer);
        buffer.func_150787_b(((IModifierRepairRecipe)recipe).getRepairAmount());
    }

    public ModifierRepairRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    @FunctionalInterface
    public static interface IFactory<T extends IRecipe<?> & IModifierRepairRecipe> {
        public T create(ResourceLocation var1, Modifier var2, Ingredient var3, int var4);
    }

    public static interface IModifierRepairRecipe {
        public Modifier getModifier();

        public Ingredient getIngredient();

        public int getRepairAmount();
    }
}

