/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import slimeknights.tconstruct.TConstruct;

public class TinkerDataCapability
implements Capability.IStorage<Holder> {
    private static final ResourceLocation ID = TConstruct.getResource("modifier_data");
    private static final TinkerDataCapability INSTANCE = new TinkerDataCapability();
    @CapabilityInject(value=Holder.class)
    public static Capability<Holder> CAPABILITY = null;

    private TinkerDataCapability() {
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(Holder.class, (Capability.IStorage)INSTANCE, Holder::new);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, TinkerDataCapability::attachCapability);
    }

    private static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            Provider provider = new Provider();
            event.addCapability(ID, (ICapabilityProvider)provider);
            event.addListener((Runnable)provider);
        }
    }

    @Nullable
    public INBT writeNBT(Capability<Holder> capability, Holder instance, Direction side) {
        return null;
    }

    public void readNBT(Capability<Holder> capability, Holder instance, Direction side, INBT nbt) {
    }

    public static class Holder {
        private final Map<TinkerDataKey<?>, Object> data = new IdentityHashMap();

        public <T> void put(TinkerDataKey<T> key, T value) {
            this.data.put(key, value);
        }

        public void remove(TinkerDataKey<?> key) {
            this.data.remove(key);
        }

        public <S, T extends S> S get(TinkerDataKey<T> key, S defaultValue) {
            return (S)this.data.getOrDefault(key, defaultValue);
        }

        @Nullable
        public <T> T get(TinkerDataKey<T> key) {
            return (T)this.data.get(key);
        }

        public <T, U extends TinkerDataKey<T>> T computeIfAbsent(U key) {
            return (T)this.data.computeIfAbsent(key, (Function)((Object)key));
        }

        public boolean contains(TinkerDataKey<?> key) {
            return this.data.containsKey(key);
        }
    }

    public static class ComputableDataKey<T>
    extends TinkerDataKey<T>
    implements Function<TinkerDataKey<?>, T> {
        private final Supplier<T> constructor;

        private ComputableDataKey(ResourceLocation name, Supplier<T> constructor) {
            super(name);
            this.constructor = constructor;
        }

        public static <T> ComputableDataKey<T> of(ResourceLocation name, Supplier<T> constructor) {
            return new ComputableDataKey<T>(name, constructor);
        }

        @Override
        public T apply(TinkerDataKey<?> tinkerDataKey) {
            return this.constructor.get();
        }
    }

    public static class TinkerDataKey<T> {
        private final ResourceLocation name;

        public String toString() {
            return "TinkerDataKey{" + this.name + '}';
        }

        private TinkerDataKey(ResourceLocation name) {
            this.name = name;
        }

        public static <T> TinkerDataKey<T> of(ResourceLocation name) {
            return new TinkerDataKey<T>(name);
        }
    }

    private static class Provider
    implements ICapabilityProvider,
    Runnable {
        private LazyOptional<Holder> data = LazyOptional.of(Holder::new);

        private Provider() {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
            return CAPABILITY.orEmpty(cap, this.data);
        }

        @Override
        public void run() {
            this.data.invalidate();
            this.data = LazyOptional.of(Holder::new);
        }
    }
}

