/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.definition.DefinitionModifierSlots;
import slimeknights.tconstruct.library.tools.definition.DefinitionToolStats;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;

public class ToolDefinitionDataBuilder {
    private final ImmutableList.Builder<PartRequirement> parts = ImmutableList.builder();
    private final DefinitionToolStats.Builder bonuses = DefinitionToolStats.builder();
    private final DefinitionToolStats.Builder multipliers = DefinitionToolStats.builder();
    private final DefinitionModifierSlots.Builder slots = DefinitionModifierSlots.builder();
    private final ImmutableList.Builder<ModifierEntry> traits = ImmutableList.builder();

    public ToolDefinitionDataBuilder part(IToolPart part, int weight) {
        this.parts.add((Object)PartRequirement.ofPart(part, weight));
        return this;
    }

    public ToolDefinitionDataBuilder part(MaterialStatsId stat, int weight) {
        this.parts.add((Object)PartRequirement.ofStat(stat, weight));
        return this;
    }

    public ToolDefinitionDataBuilder part(Supplier<? extends IToolPart> part, int weight) {
        return this.part(part.get(), weight);
    }

    public ToolDefinitionDataBuilder part(IToolPart part) {
        return this.part(part, 1);
    }

    public ToolDefinitionDataBuilder part(Supplier<? extends IToolPart> part) {
        return this.part(part, 1);
    }

    public ToolDefinitionDataBuilder stat(FloatToolStat stat, float value) {
        this.bonuses.addStat(stat, value);
        return this;
    }

    public ToolDefinitionDataBuilder multiplier(FloatToolStat stat, float value) {
        this.multipliers.addStat(stat, value);
        return this;
    }

    public ToolDefinitionDataBuilder startingSlots(SlotType slotType, int value) {
        this.slots.setSlots(slotType, value);
        return this;
    }

    public ToolDefinitionDataBuilder smallToolStartingSlots() {
        this.startingSlots(SlotType.UPGRADE, 3);
        this.startingSlots(SlotType.ABILITY, 1);
        return this;
    }

    public ToolDefinitionDataBuilder largeToolStartingSlots() {
        this.startingSlots(SlotType.UPGRADE, 2);
        this.startingSlots(SlotType.ABILITY, 1);
        return this;
    }

    public ToolDefinitionDataBuilder trait(Modifier modifier, int level) {
        this.traits.add((Object)new ModifierEntry(modifier, level));
        return this;
    }

    public ToolDefinitionDataBuilder trait(Supplier<? extends Modifier> modifier, int level) {
        return this.trait(modifier.get(), level);
    }

    public ToolDefinitionDataBuilder trait(Modifier modifier) {
        return this.trait(modifier, 1);
    }

    public ToolDefinitionDataBuilder trait(Supplier<? extends Modifier> modifier) {
        return this.trait(modifier, 1);
    }

    public ToolDefinitionData build() {
        ImmutableList parts = this.parts.build();
        DefinitionToolStats multipliers = this.multipliers.build();
        ImmutableList traits = this.traits.build();
        return new ToolDefinitionData((List<PartRequirement>)(parts.isEmpty() ? null : parts), new ToolDefinitionData.Stats(this.bonuses.build(), multipliers.containedStats().isEmpty() ? null : multipliers), this.slots.build(), (List<ModifierEntry>)(traits.isEmpty() ? null : traits));
    }

    private ToolDefinitionDataBuilder() {
    }

    public static ToolDefinitionDataBuilder builder() {
        return new ToolDefinitionDataBuilder();
    }
}

