/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;

public interface ITinkerStationDisplay
extends IItemProvider {
    default public ITextComponent getLocalizedName() {
        return new TranslationTextComponent(this.func_199767_j().func_77658_a());
    }

    @Deprecated
    default public List<ITextComponent> getStatInformation(IModifierToolStack tool, List<ITextComponent> tooltips, TooltipFlag tooltipFlag) {
        return this.getStatInformation(tool, null, tooltips, TooltipKey.NORMAL, tooltipFlag);
    }

    default public List<ITextComponent> getStatInformation(IModifierToolStack tool, @Nullable PlayerEntity player, List<ITextComponent> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        tooltips = TooltipUtil.getDefaultStats(tool, player, tooltips, key, tooltipFlag);
        TooltipUtil.addAttributes(this, tool, player, tooltips, TooltipUtil.SHOW_MELEE_ATTRIBUTES, EquipmentSlotType.MAINHAND);
        return tooltips;
    }

    default public Multimap<Attribute, AttributeModifier> getAttributeModifiers(IModifierToolStack tool, EquipmentSlotType slot) {
        return ImmutableMultimap.of();
    }

    @Deprecated
    public static ITextComponent getCombinedItemName(ITextComponent itemName, Collection<IMaterial> materials) {
        return ITinkerStationDisplay.getCombinedItemName(ItemStack.field_190927_a, itemName, materials);
    }

    public static ITextComponent getCombinedItemName(ItemStack stack, ITextComponent itemName, Collection<IMaterial> materials) {
        block9: {
            block8: {
                if (materials.isEmpty()) break block8;
                if (!materials.stream().allMatch(IMaterial.UNKNOWN::equals)) break block9;
            }
            return itemName;
        }
        if (materials.size() == 1) {
            IMaterial material = materials.iterator().next();
            if (!stack.func_190926_b()) {
                MaterialId id = material.getIdentifier();
                String key = stack.func_77977_a() + ".material." + id.func_110624_b() + "." + id.func_110623_a();
                if (Util.canTranslate(key)) {
                    return new TranslationTextComponent(key);
                }
            }
            if (Util.canTranslate(material.getTranslationKey() + ".format")) {
                return new TranslationTextComponent(material.getTranslationKey() + ".format", new Object[]{itemName});
            }
            return new TranslationTextComponent(materials.iterator().next().getTranslationKey()).func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_(itemName);
        }
        StringTextComponent name = new StringTextComponent("");
        Iterator<IMaterial> iter = materials.iterator();
        IMaterial material = iter.next();
        name.func_230529_a_((ITextComponent)new TranslationTextComponent(material.getTranslationKey()));
        while (iter.hasNext()) {
            material = iter.next();
            name.func_240702_b_("-").func_230529_a_((ITextComponent)new TranslationTextComponent(material.getTranslationKey()));
        }
        name.func_240702_b_(" ").func_230529_a_(itemName);
        return name;
    }
}

