/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.item.IModifiableWeapon;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;

public class ModifiableItem
extends Item
implements IModifiableDisplay,
IModifiableWeapon {
    protected static final UUID REACH_MODIFIER = UUID.fromString("9b26fa32-5774-4b4e-afc3-b4055ecb1f6a");
    private final ToolDefinition toolDefinition;
    private ItemStack toolForRendering;

    public ModifiableItem(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties);
        this.toolDefinition = toolDefinition;
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.func_190936_d() && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ToolCapabilityProvider(stack);
    }

    public boolean func_179215_a(CompoundNBT nbt) {
        ToolStack.verifyTag(this, nbt, this.getToolDefinition());
        return true;
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        ToolStack.ensureInitialized(stack, this.getToolDefinition());
    }

    public boolean func_77636_d(ItemStack stack) {
        return ModifierUtil.checkVolatileFlag(stack, SHINY);
    }

    public Rarity func_77613_e(ItemStack stack) {
        int rarity = ModifierUtil.getVolatileInt(stack, RARITY);
        return Rarity.values()[MathHelper.func_76125_a((int)rarity, (int)0, (int)3)];
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return IndestructibleItemEntity.hasCustomEntity(stack);
    }

    public Entity createEntity(World world, Entity original, ItemStack stack) {
        return IndestructibleItemEntity.createFrom(world, original, stack);
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean func_77645_m() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        if (!this.func_77645_m()) {
            return 0;
        }
        ToolStack tool = ToolStack.from(stack);
        int durability = tool.getStats().getInt(ToolStats.DURABILITY);
        return tool.isBroken() ? durability + 1 : durability;
    }

    public int getDamage(ItemStack stack) {
        if (!this.func_77645_m()) {
            return 0;
        }
        return ToolStack.from(stack).getDamage();
    }

    public void setDamage(ItemStack stack, int damage) {
        if (this.func_77645_m()) {
            ToolStack.from(stack).setDamage(damage);
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T damager, Consumer<T> onBroken) {
        if (this.func_77645_m() && ToolDamageUtil.damage(ToolStack.from(stack), amount, damager, stack)) {
            onBroken.accept(damager);
        }
        return 0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ToolDamageUtil.showDurabilityBar(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ToolDamageUtil.getDamageForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ToolDamageUtil.getRGBDurabilityForDisplay(stack);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        return ToolAttackUtil.attackEntity(stack, this, player, entity);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(IModifierToolStack tool, EquipmentSlotType slot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (!tool.isBroken()) {
            if (slot == EquipmentSlotType.MAINHAND) {
                StatsNBT statsNBT = tool.getStats();
                builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "tconstruct.tool.attack_damage", (double)statsNBT.getFloat(ToolStats.ATTACK_DAMAGE), AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "tconstruct.tool.attack_speed", (double)statsNBT.getFloat(ToolStats.ATTACK_SPEED) - 4.0, AttributeModifier.Operation.ADDITION));
            }
            if (slot.func_188453_a() == EquipmentSlotType.Group.HAND) {
                BiConsumer<Attribute, AttributeModifier> attributeConsumer = (arg_0, arg_1) -> ((ImmutableMultimap.Builder)builder).put(arg_0, arg_1);
                for (ModifierEntry entry : tool.getModifierList()) {
                    entry.getModifier().addAttributes(tool, entry.getLevel(), slot, attributeConsumer);
                }
            }
        }
        return builder.build();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || slot.func_188453_a() != EquipmentSlotType.Group.HAND) {
            return ImmutableMultimap.of();
        }
        return this.getAttributeModifiers(ToolStack.from(stack), slot);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn instanceof LivingEntity) {
            List<ModifierEntry> modifiers;
            ToolStack tool = ToolStack.from(stack);
            if (!worldIn.field_72995_K) {
                tool.ensureHasData();
            }
            if (!(modifiers = tool.getModifierList()).isEmpty()) {
                LivingEntity living = (LivingEntity)entityIn;
                boolean isHeld = isSelected || living.func_184592_cb() == stack;
                for (ModifierEntry entry : modifiers) {
                    entry.getModifier().onInventoryTick(tool, entry.getLevel(), worldIn, living, itemSlot, isSelected, isHeld, stack);
                }
            }
        }
    }

    protected static boolean shouldInteract(@Nullable LivingEntity player, ToolStack toolStack, Hand hand) {
        IModDataReadOnly volatileData = toolStack.getVolatileData();
        if (volatileData.getBoolean(NO_INTERACTION)) {
            return false;
        }
        return hand == Hand.OFF_HAND || player == null || !volatileData.getBoolean(DEFER_OFFHAND) || player.func_184592_cb().func_190926_b();
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        ToolStack tool = ToolStack.from(stack);
        Hand hand = context.func_221531_n();
        if (ModifiableItem.shouldInteract((LivingEntity)context.func_195999_j(), tool, hand)) {
            EquipmentSlotType slot = Util.getSlotType(hand);
            for (ModifierEntry entry : tool.getModifierList()) {
                ActionResultType result = entry.getModifier().beforeBlockUse(tool, entry.getLevel(), context, slot);
                if (!result.func_226246_a_()) continue;
                return result;
            }
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ToolStack tool = ToolStack.from(context.func_195996_i());
        Hand hand = context.func_221531_n();
        if (ModifiableItem.shouldInteract((LivingEntity)context.func_195999_j(), tool, hand)) {
            EquipmentSlotType slot = Util.getSlotType(hand);
            for (ModifierEntry entry : tool.getModifierList()) {
                ActionResultType result = entry.getModifier().afterBlockUse(tool, entry.getLevel(), context, slot);
                if (!result.func_226246_a_()) continue;
                return result;
            }
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        ToolStack tool = ToolStack.from(stack);
        if (ModifiableItem.shouldInteract((LivingEntity)playerIn, tool, hand)) {
            EquipmentSlotType slot = Util.getSlotType(hand);
            for (ModifierEntry entry : tool.getModifierList()) {
                ActionResultType result = entry.getModifier().afterEntityUse(tool, entry.getLevel(), playerIn, target, hand, slot);
                if (!result.func_226246_a_()) continue;
                return result;
            }
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        ToolStack tool = ToolStack.from(playerIn.func_184586_b(hand));
        if (ModifiableItem.shouldInteract((LivingEntity)playerIn, tool, hand)) {
            EquipmentSlotType slot = Util.getSlotType(hand);
            for (ModifierEntry entry : tool.getModifierList()) {
                ActionResultType result = entry.getModifier().onToolUse(tool, entry.getLevel(), worldIn, playerIn, hand, slot);
                if (!result.func_226246_a_()) continue;
                return new ActionResult(result, (Object)stack);
            }
        }
        ActionResultType result = ToolInventoryCapability.tryOpenContainer(stack, tool, playerIn, Util.getSlotType(hand));
        return new ActionResult(result, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            if (!entry.getModifier().onFinishUsing(tool, entry.getLevel(), worldIn, entityLiving)) continue;
            return stack;
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            boolean result = entry.getModifier().onStoppedUsing(tool, entry.getLevel(), worldIn, entityLiving, timeLeft);
            if (!result) continue;
            return;
        }
    }

    public int func_77626_a(ItemStack stack) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            int result = entry.getModifier().getUseDuration(tool, entry.getLevel());
            if (result <= 0) continue;
            return result;
        }
        return 0;
    }

    public UseAction func_77661_b(ItemStack stack) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            UseAction result = entry.getModifier().getUseAction(tool, entry.getLevel());
            if (result == UseAction.NONE) continue;
            return result;
        }
        return UseAction.NONE;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return TooltipUtil.getDisplayName(stack, this.getToolDefinition());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TooltipUtil.addInformation((IModifiableDisplay)this, stack, worldIn, tooltip, TooltipKey.fromScreen(), flagIn);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ToolBuildHandler.addDefaultSubItems(this, items, new IMaterial[0]);
        }
    }

    @Override
    public ItemStack getRenderTool() {
        if (this.toolForRendering == null) {
            this.toolForRendering = ToolBuildHandler.buildToolForRendering(this, this.getToolDefinition());
        }
        return this.toolForRendering;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return this.shouldCauseReequipAnimation(oldStack, newStack, false);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack == newStack) {
            return false;
        }
        if (slotChanged || oldStack.func_77973_b() != newStack.func_77973_b()) {
            return true;
        }
        ToolStack oldTool = ToolStack.from(oldStack);
        ToolStack newTool = ToolStack.from(newStack);
        if (!oldTool.getMaterialsList().equals(newTool.getMaterialsList())) {
            return true;
        }
        if (!oldTool.getModifierList().equals(newTool.getModifierList())) {
            return true;
        }
        Multimap attributesNew = newStack.func_111283_C(EquipmentSlotType.MAINHAND);
        Multimap attributesOld = oldStack.func_111283_C(EquipmentSlotType.MAINHAND);
        if (attributesNew.size() != attributesOld.size()) {
            return true;
        }
        for (Attribute attribute : attributesOld.keySet()) {
            if (!attributesNew.containsKey((Object)attribute)) {
                return true;
            }
            Iterator iter1 = attributesNew.get((Object)attribute).iterator();
            Iterator iter2 = attributesOld.get((Object)attribute).iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                if (((AttributeModifier)iter1.next()).equals(iter2.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static BlockRayTraceResult blockRayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        return Item.func_219968_a((World)worldIn, (PlayerEntity)player, (RayTraceContext.FluidMode)fluidMode);
    }

    @Override
    public ToolDefinition getToolDefinition() {
        return this.toolDefinition;
    }
}

