/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.TierToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.utils.HarvestLevels;

public class ToolStats {
    private static final Map<ToolStatId, IToolStat<?>> ALL_STATS = new HashMap();
    public static final FloatToolStat DURABILITY = ToolStats.register(new FloatToolStat(ToolStats.name("durability"), -12071865, 1.0f, 1.0f, 2.1474836E9f));
    public static final FloatToolStat ATTACK_DAMAGE = ToolStats.register(new FloatToolStat(ToolStats.name("attack_damage"), -2661276, 0.0f, 0.0f, 2048.0f));
    public static final FloatToolStat ATTACK_SPEED = ToolStats.register(new FloatToolStat(ToolStats.name("attack_speed"), -8042548, 1.0f, 0.0f, 1024.0f));
    public static final FloatToolStat MINING_SPEED = ToolStats.register(new FloatToolStat(ToolStats.name("mining_speed"), -8871731, 1.0f, 0.0f, 2048.0f));
    public static final TierToolStat HARVEST_LEVEL = ToolStats.register(new TierToolStat(ToolStats.name("harvest_level"), 0, HarvestLevels::getHarvestLevelName));
    public static final FloatToolStat SECONDARY_MINING = ToolStats.register(new FloatToolStat(ToolStats.name("secondary_mining"), -8871731, 1.0f, 0.0f, 10.0f));
    public static final FloatToolStat ARMOR = ToolStats.register(new FloatToolStat(ToolStats.name("armor"), -8042548, 0.0f, 0.0f, 30.0f));
    public static final FloatToolStat ARMOR_TOUGHNESS = ToolStats.register(new FloatToolStat(ToolStats.name("armor_toughness"), -8042548, 0.0f, 0.0f, 20.0f));
    public static final FloatToolStat KNOCKBACK_RESISTANCE = ToolStats.register(new FloatToolStat(ToolStats.name("knockback_resistance"), -8042548, 0.0f, 0.0f, 1.0f));

    @Nullable
    public static IToolStat<?> getToolStat(ToolStatId name) {
        return ALL_STATS.get((Object)name);
    }

    public static <T extends IToolStat<?>> T register(T toolStat) {
        if (ALL_STATS.containsKey((Object)toolStat.getName())) {
            throw new IllegalArgumentException("Attempt to register duplicate tool stat " + (Object)((Object)toolStat.getName()));
        }
        ALL_STATS.put(toolStat.getName(), toolStat);
        return toolStat;
    }

    public static Collection<IToolStat<?>> getAllStats() {
        return ALL_STATS.values();
    }

    private static ToolStatId name(String name) {
        return new ToolStatId("tconstruct", name);
    }
}

