/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;

public class ToolStatsBuilder {
    protected final ToolDefinitionData toolData;

    public static ToolStatsBuilder noParts(ToolDefinition definition) {
        return new ToolStatsBuilder(definition.getData());
    }

    protected void setStats(StatsNBT.Builder builder) {
    }

    protected boolean handles(IToolStat<?> stat) {
        return false;
    }

    public StatsNBT buildStats() {
        StatsNBT.Builder builder = StatsNBT.builder();
        for (FloatToolStat stat : this.toolData.getAllBaseStats()) {
            if (this.handles(stat)) continue;
            builder.set(stat, this.toolData.getBaseStat(stat));
        }
        this.setStats(builder);
        return builder.build();
    }

    @Nullable
    public static <T extends IMaterialStats> T fetchStatsOrDefault(IMaterial material, MaterialStatsId statsId) {
        return (T)MaterialRegistry.getInstance().getMaterialStats(material.getIdentifier(), statsId).orElseGet(() -> MaterialRegistry.getInstance().getDefaultStats(statsId));
    }

    public static <T extends IMaterialStats> List<T> listOfCompatibleWith(MaterialStatsId statsId, List<IMaterial> materials, List<PartRequirement> parts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int size = parts.size();
        for (int i = 0; i < size; ++i) {
            T stats;
            PartRequirement part = parts.get(i);
            if (!part.getStatType().equals((Object)statsId) || (stats = ToolStatsBuilder.fetchStatsOrDefault(materials.get(i), part.getStatType())) == null) continue;
            for (int w = 0; w < part.getWeight(); ++w) {
                builder.add(stats);
            }
        }
        return builder.build();
    }

    public static <T extends IMaterialStats> double getAverageValue(List<T> stats, Function<T, ? extends Number> statGetter) {
        return ToolStatsBuilder.getAverageValue(stats, statGetter, 0.0);
    }

    public static <T extends IMaterialStats, N extends Number> double getAverageValue(List<T> stats, Function<T, N> statGetter, double missingValue) {
        return stats.stream().mapToDouble(value -> ((Number)statGetter.apply(value)).doubleValue()).average().orElse(missingValue);
    }

    protected ToolStatsBuilder(ToolDefinitionData toolData) {
        this.toolData = toolData;
    }
}

