/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class BlockSideHitListener {
    private static final Map<UUID, Direction> HIT_FACE = new HashMap<UUID, Direction>();
    private static boolean init = false;

    public static void init() {
        if (init) {
            return;
        }
        init = true;
        MinecraftForge.EVENT_BUS.addListener(BlockSideHitListener::onLeftClickBlock);
        MinecraftForge.EVENT_BUS.addListener(BlockSideHitListener::onLeaveServer);
    }

    private static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        HIT_FACE.put(event.getPlayer().func_110124_au(), event.getFace());
    }

    private static void onLeaveServer(PlayerEvent.PlayerLoggedOutEvent event) {
        HIT_FACE.remove(event.getPlayer().func_110124_au());
    }

    public static Direction getSideHit(PlayerEntity player) {
        return HIT_FACE.getOrDefault(player.func_110124_au(), Direction.UP);
    }
}

