/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.library.utils.Util;

public class RomanNumeralHelper {
    private static String TRANSLATION_KEY_PREFIX = "roman_numeral.value.";
    private static Int2ObjectMap<ITextComponent> NUMERAL_CACHE = new Int2ObjectOpenHashMap();

    private RomanNumeralHelper() {
    }

    private static String intToRomanNumeral(int value) {
        if (value < 1) {
            return Integer.toString(value);
        }
        StringBuilder builder = new StringBuilder();
        while (value >= 1000) {
            builder.append('M');
            value -= 1000;
        }
        if (value >= 900) {
            builder.append("CM");
            value -= 900;
        }
        if (value >= 500) {
            builder.append('D');
            value -= 500;
        }
        if (value >= 400) {
            builder.append("CD");
            value -= 400;
        }
        while (value >= 100) {
            builder.append('C');
            value -= 100;
        }
        if (value >= 90) {
            builder.append("XC");
            value -= 90;
        }
        if (value >= 50) {
            builder.append('L');
            value -= 50;
        }
        if (value >= 40) {
            builder.append("XL");
            value -= 40;
        }
        while (value >= 10) {
            builder.append('X');
            value -= 10;
        }
        if (value >= 9) {
            builder.append("IX");
            value -= 9;
        }
        if (value >= 5) {
            builder.append('V');
            value -= 5;
        }
        if (value >= 4) {
            builder.append("IV");
            value -= 4;
        }
        while (value >= 1) {
            builder.append('I');
            --value;
        }
        return builder.toString();
    }

    public static ITextComponent getNumeral(int value) {
        if (NUMERAL_CACHE.containsKey(value)) {
            return (ITextComponent)NUMERAL_CACHE.get(value);
        }
        String key = TRANSLATION_KEY_PREFIX + value;
        Object component = Util.canTranslate(key) ? new TranslationTextComponent(key) : new StringTextComponent(RomanNumeralHelper.intToRomanNumeral(value));
        NUMERAL_CACHE.put(value, component);
        return component;
    }
}

