/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.plugin.jei.entity.EntityMeltingRecipeCategory;

public class EntityIngredientRenderer
implements IIngredientRenderer<EntityType> {
    private static final Set<EntityType<?>> IGNORED_ENTITIES = new HashSet();
    private final int size;
    private final Map<EntityType<?>, Entity> ENTITY_MAP = new HashMap();

    public void render(MatrixStack matrixStack, int x, int y, @Nullable EntityType type) {
        if (type != null) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && !IGNORED_ENTITIES.contains(type)) {
                Object entity = type == EntityType.field_200729_aH ? Minecraft.func_71410_x().field_71439_g : this.ENTITY_MAP.computeIfAbsent(type, arg_0 -> EntityIngredientRenderer.lambda$render$0((World)world, arg_0));
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    int scale = this.size / 2;
                    float height = entity.func_213302_cg();
                    float width = entity.func_213311_cf();
                    if (height > 2.0f || width > 2.0f) {
                        scale = (int)((float)this.size / Math.max(height, width));
                    }
                    try {
                        InventoryScreen.func_228187_a_((int)(x + this.size / 2), (int)(y + this.size), (int)scale, (float)0.0f, (float)10.0f, (LivingEntity)livingEntity);
                        return;
                    }
                    catch (Exception e) {
                        TConstruct.LOG.error("Error drawing entity " + type.getRegistryName(), (Throwable)e);
                        IGNORED_ENTITIES.add(type);
                        this.ENTITY_MAP.remove(type);
                    }
                } else {
                    IGNORED_ENTITIES.add(type);
                    this.ENTITY_MAP.remove(type);
                }
            }
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_110434_K().func_110577_a(EntityMeltingRecipeCategory.BACKGROUND_LOC);
            int offset = (this.size - 16) / 2;
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)(x + offset), (int)(y + offset), (float)149.0f, (float)58.0f, (int)16, (int)16, (int)256, (int)256);
        }
    }

    public List<ITextComponent> getTooltip(EntityType type, ITooltipFlag flag) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        tooltip.add(type.func_212546_e());
        if (flag.func_194127_a()) {
            tooltip.add((ITextComponent)new StringTextComponent(Objects.requireNonNull(type.getRegistryName()).toString()).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    public EntityIngredientRenderer(int size) {
        this.size = size;
    }

    private static /* synthetic */ Entity lambda$render$0(World world, EntityType t) {
        return t.func_200721_a(world);
    }
}

