/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;

public class HeldModifiableItemIterator {
    private static final SimpleCommandExceptionType FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)TConstruct.makeTranslation("command", "held_modifiable.failed"));
    private static final DynamicCommandExceptionType NONLIVING_ENTITY_EXCEPTION = new DynamicCommandExceptionType(error -> TConstruct.makeTranslation("command", "held_modifiable.failed.nonliving", error));
    private static final DynamicCommandExceptionType ITEMLESS_EXCEPTION = new DynamicCommandExceptionType(error -> TConstruct.makeTranslation("command", "held_modifiable.failed.no_item", error));
    private static final DynamicCommandExceptionType INVALID_ITEM = new DynamicCommandExceptionType(error -> TConstruct.makeTranslation("command", "held_modifiable.failed.invalid_item", error));

    public static List<LivingEntity> apply(CommandContext<CommandSource> context, HeldModifiableBehavior behavior) throws CommandSyntaxException {
        return HeldModifiableItemIterator.apply(EntityArgument.func_197097_b(context, (String)"targets"), behavior);
    }

    public static List<LivingEntity> apply(Collection<? extends Entity> targets, HeldModifiableBehavior behavior) throws CommandSyntaxException {
        ArrayList<LivingEntity> successes = new ArrayList<LivingEntity>();
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                ItemStack stack = living.func_184614_ca();
                if (!stack.func_190926_b()) {
                    if (TinkerTags.Items.MODIFIABLE.func_230235_a_((Object)stack.func_77973_b())) {
                        if (!behavior.accept(living, stack)) continue;
                        successes.add(living);
                        continue;
                    }
                    throw INVALID_ITEM.create((Object)entity.func_200200_C_().getString());
                }
                throw ITEMLESS_EXCEPTION.create((Object)entity.func_200200_C_().getString());
            }
            throw NONLIVING_ENTITY_EXCEPTION.create((Object)entity.func_200200_C_().getString());
        }
        if (successes.isEmpty()) {
            throw FAILED_EXCEPTION.create();
        }
        return successes;
    }

    public static interface HeldModifiableBehavior {
        public boolean accept(LivingEntity var1, ItemStack var2) throws CommandSyntaxException;
    }
}

