/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.subcommand;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.TablePrinter;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.TinkerRegistries;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.shared.command.argument.SlotTypeArgument;

public class ModifierUsageCommand {
    private static final ITextComponent SUCCESS = new TranslationTextComponent("command.tconstruct.modifier_usage");

    public static void register(LiteralArgumentBuilder<CommandSource> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(sender -> sender.func_197034_c(1))).executes(context -> ModifierUsageCommand.runForType((CommandContext<CommandSource>)context, ModifierUsages.ALL, null))).then(Commands.func_197057_a((String)"all").executes(context -> ModifierUsageCommand.runForType((CommandContext<CommandSource>)context, ModifierUsages.ALL, null)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"recipe").then(Commands.func_197056_a((String)"slot_type", (ArgumentType)SlotTypeArgument.slotType()).executes(ModifierUsageCommand::runRecipeWithFilter))).executes(context -> ModifierUsageCommand.runForType((CommandContext<CommandSource>)context, ModifierUsages.RECIPE, null)))).then(Commands.func_197057_a((String)"material_trait").executes(context -> ModifierUsageCommand.runForType((CommandContext<CommandSource>)context, ModifierUsages.MATERIAL_TRAIT, null)))).then(Commands.func_197057_a((String)"tool_trait").executes(context -> ModifierUsageCommand.runForType((CommandContext<CommandSource>)context, ModifierUsages.TOOL_TRAIT, null)))).then(Commands.func_197057_a((String)"unused").executes(context -> ModifierUsageCommand.runForType((CommandContext<CommandSource>)context, ModifierUsages.UNUSED, null)));
    }

    private static int runRecipeWithFilter(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return ModifierUsageCommand.runForType(context, ModifierUsages.RECIPE, SlotTypeArgument.getOptional(context, "slot_type"));
    }

    private static int runForType(CommandContext<CommandSource> context, ModifierUsages filter, @Nullable SlotTypeArgument.OptionalSlotType slotFilter) {
        Stream<Object> modifierStream;
        HashMultimap recipeModifiers = ((CommandSource)context.getSource()).func_197023_e().func_199532_z().func_215366_a(RecipeTypes.TINKER_STATION).values().stream().filter(r -> r instanceof IModifierRecipe).map(r -> (IModifierRecipe)r).collect(Collector.of(HashMultimap::create, (map, r) -> map.put((Object)r.getSlotType(), (Object)r.getModifier()), (m1, m2) -> {
            m1.putAll((Multimap)m2);
            return m1;
        }, new Collector.Characteristics[0]));
        IMaterialRegistry matReg = MaterialRegistry.getInstance();
        Set materialTraits = matReg.getAllMaterials().stream().flatMap(mat -> {
            MaterialId matId = mat.getIdentifier();
            return Stream.concat(matReg.getDefaultTraits(matId).stream(), matReg.getAllStats(matId).stream().filter(stat -> matReg.hasUniqueTraits(matId, stat.getIdentifier())).flatMap(stat -> matReg.getTraits(matId, stat.getIdentifier()).stream()));
        }).map(ModifierEntry::getModifier).collect(Collectors.toSet());
        Set toolTraits = TinkerTags.Items.MODIFIABLE.func_230236_b_().stream().filter(item -> item instanceof IModifiable).flatMap(item -> ((IModifiable)item).getToolDefinition().getData().getTraits().stream()).map(ModifierEntry::getModifier).collect(Collectors.toSet());
        switch (filter) {
            case RECIPE: {
                if (slotFilter != null) {
                    modifierStream = recipeModifiers.get((Object)slotFilter.getSlotType()).stream();
                    break;
                }
                modifierStream = recipeModifiers.values().stream();
                break;
            }
            case MATERIAL_TRAIT: {
                modifierStream = materialTraits.stream();
                break;
            }
            case TOOL_TRAIT: {
                modifierStream = toolTraits.stream();
                break;
            }
            default: {
                modifierStream = TinkerRegistries.MODIFIERS.getValues().stream();
            }
        }
        if (filter == ModifierUsages.UNUSED) {
            modifierStream = modifierStream.filter(modifier -> !recipeModifiers.containsValue(modifier) && !materialTraits.contains(modifier) && !toolTraits.contains(modifier));
        }
        TablePrinter table = new TablePrinter();
        table.header("ID", r -> r.getModifierId().toString());
        if (filter != ModifierUsages.UNUSED) {
            if (filter != ModifierUsages.RECIPE || slotFilter == null) {
                table.header("Recipe", ModifierUsageRow::getRecipe);
            }
            if (filter != ModifierUsages.MATERIAL_TRAIT) {
                table.header("material Trait", r -> r.isMaterialTrait() ? "Material trait" : "");
            }
            if (filter != ModifierUsages.TOOL_TRAIT) {
                table.header("tool Trait", r -> r.isToolTrait() ? "Tool trait" : "");
            }
        }
        StringBuilder logOutput = new StringBuilder();
        logOutput.append(filter.logPrefix);
        if (slotFilter != null) {
            if (slotFilter.getSlotType() == null) {
                logOutput.append(" (slotless)");
            } else {
                logOutput.append(" (").append(slotFilter.getSlotType().getName()).append(")");
            }
        }
        logOutput.append(System.lineSeparator());
        Collection finalList = modifierStream.sorted(Comparator.comparing(Modifier::getId)).collect(Collectors.toList());
        finalList.forEach(modifier -> {
            List recipeUsages = SlotType.getAllSlotTypes().stream().filter(type -> recipeModifiers.containsEntry(type, modifier)).map(SlotType::getName).collect(Collectors.toList());
            String recipes = recipeUsages.isEmpty() ? (recipeModifiers.containsEntry(null, modifier) ? "slotless" : "") : String.join((CharSequence)", ", recipeUsages);
            table.add((Object)new ModifierUsageRow(modifier.getId(), recipes, toolTraits.contains(modifier), materialTraits.contains(modifier)));
        });
        table.build(logOutput);
        TConstruct.LOG.info(logOutput.toString());
        ((CommandSource)context.getSource()).func_197030_a(SUCCESS, true);
        return finalList.size();
    }

    private static class ModifierUsageRow {
        private final ModifierId modifierId;
        private final String recipe;
        private final boolean toolTrait;
        private final boolean materialTrait;

        public ModifierUsageRow(ModifierId modifierId, String recipe, boolean toolTrait, boolean materialTrait) {
            this.modifierId = modifierId;
            this.recipe = recipe;
            this.toolTrait = toolTrait;
            this.materialTrait = materialTrait;
        }

        public ModifierId getModifierId() {
            return this.modifierId;
        }

        public String getRecipe() {
            return this.recipe;
        }

        public boolean isToolTrait() {
            return this.toolTrait;
        }

        public boolean isMaterialTrait() {
            return this.materialTrait;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModifierUsageRow)) {
                return false;
            }
            ModifierUsageRow other = (ModifierUsageRow)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ModifierId this$modifierId = this.getModifierId();
            ModifierId other$modifierId = other.getModifierId();
            if (this$modifierId == null ? other$modifierId != null : !((Object)((Object)this$modifierId)).equals((Object)other$modifierId)) {
                return false;
            }
            String this$recipe = this.getRecipe();
            String other$recipe = other.getRecipe();
            if (this$recipe == null ? other$recipe != null : !this$recipe.equals(other$recipe)) {
                return false;
            }
            if (this.isToolTrait() != other.isToolTrait()) {
                return false;
            }
            return this.isMaterialTrait() == other.isMaterialTrait();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModifierUsageRow;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ModifierId $modifierId = this.getModifierId();
            result = result * 59 + ($modifierId == null ? 43 : ((Object)((Object)$modifierId)).hashCode());
            String $recipe = this.getRecipe();
            result = result * 59 + ($recipe == null ? 43 : $recipe.hashCode());
            result = result * 59 + (this.isToolTrait() ? 79 : 97);
            result = result * 59 + (this.isMaterialTrait() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "ModifierUsageCommand.ModifierUsageRow(modifierId=" + (Object)((Object)this.getModifierId()) + ", recipe=" + this.getRecipe() + ", toolTrait=" + this.isToolTrait() + ", materialTrait=" + this.isMaterialTrait() + ")";
        }
    }

    private static enum ModifierUsages {
        UNUSED("Unused modifiers:"),
        RECIPE("Recipe modifiers:"),
        MATERIAL_TRAIT("Material trait modifiers:"),
        TOOL_TRAIT("Tool trait modifiers:"),
        ALL("All modifiers:");

        private final String logPrefix;

        private ModifierUsages(String logPrefix) {
            this.logPrefix = logPrefix;
        }
    }
}

