/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.controller;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import slimeknights.mantle.block.InventoryBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedBlock;

public abstract class ControllerBlock
extends InventoryBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    public static final BooleanProperty IN_STRUCTURE = SearedBlock.IN_STRUCTURE;

    protected ControllerBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)IN_STRUCTURE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, ACTIVE, IN_STRUCTURE});
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return (Boolean)state.func_177229_b((Property)IN_STRUCTURE) != false ? PathNodeType.DAMAGE_FIRE : PathNodeType.OPEN;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Deprecated
    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Deprecated
    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)mirror.func_185803_b((Direction)state.func_177229_b((Property)FACING)));
    }

    protected boolean canOpenGui(BlockState state) {
        return (Boolean)state.func_177229_b((Property)IN_STRUCTURE);
    }

    protected boolean displayStatus(PlayerEntity player, World world, BlockPos pos, BlockState state) {
        return false;
    }

    protected boolean openGui(PlayerEntity player, World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            if (this.canOpenGui(state)) {
                return super.openGui(player, world, pos);
            }
            return this.displayStatus(player, world, pos, state);
        }
        return false;
    }

    protected void spawnFireParticles(IWorld world, BlockState state, double x, double y, double z, double front, double side) {
        this.spawnFireParticles(world, state, x, y, z, front, side, (IParticleData)ParticleTypes.field_197631_x);
    }

    protected void spawnFireParticles(IWorld world, BlockState state, double x, double y, double z, double front, double side, IParticleData particle) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case WEST: {
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x - front, y, z + side, 0.0, 0.0, 0.0);
                world.func_195594_a(particle, x - front, y, z + side, 0.0, 0.0, 0.0);
                break;
            }
            case EAST: {
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + front, y, z + side, 0.0, 0.0, 0.0);
                world.func_195594_a(particle, x + front, y, z + side, 0.0, 0.0, 0.0);
                break;
            }
            case NORTH: {
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + side, y, z - front, 0.0, 0.0, 0.0);
                world.func_195594_a(particle, x + side, y, z - front, 0.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + side, y, z + front, 0.0, 0.0, 0.0);
                world.func_195594_a(particle, x + side, y, z + front, 0.0, 0.0, 0.0);
            }
        }
    }
}

