/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.util;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Set;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import slimeknights.tconstruct.smeltery.client.util.TintedVertexBuilder;

public class CastingItemRenderTypeBuffer
implements IRenderTypeBuffer {
    private static final Set<String> MAKE_TRANSPARENT = ImmutableSet.of((Object)"entity_solid", (Object)"entity_cutout", (Object)"entity_cutout_no_cull", (Object)"entity_translucent", (Object)"entity_no_outline");
    private final IRenderTypeBuffer inner;
    private final int alpha;
    private final int red;
    private final int green;
    private final int blue;

    public CastingItemRenderTypeBuffer(IRenderTypeBuffer inner, int alpha, int temperature) {
        this.inner = inner;
        this.alpha = MathHelper.func_76125_a((int)alpha, (int)0, (int)255);
        temperature = MathHelper.func_76125_a((int)temperature, (int)0, (int)255);
        this.red = 255 - temperature * 79 / 255;
        this.green = 255 - temperature * 159 / 255;
        this.blue = 255 - temperature * 223 / 255;
    }

    public IVertexBuilder getBuffer(RenderType type) {
        if (this.alpha < 255 && MAKE_TRANSPARENT.contains(type.field_228509_a_) && type instanceof RenderType.Type) {
            ResourceLocation texture = ((RenderType.Type)type).field_228668_S_.field_228677_a_.field_228602_Q_.orElse(PlayerContainer.field_226615_c_);
            type = RenderType.func_228642_d_((ResourceLocation)texture);
        }
        return new TintedVertexBuilder(this.inner.getBuffer(type), this.red, this.green, this.blue, this.alpha);
    }
}

