/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.util.TileEntityHelper;
import slimeknights.tconstruct.smeltery.tileentity.tank.ISmelteryTankHandler;

public class SmelteryTankUpdatePacket
implements IThreadsafePacket {
    private final BlockPos pos;
    private final List<FluidStack> fluids;

    public SmelteryTankUpdatePacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        int size = buffer.func_150792_a();
        this.fluids = new ArrayList<FluidStack>(size);
        for (int i = 0; i < size; ++i) {
            this.fluids.add(buffer.readFluidStack());
        }
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.func_150787_b(this.fluids.size());
        for (FluidStack fluid : this.fluids) {
            buffer.writeFluidStack(fluid);
        }
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    public SmelteryTankUpdatePacket(BlockPos pos, List<FluidStack> fluids) {
        this.pos = pos;
        this.fluids = fluids;
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(SmelteryTankUpdatePacket packet) {
            TileEntityHelper.getTile(ISmelteryTankHandler.class, (IBlockReader)Minecraft.func_71410_x().field_71441_e, (BlockPos)packet.pos).ifPresent(te -> te.updateFluidsFromPacket(packet.fluids));
        }
    }
}

